/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.result;

import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import com.bubing.camera.models.album.entity.Photo;
import com.bubing.camera.setting.Setting;
import java.util.ArrayList;

public class ResultStorage {
    public static ArrayList<Photo> photos = new ArrayList();

    public static int addPhoto(Photo photo) {
        if (Setting.videoCount != -1 || Setting.pictureCount != -1) {
            int number = ResultStorage.getVideoNumber();
            if (photo.type.contains("video") && number >= Setting.videoCount) {
                return -2;
            }
            number = photos.size() - number;
            if (!photo.type.contains("video") && number >= Setting.pictureCount) {
                return -1;
            }
        }
        photo.selected = true;
        photos.add(photo);
        return 0;
    }

    public static void removePhoto(Photo photo) {
        photo.selected = false;
        photos.remove(photo);
    }

    public static void removePhoto(int photoIndex) {
        ResultStorage.removePhoto(photos.get(photoIndex));
    }

    public static void removeAll() {
        int size = photos.size();
        for (int i = 0; i < size; ++i) {
            ResultStorage.removePhoto(0);
        }
    }

    private static int getVideoNumber() {
        int count = 0;
        for (Photo p : photos) {
            if (!p.type.contains("video")) continue;
            ++count;
        }
        return count;
    }

    public static void processOriginal() {
        boolean isIceApi;
        boolean bl = isIceApi = Build.VERSION.SDK_INT == 15;
        if (Setting.showOriginalMenu && Setting.originalMenuUsable) {
            for (Photo photo : photos) {
                photo.selectedOriginal = Setting.selectedOriginal;
                if (!isIceApi || photo.width != 0) continue;
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeFile((String)photo.path, (BitmapFactory.Options)options);
                photo.width = options.outWidth;
                photo.height = options.outHeight;
            }
        }
    }

    public static void clear() {
        photos.clear();
    }

    public static boolean isEmpty() {
        return photos.isEmpty();
    }

    public static int count() {
        return photos.size();
    }

    public static String getSelectorNumber(Photo photo) {
        return String.valueOf(photos.indexOf(photo) + 1);
    }

    public static String getPhotoPath(int position) {
        return ResultStorage.photos.get((int)position).path;
    }

    public static Uri getPhotoUri(int position) {
        return ResultStorage.photos.get((int)position).uri;
    }

    public static String getPhotoType(int position) {
        return ResultStorage.photos.get((int)position).type;
    }

    public static long getPhotoDuration(int position) {
        return ResultStorage.photos.get((int)position).duration;
    }
}

