/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.models.sticker;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.view.View;
import android.view.ViewGroup;
import androidx.fragment.app.FragmentManager;
import com.bubing.camera.models.sticker.cache.StickerCache;
import com.bubing.camera.models.sticker.entity.TextStickerData;
import com.bubing.camera.models.sticker.listener.OnStickerClickListener;
import com.bubing.camera.models.sticker.view.BitmapSticker;
import com.bubing.camera.models.sticker.view.EditStickerFragment;
import com.bubing.camera.models.sticker.view.TextSticker;
import com.bubing.camera.utils.bitmap.BitmapUtils;
import com.bubing.camera.utils.bitmap.SaveBitmapCallBack;
import java.util.ArrayList;
import java.util.List;

public class StickerModel {
    public static final ArrayList<TextStickerData> textDataList = new ArrayList();
    public List<BitmapSticker> bitmapStickers = new ArrayList<BitmapSticker>();
    public List<TextSticker> textStickers = new ArrayList<TextSticker>();
    public BitmapSticker currBitmapSticker;
    public TextSticker currTextSticker;

    public void addBitmapSticker(Context cxt, String imagePath, int imageResourceId, ViewGroup rootgroup) {
        if (this.bitmapStickers.size() > 0 && !this.bitmapStickers.get((int)(this.bitmapStickers.size() - 1)).isChecked) {
            this.bitmapStickers.get(this.bitmapStickers.size() - 1).delete();
        }
        final BitmapSticker sticker = new BitmapSticker(cxt, imagePath, imageResourceId, rootgroup.getWidth() / 2, rootgroup.getHeight() / 2);
        sticker.setOnStickerClickListener(new OnStickerClickListener(){

            @Override
            public void onDelete() {
                StickerModel.this.bitmapStickers.remove((Object)sticker);
            }

            @Override
            public void onEditor() {
            }

            @Override
            public void onTop() {
                StickerModel.this.bitmapStickers.remove((Object)sticker);
                StickerModel.this.bitmapStickers.add(sticker);
            }

            @Override
            public void onUsing() {
                if (StickerModel.this.currBitmapSticker != null && StickerModel.this.currBitmapSticker != sticker) {
                    StickerModel.this.currBitmapSticker.setUsing(false);
                    StickerModel.this.currBitmapSticker = sticker;
                }
            }
        });
        if (this.currBitmapSticker != null) {
            this.currBitmapSticker.setUsing(false);
        }
        rootgroup.addView((View)sticker);
        this.currBitmapSticker = sticker;
        this.bitmapStickers.add(sticker);
    }

    public void addTextSticker(Context cxt, final FragmentManager fragmentManager, String text, ViewGroup rootgroup) {
        if (this.textStickers.size() > 0 && !this.textStickers.get((int)(this.textStickers.size() - 1)).isChecked) {
            this.textStickers.get(this.textStickers.size() - 1).delete();
        }
        final TextSticker sticker = new TextSticker(cxt, text, rootgroup.getWidth() / 2, rootgroup.getHeight() / 2);
        sticker.setOnStickerClickListener(new OnStickerClickListener(){

            @Override
            public void onDelete() {
                StickerModel.this.textStickers.remove((Object)sticker);
            }

            @Override
            public void onEditor() {
                EditStickerFragment.show(fragmentManager, sticker);
            }

            @Override
            public void onTop() {
                StickerModel.this.textStickers.remove((Object)sticker);
                StickerModel.this.textStickers.add(sticker);
            }

            @Override
            public void onUsing() {
                if (StickerModel.this.currTextSticker != null && StickerModel.this.currTextSticker != sticker) {
                    StickerModel.this.currTextSticker.setUsing(false);
                    StickerModel.this.currTextSticker = sticker;
                }
            }
        });
        if (this.currBitmapSticker != null) {
            this.currBitmapSticker.setUsing(false);
        }
        rootgroup.addView((View)sticker);
        this.currTextSticker = sticker;
        this.textStickers.add(sticker);
    }

    public void save(Activity act, ViewGroup stickerGroup, View imageGroup, int imageWidth, int imageHeight, String dirPath, String namePrefix, boolean notifyMedia, SaveBitmapCallBack callBack) {
        if (null != this.currBitmapSticker && this.currBitmapSticker.isUsing()) {
            this.currBitmapSticker.setUsing(false);
        }
        if (null != this.currTextSticker && this.currTextSticker.isUsing()) {
            this.currTextSticker.setUsing(false);
        }
        for (BitmapSticker bs : this.bitmapStickers) {
            if (!bs.isUsing()) continue;
            bs.setUsing(false);
        }
        for (TextSticker ts : this.textStickers) {
            if (!ts.isUsing()) continue;
            ts.setUsing(false);
        }
        Bitmap srcBitmap = Bitmap.createBitmap((int)stickerGroup.getWidth(), (int)stickerGroup.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(srcBitmap);
        stickerGroup.draw(canvas);
        Bitmap cropBitmap = Bitmap.createBitmap((Bitmap)srcBitmap, (int)imageGroup.getLeft(), (int)imageGroup.getTop(), (int)imageGroup.getWidth(), (int)imageGroup.getHeight());
        BitmapUtils.recycle(srcBitmap);
        Bitmap saveBitmap = null;
        if (imageGroup.getWidth() > imageWidth || imageGroup.getHeight() > imageHeight) {
            saveBitmap = Bitmap.createScaledBitmap((Bitmap)cropBitmap, (int)imageWidth, (int)imageHeight, (boolean)true);
            BitmapUtils.recycle(cropBitmap);
        } else {
            saveBitmap = cropBitmap;
        }
        BitmapUtils.saveBitmapToDir(act, dirPath, namePrefix, saveBitmap, notifyMedia, callBack);
    }

    public void setCanvasSize(final Bitmap b, final ViewGroup imageGroup) {
        if (imageGroup.getMeasuredWidth() == 0) {
            imageGroup.post(new Runnable(){

                @Override
                public void run() {
                    StickerModel.this.setSize(b, imageGroup);
                }
            });
        } else {
            this.setSize(b, imageGroup);
        }
    }

    private void setSize(Bitmap b, ViewGroup v) {
        int bW = b.getWidth();
        int bH = b.getHeight();
        int vW = v.getMeasuredWidth();
        int vH = v.getMeasuredHeight();
        float scalW = (float)vW / (float)bW;
        float scalH = (float)vH / (float)bH;
        ViewGroup.LayoutParams params = v.getLayoutParams();
        if (bW >= bH) {
            params.width = vW;
            params.height = (int)(scalW * (float)bH);
        } else {
            params.width = (int)(scalH * (float)bW);
            params.height = vH;
        }
        if (params.width > vW) {
            float tempScaleW = (float)vW / (float)params.width;
            params.width = vW;
            params.height = (int)((float)params.height * tempScaleW);
        }
        if (params.height > vH) {
            float tempScaleH = (float)vH / (float)params.height;
            params.height = vH;
            params.width = (int)((float)params.width * tempScaleH);
        }
        v.setLayoutParams(params);
    }

    public void release() {
        StickerCache.get().clear();
    }
}

