/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.models.puzzle;

import android.graphics.RectF;
import com.bubing.camera.models.puzzle.Area;
import com.bubing.camera.models.puzzle.Line;
import java.util.ArrayList;
import java.util.List;

public interface PuzzleLayout {
    public void setOuterBounds(RectF var1);

    public void layout();

    public int getAreaCount();

    public List<Line> getOuterLines();

    public List<Line> getLines();

    public Area getOuterArea();

    public void update();

    public void reset();

    public Area getArea(int var1);

    public float width();

    public float height();

    public void setPadding(float var1);

    public float getPadding();

    public float getRadian();

    public void setRadian(float var1);

    public Info generateInfo();

    public void setColor(int var1);

    public int getColor();

    public static class LineInfo {
        public float startX;
        public float startY;
        public float endX;
        public float endY;

        public LineInfo(Line line) {
            this.startX = line.startPoint().x;
            this.startY = line.startPoint().y;
            this.endX = line.endPoint().x;
            this.endY = line.endPoint().y;
        }
    }

    public static class Step {
        public static final int ADD_LINE = 0;
        public static final int ADD_CROSS = 1;
        public static final int CUT_EQUAL_PART_ONE = 2;
        public static final int CUT_EQUAL_PART_TWO = 3;
        public static final int CUT_SPIRAL = 4;
        public int type;
        public int direction;
        public int position;
        public int part;
        public int hSize;
        public int vSize;
    }

    public static class Info {
        public static final int TYPE_STRAIGHT = 0;
        public static final int TYPE_SLANT = 1;
        public int type;
        public ArrayList<Step> steps;
        public ArrayList<LineInfo> lineInfos;
        public float padding;
        public float radian;
        public int color;
    }
}

