/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.models.compress;

import android.content.Context;
import com.bubing.camera.models.ResultPhoto;
import com.bubing.camera.models.compress.CompressConfig;
import com.bubing.camera.models.compress.CompressImage;
import com.bubing.camera.models.compress.LubanOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import me.shaohui.advancedluban.Luban;
import me.shaohui.advancedluban.OnCompressListener;
import me.shaohui.advancedluban.OnMultiCompressListener;

public class CompressWithLuBan
implements CompressImage {
    private ArrayList<ResultPhoto> images;
    private CompressImage.CompressListener listener;
    private Context context;
    private LubanOptions options;
    private ArrayList<File> files = new ArrayList();

    public CompressWithLuBan(Context context, CompressConfig config, ArrayList<ResultPhoto> images, CompressImage.CompressListener listener) {
        this.options = config.getLubanOptions();
        this.images = images;
        this.listener = listener;
        this.context = context;
    }

    @Override
    public void compress() {
        if (this.images == null || this.images.isEmpty()) {
            this.listener.onCompressFailed(this.images, " images is null");
            return;
        }
        for (ResultPhoto image : this.images) {
            if (image == null) {
                this.listener.onCompressFailed(this.images, " There are pictures of compress  is null.");
                return;
            }
            this.files.add(new File(image.getOriginalPath()));
        }
        if (this.images.size() == 1) {
            this.compressOne();
        } else {
            this.compressMulti();
        }
    }

    private void compressOne() {
        Luban.compress((Context)this.context, (File)this.files.get(0)).putGear(4).setMaxHeight(this.options.getMaxHeight()).setMaxWidth(this.options.getMaxWidth()).setMaxSize(this.options.getMaxSize() / 1000).launch(new OnCompressListener(){

            public void onStart() {
            }

            public void onSuccess(File file) {
                ResultPhoto image = (ResultPhoto)CompressWithLuBan.this.images.get(0);
                image.setCompressPath(file.getPath());
                image.setCompressed(true);
                CompressWithLuBan.this.listener.onCompressSuccess(CompressWithLuBan.this.images);
            }

            public void onError(Throwable e) {
                CompressWithLuBan.this.listener.onCompressFailed(CompressWithLuBan.this.images, e.getMessage() + " is compress failures");
            }
        });
    }

    private void compressMulti() {
        Luban.compress((Context)this.context, this.files).putGear(4).setMaxSize(this.options.getMaxSize() / 1000).setMaxHeight(this.options.getMaxHeight()).setMaxWidth(this.options.getMaxWidth()).launch(new OnMultiCompressListener(){

            public void onStart() {
            }

            public void onSuccess(List<File> fileList) {
                CompressWithLuBan.this.handleCompressCallBack(fileList);
            }

            public void onError(Throwable e) {
                CompressWithLuBan.this.listener.onCompressFailed(CompressWithLuBan.this.images, e.getMessage() + " is compress failures");
            }
        });
    }

    private void handleCompressCallBack(List<File> files) {
        int j = this.images.size();
        for (int i = 0; i < j; ++i) {
            ResultPhoto image = this.images.get(i);
            image.setCompressed(true);
            image.setCompressPath(files.get(i).getPath());
        }
        this.listener.onCompressSuccess(this.images);
    }
}

