package com.bubing.camera.models.album.entity;

import android.net.Uri;

import java.util.ArrayList;
import java.util.LinkedHashMap;
/**
 * @ClassName: Album
 * @Description: 专辑模型实体类
 * @Author: bubing
 * @Date: 2020-05-09 17:48
 */
public class Album {
    public ArrayList<AlbumItem> albumItems;
    private LinkedHashMap<String, AlbumItem> hasAlbumItems;//用于记录专辑项目

    public Album() {
        albumItems = new ArrayList<>();
        hasAlbumItems = new LinkedHashMap<>();
    }

    private void addAlbumItem(AlbumItem albumItem) {
        this.hasAlbumItems.put(albumItem.name, albumItem);
        this.albumItems.add(albumItem);
    }

    public void addAlbumItem(String name, String folderPath, String coverImagePath, Uri coverImageUri) {
        if (null == hasAlbumItems.get(name)) {
            addAlbumItem(new AlbumItem(name, folderPath, coverImagePath,coverImageUri));
        }
    }

    public AlbumItem getAlbumItem(String name) {
        return hasAlbumItems.get(name);
    }

    public AlbumItem getAlbumItem(int currIndex) {
        return albumItems.get(currIndex);
    }

    public boolean isEmpty() {
        return albumItems.isEmpty();
    }

    public void clear() {
        albumItems.clear();
        hasAlbumItems.clear();
    }
}
