/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.utils.system;

import android.app.Activity;
import android.os.Build;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MeiZuStatusUtils {
    private static Method mSetStatusBarColorIcon;
    private static Method mSetStatusBarDarkIcon;
    private static Field mStatusBarColorFiled;
    private static int SYSTEM_UI_FLAG_LIGHT_STATUS_BAR;

    public static boolean isBlackColor(int color2, int level) {
        int grey = MeiZuStatusUtils.toGrey(color2);
        return grey < level;
    }

    public static int toGrey(int rgb) {
        int blue = rgb & 0xFF;
        int green = (rgb & 0xFF00) >> 8;
        int red = (rgb & 0xFF0000) >> 16;
        return red * 38 + green * 75 + blue * 15 >> 7;
    }

    public static void setStatusBarDarkIcon(Activity activity, int color2) {
        if (mSetStatusBarColorIcon != null) {
            try {
                mSetStatusBarColorIcon.invoke((Object)activity, color2);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            boolean whiteColor = MeiZuStatusUtils.isBlackColor(color2, 50);
            if (mStatusBarColorFiled != null) {
                MeiZuStatusUtils.setStatusBarDarkIcon(activity, whiteColor, whiteColor);
                MeiZuStatusUtils.setStatusBarDarkIcon(activity.getWindow(), color2);
            } else {
                MeiZuStatusUtils.setStatusBarDarkIcon(activity, whiteColor);
            }
        }
    }

    public static void setStatusBarDarkIcon(Window window, int color2) {
        try {
            MeiZuStatusUtils.setStatusBarColor(window, color2);
            if (Build.VERSION.SDK_INT > 22) {
                MeiZuStatusUtils.setStatusBarDarkIcon(window.getDecorView(), true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setStatusBarDarkIcon(Activity activity, boolean dark) {
        MeiZuStatusUtils.setStatusBarDarkIcon(activity, dark, true);
    }

    private static boolean changeMeizuFlag(WindowManager.LayoutParams winParams, String flagName, boolean on) {
        try {
            int meizuFlags;
            Field f = winParams.getClass().getDeclaredField(flagName);
            f.setAccessible(true);
            int bits = f.getInt(winParams);
            Field f2 = winParams.getClass().getDeclaredField("meizuFlags");
            f2.setAccessible(true);
            int oldFlags = meizuFlags = f2.getInt(winParams);
            meizuFlags = on ? (meizuFlags |= bits) : (meizuFlags &= ~bits);
            if (oldFlags != meizuFlags) {
                f2.setInt(winParams, meizuFlags);
                return true;
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    private static void setStatusBarDarkIcon(View view, boolean dark) {
        int oldVis;
        int newVis = oldVis = view.getSystemUiVisibility();
        newVis = dark ? (newVis |= SYSTEM_UI_FLAG_LIGHT_STATUS_BAR) : (newVis &= ~SYSTEM_UI_FLAG_LIGHT_STATUS_BAR);
        if (newVis != oldVis) {
            view.setSystemUiVisibility(newVis);
        }
    }

    private static void setStatusBarColor(Window window, int color2) {
        WindowManager.LayoutParams winParams = window.getAttributes();
        if (mStatusBarColorFiled != null) {
            try {
                int oldColor = mStatusBarColorFiled.getInt(winParams);
                if (oldColor != color2) {
                    mStatusBarColorFiled.set(winParams, color2);
                    window.setAttributes(winParams);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static void setStatusBarDarkIcon(Window window, boolean dark) {
        if (Build.VERSION.SDK_INT < 23) {
            MeiZuStatusUtils.changeMeizuFlag(window.getAttributes(), "MEIZU_FLAG_DARK_STATUS_BAR_ICON", dark);
        } else {
            View decorView = window.getDecorView();
            if (decorView != null) {
                MeiZuStatusUtils.setStatusBarDarkIcon(decorView, dark);
                MeiZuStatusUtils.setStatusBarColor(window, 0);
            }
        }
    }

    private static void setStatusBarDarkIcon(Activity activity, boolean dark, boolean flag) {
        if (mSetStatusBarDarkIcon != null) {
            try {
                mSetStatusBarDarkIcon.invoke((Object)activity, dark);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else if (flag) {
            MeiZuStatusUtils.setStatusBarDarkIcon(activity.getWindow(), dark);
        }
    }

    static {
        SYSTEM_UI_FLAG_LIGHT_STATUS_BAR = 0;
        try {
            mSetStatusBarColorIcon = Activity.class.getMethod("setStatusBarDarkIcon", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        try {
            mSetStatusBarDarkIcon = Activity.class.getMethod("setStatusBarDarkIcon", Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        try {
            mStatusBarColorFiled = WindowManager.LayoutParams.class.getField("statusBarColor");
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        try {
            Field field = View.class.getField("SYSTEM_UI_FLAG_LIGHT_STATUS_BAR");
            SYSTEM_UI_FLAG_LIGHT_STATUS_BAR = field.getInt(null);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

