/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.utils;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import com.bubing.camera.constant.ImageType;
import com.bubing.camera.exception.BException;
import com.bubing.camera.models.ResultPhoto;
import com.bubing.camera.models.album.entity.Photo;
import com.bubing.camera.utils.ImageFiles;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PhotoUtils {
    public static Photo getPhoto(Context mContext, Uri uri) {
        if (mContext == null || uri == null) {
            return null;
        }
        Cursor cursor = mContext.getContentResolver().query(uri, null, null, null, null);
        if (cursor == null) {
            return null;
        }
        Photo mPhoto = null;
        if (cursor.moveToFirst()) {
            String path = cursor.getString(cursor.getColumnIndex("_data"));
            String name = cursor.getString(cursor.getColumnIndex("_display_name"));
            long dateTime = cursor.getLong(cursor.getColumnIndex("date_modified"));
            String type = cursor.getString(cursor.getColumnIndex("mime_type"));
            long size = cursor.getLong(cursor.getColumnIndex("_size"));
            int width = cursor.getInt(cursor.getColumnIndex("width"));
            int height = cursor.getInt(cursor.getColumnIndex("height"));
            mPhoto = new Photo(name, uri, path, dateTime, width, height, size, 0L, type);
        }
        cursor.close();
        return mPhoto;
    }

    public static ResultPhoto getCropPhoto(Activity activity, Photo photo, ImageType imageType) throws BException {
        ResultPhoto resultPhoto = new ResultPhoto();
        resultPhoto.setUri(photo.uri);
        resultPhoto.setName(photo.name);
        resultPhoto.setPath(photo.path);
        resultPhoto.setType(photo.type);
        resultPhoto.setWidth(photo.width);
        resultPhoto.setHeight(photo.height);
        resultPhoto.setSize(photo.size);
        resultPhoto.setDuration(photo.duration);
        resultPhoto.setTime(photo.time);
        resultPhoto.setSelectedOriginal(photo.selectedOriginal);
        resultPhoto.setImageType(imageType);
        resultPhoto.setOriginalUri(Uri.fromFile((File)ImageFiles.getCropTempFile(activity, photo.uri)));
        resultPhoto.setOriginalPath(resultPhoto.getOriginalUri().getPath());
        return resultPhoto;
    }

    public static ResultPhoto getResultPhoto(Activity activity, Photo photo, ImageType imageType) {
        ResultPhoto resultPhoto = new ResultPhoto();
        resultPhoto.setUri(photo.uri);
        resultPhoto.setName(photo.name);
        resultPhoto.setPath(photo.path);
        resultPhoto.setType(photo.type);
        resultPhoto.setWidth(photo.width);
        resultPhoto.setHeight(photo.height);
        resultPhoto.setSize(photo.size);
        resultPhoto.setDuration(photo.duration);
        resultPhoto.setTime(photo.time);
        resultPhoto.setSelectedOriginal(photo.selectedOriginal);
        resultPhoto.setImageType(imageType);
        resultPhoto.setOriginalUri(photo.uri);
        resultPhoto.setOriginalPath(photo.path);
        return resultPhoto;
    }

    public static List<ResultPhoto> getResultPhotos(Activity activity, List<Photo> photos, ImageType imageType) {
        ArrayList<ResultPhoto> resultPhotos = new ArrayList<ResultPhoto>();
        try {
            for (Photo photo : photos) {
                resultPhotos.add(PhotoUtils.getCropPhoto(activity, photo, imageType));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultPhotos;
    }

    public static ArrayList<Photo> getPhotos(Activity activity, List<ResultPhoto> resultPhotos, ImageType imageType) {
        ArrayList<Photo> photos = new ArrayList<Photo>();
        Photo photo = null;
        for (ResultPhoto resultPhoto : resultPhotos) {
            photo = new Photo();
            photo.uri = resultPhoto.getUri();
            photo.name = resultPhoto.getName();
            photo.path = resultPhoto.getPath();
            photo.type = resultPhoto.getType();
            photo.width = resultPhoto.getWidth();
            photo.height = resultPhoto.getHeight();
            photo.size = resultPhoto.getSize();
            photo.duration = resultPhoto.getDuration();
            photo.time = resultPhoto.getTime();
            photo.selectedOriginal = resultPhoto.isSelectedOriginal();
            photos.add(photo);
        }
        return photos;
    }
}

