/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import com.bubing.camera.utils.UriUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ImageRotateUtil {
    public static ImageRotateUtil of() {
        return new ImageRotateUtil();
    }

    private ImageRotateUtil() {
    }

    public void correctImage(Context context, Uri path) {
        String imagePath = UriUtils.parseOwnUri(context, path);
        int degree = this.getBitmapDegree(imagePath);
        if (degree != 0) {
            Bitmap bitmap = BitmapFactory.decodeFile((String)imagePath);
            if (bitmap == null) {
                return;
            }
            Bitmap resultBitmap = this.rotateBitmapByDegree(bitmap, degree);
            if (resultBitmap == null) {
                return;
            }
            try {
                resultBitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)new FileOutputStream(new File(imagePath)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace();
            }
        }
    }

    private int getBitmapDegree(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }

    private Bitmap rotateBitmapByDegree(Bitmap bm, int degree) {
        Bitmap returnBm = null;
        Matrix matrix = new Matrix();
        matrix.postRotate((float)degree);
        try {
            returnBm = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)bm.getWidth(), (int)bm.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        if (returnBm == null) {
            returnBm = bm;
        }
        if (bm != returnBm) {
            bm.recycle();
        }
        return returnBm;
    }
}

