/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import androidx.core.content.FileProvider;
import com.bubing.camera.utils.BubingLog;
import com.bubing.camera.utils.StringUtils;
import com.bubing.camera.utils.TimeUtils;
import com.bubing.camera.utils.UriUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

public class FilePathUtils {
    private static final String TAG = FilePathUtils.class.getName();
    private static FilePathUtils instance;
    private static String ROOT_DIR;
    public static String DIR_TEMP;
    public static String DIR_SPEECH;
    public static String DIR_VIDEO_TO;
    public static String DIR_VIDEO_FROM;
    public static String DIR_SETTINGS;
    public static String DIR_PHOTO_TO;
    public static String DIR_PHOTO_FROM;
    public static String DIR_CHAT_COVER;
    public static String DIR_ASSETBUNDLE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FilePathUtils getInstance() {
        if (instance != null) return instance;
        Class<FilePathUtils> clazz = FilePathUtils.class;
        synchronized (FilePathUtils.class) {
            if (instance != null) return instance;
            instance = new FilePathUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getFileDir(Context app, FileType type) {
        String dir = null;
        switch (type) {
            case BASE: {
                dir = this.getFilesPath(app, "");
                break;
            }
            case TEMP: {
                dir = this.getFilesPath(app, DIR_TEMP);
                break;
            }
            case SPEECH: {
                dir = this.getFilesPath(app, DIR_SPEECH);
                break;
            }
            case VIDEO_TO: {
                dir = this.getFilesPath(app, DIR_VIDEO_TO);
                break;
            }
            case VIDEO_FROM: {
                dir = this.getFilesPath(app, DIR_VIDEO_FROM);
                break;
            }
            case SETTINGS: {
                dir = this.getFilesPath(app, DIR_SETTINGS);
                break;
            }
            case PHOTO_TO: {
                dir = this.getFilesPath(app, DIR_PHOTO_TO);
                break;
            }
            case PHOTO_FROM: {
                dir = this.getFilesPath(app, DIR_PHOTO_FROM);
                break;
            }
            case CHAT_COVER: {
                dir = this.getFilesPath(app, DIR_CHAT_COVER);
                break;
            }
            case ASSETBUNDLE: {
                dir = this.getFilesPath(app, DIR_ASSETBUNDLE);
            }
        }
        return dir;
    }

    private String getFilesPath(Context app, String folderPath) {
        File file = app.getExternalFilesDir(folderPath);
        if (file != null) {
            if (!file.exists() || !file.isDirectory()) {
                file.mkdirs();
            }
        } else {
            return "";
        }
        StringBuilder absoluteFolderPath = new StringBuilder(file.getAbsolutePath());
        if (!absoluteFolderPath.toString().endsWith("/")) {
            absoluteFolderPath.append("/");
        }
        return absoluteFolderPath.toString();
    }

    private File getFilePath(Context app, String folderPath) {
        File file = app.getExternalFilesDir(folderPath);
        if (file != null) {
            if (!file.exists() || !file.isDirectory()) {
                file.mkdirs();
            }
        } else {
            return new File("");
        }
        return file;
    }

    public String getFileCacheDir(Context app, FileType type) {
        String dir = null;
        switch (type) {
            case BASE: {
                dir = this.getFilesCachePath(app, "");
                break;
            }
            case TEMP: {
                dir = this.getFilesCachePath(app, DIR_TEMP);
                break;
            }
            case SPEECH: {
                dir = this.getFilesCachePath(app, DIR_SPEECH);
                break;
            }
            case VIDEO_TO: {
                dir = this.getFilesCachePath(app, DIR_VIDEO_TO);
                break;
            }
            case VIDEO_FROM: {
                dir = this.getFilesCachePath(app, DIR_VIDEO_FROM);
                break;
            }
            case SETTINGS: {
                dir = this.getFilesCachePath(app, DIR_SETTINGS);
                break;
            }
            case PHOTO_TO: {
                dir = this.getFilesCachePath(app, DIR_PHOTO_TO);
                break;
            }
            case PHOTO_FROM: {
                dir = this.getFilesCachePath(app, DIR_PHOTO_FROM);
                break;
            }
            case CHAT_COVER: {
                dir = this.getFilesCachePath(app, DIR_CHAT_COVER);
                break;
            }
            case ASSETBUNDLE: {
                dir = this.getFilesCachePath(app, DIR_ASSETBUNDLE);
            }
        }
        return dir;
    }

    public String getFilesCachePath(Context context, String folderPath) {
        File file;
        StringBuilder absoluteFolderPath;
        File cacheDir = "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable() ? context.getExternalCacheDir() : context.getCacheDir();
        if (cacheDir == null) {
            cacheDir = context.getCacheDir();
        }
        if (!(absoluteFolderPath = new StringBuilder((file = new File(cacheDir.getPath() + File.separator + folderPath)).getAbsolutePath())).toString().endsWith("/")) {
            absoluteFolderPath.append("/");
        }
        return absoluteFolderPath.toString();
    }

    public File getFileCachePath(Context context, String folderPath) {
        File cacheDir = "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable() ? context.getExternalCacheDir() : context.getCacheDir();
        if (cacheDir == null) {
            cacheDir = context.getCacheDir();
        }
        return new File(cacheDir.getPath() + File.separator + folderPath);
    }

    public static File getFileDcimDir(Context app) {
        String cacheDirPath;
        File dcimDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        if (null == dcimDir) {
            File tempPath = Environment.getExternalStorageDirectory();
            File cameraFile = new File(tempPath + File.separator + "\u76f8\u673a");
            dcimDir = (Build.FINGERPRINT.toLowerCase().contains("vivo") || Build.BRAND.toLowerCase().contains("vivo")) && cameraFile.exists() ? new File(tempPath, File.separator + "\u76f8\u673a" + File.separator) : new File(tempPath, File.separator + "DCIM" + File.separator + "Camera" + File.separator);
        }
        if (!(dcimDir.exists() && dcimDir.isDirectory() || dcimDir.mkdirs() || null != (dcimDir = app.getExternalFilesDir(null)) && dcimDir.exists() || null != (dcimDir = app.getFilesDir()) && dcimDir.exists() || (dcimDir = new File(cacheDirPath = File.separator + "data" + File.separator + "data" + File.separator + app.getPackageName() + File.separator + "cache" + File.separator)).exists())) {
            dcimDir.mkdirs();
        }
        return dcimDir;
    }

    public void clearFilesBeforeDay(Context app, FileType fileType, int day) {
        String fileName = this.getFileDir(app, fileType);
        if (StringUtils.isEmpty(fileName)) {
            return;
        }
        File dir = new File(fileName);
        Date now = new Date();
        if (!dir.isDirectory()) {
            return;
        }
        File[] childFiles = dir.listFiles();
        if (childFiles == null || childFiles.length == 0) {
            return;
        }
        for (File file : childFiles) {
            Date date = new Date(file.lastModified());
            int timeDiff = TimeUtils.differentDays(now, date);
            if (timeDiff <= day) continue;
            file.delete();
        }
    }

    public void clearFilesByPrefix(Context app, FileType fileType, String prefix) {
        File dir = new File(this.getFileDir(app, fileType));
        if (!dir.isDirectory()) {
            return;
        }
        File[] childFiles = dir.listFiles();
        if (childFiles == null || childFiles.length == 0) {
            return;
        }
        for (File file : childFiles) {
            if (!file.getName().startsWith(prefix)) continue;
            file.delete();
        }
    }

    public Uri getFileUri(Context context, File file) {
        Uri uriSource = null;
        if (Build.VERSION.SDK_INT < 24 || Build.FINGERPRINT.toLowerCase().contains("lenovo") || Build.BRAND.toLowerCase().contains("lenovo")) {
            BubingLog.i(TAG, "\u8054\u60f3.");
            uriSource = Uri.fromFile((File)file);
        } else {
            uriSource = FileProvider.getUriForFile((Context)context, (String)UriUtils.getFileProviderName(context), (File)file);
        }
        return uriSource;
    }

    public static String saveBitmapToSD(Context context, Bitmap bt) {
        String fileDir = FilePathUtils.getInstance().getFileDir(context, FileType.TEMP);
        String filePth = fileDir + "logo.jpeg";
        File logFile = new File(filePth);
        if (logFile.exists()) {
            return filePth;
        }
        try {
            FileOutputStream fileout = new FileOutputStream(filePth);
            BufferedOutputStream bufferOutStream = new BufferedOutputStream(fileout);
            bt.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bufferOutStream);
            bufferOutStream.flush();
            bufferOutStream.close();
        }
        catch (IOException e) {
            BubingLog.e(TAG, "Err when saving bitmap...");
            e.printStackTrace();
        }
        return filePth;
    }

    public void saveFile(FileType type, File file) {
    }

    public File getFile(Context app, FileType type, String url) {
        String fileName = url.substring(url.lastIndexOf("/") + 1);
        return new File(this.getFileDir(app, type) + File.separator + fileName);
    }

    public static void delete(File file) {
        if (file.isFile() && file.exists()) {
            file.delete();
            return;
        }
        if (file.isDirectory()) {
            File[] childFiles = file.listFiles();
            if (childFiles == null || childFiles.length == 0) {
                file.delete();
                return;
            }
            for (File childFile : childFiles) {
                FilePathUtils.delete(childFile);
            }
            file.delete();
        }
    }

    static {
        ROOT_DIR = "BubingCamera" + File.separator;
        DIR_TEMP = ROOT_DIR + "Temp" + File.separator;
        DIR_SPEECH = ROOT_DIR + "Speech" + File.separator;
        DIR_VIDEO_TO = ROOT_DIR + "Video_to" + File.separator;
        DIR_VIDEO_FROM = ROOT_DIR + "Video_from" + File.separator;
        DIR_SETTINGS = ROOT_DIR + "Settings" + File.separator;
        DIR_PHOTO_TO = ROOT_DIR + "Photo_to" + File.separator;
        DIR_PHOTO_FROM = ROOT_DIR + "Photo_from" + File.separator;
        DIR_CHAT_COVER = ROOT_DIR + "Chat_Cover" + File.separator;
        DIR_ASSETBUNDLE = ROOT_DIR + "AssetBundle" + File.separator;
    }

    public static enum FileType {
        BASE,
        TEMP,
        PHOTO_TO,
        PHOTO_FROM,
        SPEECH,
        VIDEO_TO,
        VIDEO_FROM,
        CHAT_COVER,
        SETTINGS,
        ASSETBUNDLE;

    }
}

