/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.utils;

import android.text.TextUtils;
import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;

public class BubingLog {
    public static String customTagPrefix = "BubingLog_";
    public static boolean allowD = true;
    public static boolean allowE = true;
    public static boolean allowI = true;
    public static boolean allowV = true;
    public static boolean allowW = true;
    public static boolean allowWtf = true;
    public static CustomLogger customLogger;

    private BubingLog() {
    }

    public static void debug(String tag) {
        BubingLog.debug(tag, true);
    }

    public static void debug(String tag, boolean isPrintException) {
        String tempTag;
        customTagPrefix = tempTag = TextUtils.isEmpty((CharSequence)tag) ? "BubingLog_" : tag;
        allowE = isPrintException;
        allowD = isPrintException;
        allowI = isPrintException;
        allowV = isPrintException;
    }

    private static String generateTag(StackTraceElement caller) {
        String tag = "%s.%s(L:%d)";
        String callerClazzName = caller.getClassName();
        callerClazzName = callerClazzName.substring(callerClazzName.lastIndexOf(".") + 1);
        tag = String.format(tag, callerClazzName, caller.getMethodName(), caller.getLineNumber());
        tag = TextUtils.isEmpty((CharSequence)customTagPrefix) ? tag : customTagPrefix + ":" + tag;
        return tag;
    }

    public static StackTraceElement getCallerStackTraceElement() {
        return Thread.currentThread().getStackTrace()[4];
    }

    public static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static void d(String content) {
        BubingLog.d("", content);
    }

    public static void d(String tag, String content) {
        BubingLog.d(tag, content, null);
    }

    public static void d(String content, Throwable tr) {
        BubingLog.d("", content, tr);
    }

    public static void d(String tag, String content, Throwable tr) {
        if (!allowD) {
            return;
        }
        StackTraceElement caller = BubingLog.getCallerStackTraceElement();
        tag = TextUtils.isEmpty((CharSequence)tag) ? BubingLog.generateTag(caller) : BubingLog.generateTag(caller) + ":" + tag;
        if (customLogger != null) {
            if (tr == null) {
                customLogger.d(tag, content);
            } else {
                customLogger.d(tag, content, tr);
            }
        } else if (tr == null) {
            Log.d((String)tag, (String)content);
        } else {
            Log.d((String)tag, (String)content, (Throwable)tr);
        }
    }

    public static void e(String content) {
        BubingLog.e("", content);
    }

    public static void e(String tag, String content) {
        if (!allowE) {
            return;
        }
        StackTraceElement caller = BubingLog.getCallerStackTraceElement();
        tag = TextUtils.isEmpty((CharSequence)tag) ? BubingLog.generateTag(caller) : BubingLog.generateTag(caller) + ":" + tag;
        if (customLogger != null) {
            customLogger.e(tag, content);
        } else {
            Log.e((String)tag, (String)content);
        }
    }

    public static void e(Exception e) {
        BubingLog.e("", e);
    }

    public static void e(String tag, Exception e) {
        if (!allowE) {
            return;
        }
        StackTraceElement caller = BubingLog.getCallerStackTraceElement();
        tag = TextUtils.isEmpty((CharSequence)tag) ? BubingLog.generateTag(caller) : BubingLog.generateTag(caller) + ":" + tag;
        if (customLogger != null) {
            customLogger.e(tag, e.getMessage(), e);
        } else {
            Log.e((String)tag, (String)e.getMessage(), (Throwable)e);
        }
    }

    public static void e(String content, Throwable tr) {
        BubingLog.e("", content, tr);
    }

    public static void e(String tag, String content, Throwable tr) {
        if (!allowE) {
            return;
        }
        StackTraceElement caller = BubingLog.getCallerStackTraceElement();
        tag = TextUtils.isEmpty((CharSequence)tag) ? BubingLog.generateTag(caller) : BubingLog.generateTag(caller) + ":" + tag;
        if (customLogger != null) {
            customLogger.e(tag, content, tr);
        } else {
            Log.e((String)tag, (String)content, (Throwable)tr);
        }
    }

    public static void i(String content) {
        BubingLog.i("", content);
    }

    public static void i(String tag, String content) {
        BubingLog.i(tag, content, null);
    }

    public static void i(String content, Throwable tr) {
        BubingLog.i("", content, tr);
    }

    public static void i(String tag, String content, Throwable tr) {
        if (!allowI) {
            return;
        }
        StackTraceElement caller = BubingLog.getCallerStackTraceElement();
        tag = TextUtils.isEmpty((CharSequence)tag) ? BubingLog.generateTag(caller) : BubingLog.generateTag(caller) + ":" + tag;
        if (customLogger != null) {
            if (tr == null) {
                customLogger.i(tag, content);
            } else {
                customLogger.i(tag, content, tr);
            }
        } else if (tr == null) {
            Log.i((String)tag, (String)content);
        } else {
            Log.i((String)tag, (String)content, (Throwable)tr);
        }
    }

    public static void v(String content) {
        BubingLog.v("", content);
    }

    public static void v(String tag, String content) {
        BubingLog.v(tag, content, null);
    }

    public static void v(String content, Throwable tr) {
        BubingLog.v("", content, tr);
    }

    public static void v(String tag, String content, Throwable tr) {
        if (!allowV) {
            return;
        }
        StackTraceElement caller = BubingLog.getCallerStackTraceElement();
        tag = TextUtils.isEmpty((CharSequence)tag) ? BubingLog.generateTag(caller) : BubingLog.generateTag(caller) + ":" + tag;
        if (customLogger != null) {
            if (tr == null) {
                customLogger.v(tag, content);
            } else {
                customLogger.v(tag, content, tr);
            }
        } else if (tr == null) {
            Log.v((String)tag, (String)content);
        } else {
            Log.v((String)tag, (String)content, (Throwable)tr);
        }
    }

    public static void w(String content) {
        BubingLog.w("", content);
    }

    public static void w(String tag, String content) {
        BubingLog.w(tag, content, null);
    }

    public static void w(Throwable tr) {
        BubingLog.w("", tr);
    }

    public static void w(String content, Throwable tr) {
        BubingLog.w("", content, tr);
    }

    public static void w(String tag, String content, Throwable tr) {
        if (!allowW) {
            return;
        }
        StackTraceElement caller = BubingLog.getCallerStackTraceElement();
        tag = TextUtils.isEmpty((CharSequence)tag) ? BubingLog.generateTag(caller) : BubingLog.generateTag(caller) + ":" + tag;
        if (customLogger != null) {
            if (tr == null) {
                customLogger.w(tag, content);
            } else if (TextUtils.isEmpty((CharSequence)content)) {
                customLogger.w(tag, content, tr);
            } else {
                customLogger.w(tag, tr);
            }
        } else if (tr == null) {
            Log.w((String)tag, (String)content);
        } else if (TextUtils.isEmpty((CharSequence)content)) {
            Log.w((String)tag, (Throwable)tr);
        } else {
            Log.w((String)tag, (String)content, (Throwable)tr);
        }
    }

    public static void wtf(String content) {
        BubingLog.wtf("", content, null);
    }

    public static void wtf(String tag, String content) {
        BubingLog.wtf(tag, content, null);
    }

    public static void wtf(Throwable tr) {
        BubingLog.wtf("", "", tr);
    }

    public static void wtf(String content, Throwable tr) {
        BubingLog.wtf("", content, tr);
    }

    public static void wtf(String tag, String content, Throwable tr) {
        if (!allowWtf) {
            return;
        }
        StackTraceElement caller = BubingLog.getCallerStackTraceElement();
        tag = TextUtils.isEmpty((CharSequence)tag) ? BubingLog.generateTag(caller) : BubingLog.generateTag(caller) + ":" + tag;
        if (customLogger != null) {
            if (tr == null) {
                customLogger.wtf(tag, content);
            } else if (TextUtils.isEmpty((CharSequence)content)) {
                customLogger.wtf(tag, content, tr);
            } else {
                customLogger.wtf(tag, tr);
            }
        } else if (tr == null) {
            Log.wtf((String)tag, (String)content);
        } else if (TextUtils.isEmpty((CharSequence)content)) {
            Log.wtf((String)tag, (Throwable)tr);
        } else {
            Log.wtf((String)tag, (String)content, (Throwable)tr);
        }
    }

    public static interface CustomLogger {
        public void d(String var1, String var2);

        public void d(String var1, String var2, Throwable var3);

        public void e(String var1, String var2);

        public void e(String var1, String var2, Throwable var3);

        public void i(String var1, String var2);

        public void i(String var1, String var2, Throwable var3);

        public void v(String var1, String var2);

        public void v(String var1, String var2, Throwable var3);

        public void w(String var1, String var2);

        public void w(String var1, String var2, Throwable var3);

        public void w(String var1, Throwable var2);

        public void wtf(String var1, String var2);

        public void wtf(String var1, String var2, Throwable var3);

        public void wtf(String var1, Throwable var2);
    }
}

