/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.widget.RelativeLayout;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.bubing.camera.R;
import com.bubing.camera.models.album.AlbumModel;
import com.bubing.camera.models.album.entity.Photo;
import com.bubing.camera.setting.Setting;
import com.bubing.camera.ui.PuzzleActivity;
import com.bubing.camera.ui.adapter.AlbumItemsAdapter;
import com.bubing.camera.ui.adapter.PuzzleSelectorAdapter;
import com.bubing.camera.ui.adapter.PuzzleSelectorPreviewAdapter;
import com.bubing.camera.utils.BubingLog;
import com.bubing.camera.utils.ColorUtils;
import com.bubing.camera.utils.FilePathUtils;
import com.bubing.camera.utils.system.SystemUtils;
import com.bubing.camera.widget.PressedTextView;
import java.util.ArrayList;

public class PuzzleSelectorActivity
extends AppCompatActivity
implements View.OnClickListener,
AlbumItemsAdapter.OnClickListener,
PuzzleSelectorAdapter.OnClickListener,
PuzzleSelectorPreviewAdapter.OnClickListener {
    private static final String TAG = PuzzleSelectorActivity.class.getName();
    private AlbumModel albumModel;
    private AnimatorSet setShow;
    private AnimatorSet setHide;
    private RelativeLayout rootViewAlbumItems;
    private RelativeLayout rootSelectorView;
    private RecyclerView rvAlbumItems;
    private AlbumItemsAdapter albumItemsAdapter;
    private PressedTextView tvAlbumItems;
    private ArrayList<Photo> photoList = new ArrayList();
    private PuzzleSelectorAdapter photosAdapter;
    private RecyclerView rvPhotos;
    private RecyclerView rvPreview;
    private PuzzleSelectorPreviewAdapter previewAdapter;
    private ArrayList<Photo> selectedPhotos = new ArrayList();
    private PressedTextView tvDone;

    public static void start(Activity activity) {
        Intent intent = new Intent((Context)activity, PuzzleSelectorActivity.class);
        activity.startActivityForResult(intent, 16);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_puzzle_selector);
        if (Build.VERSION.SDK_INT >= 23) {
            int statusColor = this.getWindow().getStatusBarColor();
            if (statusColor == 0) {
                statusColor = ContextCompat.getColor((Context)this, (int)R.color.status_bar);
            }
            if (ColorUtils.isWhiteColor(statusColor)) {
                SystemUtils.getInstance().setStatusDark((Activity)this, true);
            }
        }
        this.albumModel = AlbumModel.getInstance();
        if (null == this.albumModel || this.albumModel.getAlbumItems().isEmpty()) {
            this.finish();
            return;
        }
        this.initView();
    }

    private void initView() {
        this.setClick(R.id.iv_back);
        this.tvAlbumItems = (PressedTextView)this.findViewById(R.id.tv_album_items);
        this.tvAlbumItems.setText(this.albumModel.getAlbumItems().get((int)0).name);
        this.rootSelectorView = (RelativeLayout)this.findViewById(R.id.m_selector_root);
        this.tvDone = (PressedTextView)this.findViewById(R.id.tv_done);
        this.tvDone.setOnClickListener(this);
        this.tvAlbumItems.setOnClickListener(this);
        this.initAlbumItems();
        this.initPhotos();
        this.initPreview();
    }

    private void initPreview() {
        this.rvPreview = (RecyclerView)this.findViewById(R.id.rv_preview_selected_photos);
        LinearLayoutManager lm = new LinearLayoutManager((Context)this, 0, false);
        this.previewAdapter = new PuzzleSelectorPreviewAdapter((Context)this, this.selectedPhotos, this);
        this.rvPreview.setLayoutManager((RecyclerView.LayoutManager)lm);
        this.rvPreview.setAdapter((RecyclerView.Adapter)this.previewAdapter);
    }

    private void initPhotos() {
        this.rvPhotos = (RecyclerView)this.findViewById(R.id.rv_photos);
        ((SimpleItemAnimator)this.rvPhotos.getItemAnimator()).setSupportsChangeAnimations(false);
        this.photoList.addAll(this.albumModel.getCurrAlbumItemPhotos(0));
        this.photosAdapter = new PuzzleSelectorAdapter((Context)this, this.photoList, this);
        int columns = this.getResources().getInteger(R.integer.photos_columns);
        GridLayoutManager gridLayoutManager = new GridLayoutManager((Context)this, columns);
        this.rvPhotos.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager);
        this.rvPhotos.setAdapter((RecyclerView.Adapter)this.photosAdapter);
    }

    private void initAlbumItems() {
        this.rootViewAlbumItems = (RelativeLayout)this.findViewById(R.id.root_view_album_items);
        this.rootViewAlbumItems.setOnClickListener((View.OnClickListener)this);
        this.setClick(R.id.iv_album_items);
        this.rvAlbumItems = (RecyclerView)this.findViewById(R.id.rv_album_items);
        LinearLayoutManager lm = new LinearLayoutManager((Context)this);
        ArrayList<Object> list = new ArrayList<Object>(this.albumModel.getAlbumItems());
        this.albumItemsAdapter = new AlbumItemsAdapter((Context)this, list, 0, this);
        this.rvAlbumItems.setLayoutManager((RecyclerView.LayoutManager)lm);
        this.rvAlbumItems.setAdapter((RecyclerView.Adapter)this.albumItemsAdapter);
    }

    private void setClick(int ... ids) {
        for (int id2 : ids) {
            this.findViewById(id2).setOnClickListener((View.OnClickListener)this);
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (R.id.iv_back == id2) {
            this.setResult(0);
            this.finish();
        } else if (R.id.tv_album_items == id2 || R.id.iv_album_items == id2) {
            this.showAlbumItems(8 == this.rootViewAlbumItems.getVisibility());
        } else if (R.id.root_view_album_items == id2) {
            this.showAlbumItems(false);
        } else if (R.id.tv_done == id2) {
            FilePathUtils.getInstance();
            String puzzleDir = FilePathUtils.getFileDcimDir((Context)this.getApplication()).getPath();
            BubingLog.d(TAG, "puzzleDir\uff1a" + puzzleDir);
            PuzzleActivity.startWithPhotos((Activity)this, this.selectedPhotos, puzzleDir, "IMG", 15, true, Setting.imageEngine);
        }
    }

    private void showAlbumItems(boolean isShow) {
        if (null == this.setShow) {
            this.newAnimators();
        }
        if (isShow) {
            this.rootViewAlbumItems.setVisibility(0);
            this.setShow.start();
        } else {
            this.setHide.start();
        }
    }

    private void newAnimators() {
        this.newHideAnim();
        this.newShowAnim();
    }

    private void newShowAnim() {
        ObjectAnimator translationShow = ObjectAnimator.ofFloat((Object)this.rvAlbumItems, (String)"translationY", (float[])new float[]{this.rootSelectorView.getTop(), 0.0f});
        ObjectAnimator alphaShow = ObjectAnimator.ofFloat((Object)this.rootViewAlbumItems, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        translationShow.setDuration(300L);
        this.setShow = new AnimatorSet();
        this.setShow.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.setShow.play((Animator)translationShow).with((Animator)alphaShow);
    }

    private void newHideAnim() {
        ObjectAnimator translationHide = ObjectAnimator.ofFloat((Object)this.rvAlbumItems, (String)"translationY", (float[])new float[]{0.0f, this.rootSelectorView.getTop()});
        ObjectAnimator alphaHide = ObjectAnimator.ofFloat((Object)this.rootViewAlbumItems, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        translationHide.setDuration(200L);
        this.setHide = new AnimatorSet();
        this.setHide.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                PuzzleSelectorActivity.this.rootViewAlbumItems.setVisibility(8);
            }
        });
        this.setHide.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        this.setHide.play((Animator)translationHide).with((Animator)alphaHide);
    }

    @Override
    public void onAlbumItemClick(int position, int realPosition) {
        this.updatePhotos(realPosition);
        this.showAlbumItems(false);
        this.tvAlbumItems.setText(this.albumModel.getAlbumItems().get((int)realPosition).name);
    }

    private void updatePhotos(int currAlbumItemIndex) {
        this.photoList.clear();
        this.photoList.addAll(this.albumModel.getCurrAlbumItemPhotos(currAlbumItemIndex));
        this.photosAdapter.notifyDataSetChanged();
        this.rvPhotos.scrollToPosition(0);
    }

    public void onBackPressed() {
        if (null != this.rootViewAlbumItems && this.rootViewAlbumItems.getVisibility() == 0) {
            this.showAlbumItems(false);
            return;
        }
        super.onBackPressed();
    }

    @Override
    public void onPhotoClick(int position) {
        if (this.selectedPhotos.size() > 8) {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.selector_reach_max_image_hint, new Object[]{9}), (int)0).show();
            return;
        }
        this.selectedPhotos.add(this.photoList.get(position));
        this.previewAdapter.notifyDataSetChanged();
        this.rvPreview.smoothScrollToPosition(this.selectedPhotos.size() - 1);
        this.tvDone.setText(this.getString(R.string.selector_action_done, new Object[]{this.selectedPhotos.size(), 9}));
        if (this.selectedPhotos.size() > 1) {
            this.tvDone.setVisibility(0);
        }
    }

    @Override
    public void onDeleteClick(int position) {
        this.selectedPhotos.remove(position);
        this.previewAdapter.notifyDataSetChanged();
        this.tvDone.setText(this.getString(R.string.selector_action_done, new Object[]{this.selectedPhotos.size(), 9}));
        if (this.selectedPhotos.size() < 2) {
            this.tvDone.setVisibility(4);
        }
    }

    private void resetPuzzlePhotos() {
        this.selectedPhotos.clear();
        this.previewAdapter.notifyDataSetChanged();
        this.tvDone.setText(this.getString(R.string.selector_action_done, new Object[]{this.selectedPhotos.size(), 9}));
        if (this.selectedPhotos.size() < 2) {
            this.tvDone.setVisibility(4);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 15 && resultCode == -1) {
            if (data != null && data.getBooleanExtra("keyOfPuzzleTypeResult", false)) {
                this.resetPuzzlePhotos();
            } else {
                this.setResult(-1, data);
                this.finish();
            }
        }
    }
}

