/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.ui;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.Camera;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Toast;
import androidx.core.app.ActivityCompat;
import com.bubing.camera.R;
import com.bubing.camera.constant.StartupType;
import com.bubing.camera.utils.BubingLog;
import com.bubing.camera.utils.CameraUtils;
import com.bubing.camera.utils.ImageUtils;
import com.bubing.camera.utils.PermissionUtils;
import com.bubing.camera.utils.ScreenUtils;
import com.bubing.camera.widget.CameraPreview;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CameraLandscapeActivity
extends Activity
implements View.OnClickListener {
    private static final String TAG = CameraLandscapeActivity.class.getSimpleName();
    private StartupType mStartupType;
    private boolean isToast = true;
    private CameraPreview mCameraPreview;
    private LinearLayout mCameraCropContainerLayout;
    private ImageView mCameraCropImage;
    private ImageView mCameraFlashImage;
    private LinearLayout mCameraOptionLayout;
    private LinearLayout mCameraResultLayout;
    private View mCameraCropLeftView;

    public static void start(Activity activity, StartupType startupType, int requestCode) {
        Intent intent = new Intent((Context)activity, CameraLandscapeActivity.class);
        intent.putExtra("keyOfCertificateTypePut", startupType.getValue());
        activity.startActivityForResult(intent, requestCode);
    }

    public static void start(Fragment fragment, StartupType startupType, int requestCode) {
        Intent intent = new Intent((Context)fragment.getActivity(), CameraLandscapeActivity.class);
        intent.putExtra("keyOfCertificateTypePut", startupType.getValue());
        fragment.startActivityForResult(intent, requestCode);
    }

    public static void start(androidx.fragment.app.Fragment fragment, StartupType startupType, int requestCode) {
        Intent intent = new Intent(fragment.getContext(), CameraLandscapeActivity.class);
        intent.putExtra("keyOfCertificateTypePut", startupType.getValue());
        fragment.startActivityForResult(intent, requestCode);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        int takeType = this.getIntent().getIntExtra("keyOfCertificateTypePut", 0);
        this.mStartupType = StartupType.valueOf(takeType);
        BubingLog.d(TAG, "initPermissions takeType: " + takeType + " mStartupType\uff1a" + (Object)((Object)this.mStartupType));
        if (this.mStartupType != null) {
            this.setContentView(R.layout.activity_camera_landscape);
            boolean checkPermissionFirst = PermissionUtils.checkPermissionFirst((Context)this, 18, new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.CAMERA"});
            if (checkPermissionFirst) {
                this.initView();
            }
        } else {
            BubingLog.e(TAG, "initPermissions : \u62cd\u7167\u7c7b\u578b\u83b7\u53d6\u5931\u8d25");
            this.finish();
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        boolean isPermissions = true;
        for (int i = 0; i < permissions.length; ++i) {
            if (grantResults[i] != -1) continue;
            isPermissions = false;
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)permissions[i]) || !this.isToast) continue;
            Toast.makeText((Context)this, (CharSequence)"\u8bf7\u624b\u52a8\u6253\u5f00\u8be5\u5e94\u7528\u9700\u8981\u7684\u6743\u9650", (int)0).show();
            this.isToast = false;
        }
        this.isToast = true;
        if (isPermissions) {
            BubingLog.d("onRequestPermission", "onRequestPermissionsResult: \u5141\u8bb8\u6240\u6709\u6743\u9650");
            this.initView();
        } else {
            BubingLog.d("onRequestPermission", "onRequestPermissionsResult: \u6709\u6743\u9650\u4e0d\u5141\u8bb8");
            this.finish();
        }
    }

    private void initView() {
        this.mCameraPreview = (CameraPreview)this.findViewById(R.id.camera_preview);
        float screenMinSize = ScreenUtils.getScreenMin((Context)this);
        float maxSize = screenMinSize / 9.0f * 16.0f;
        RelativeLayout.LayoutParams layoutParams = StartupType.CAMERA_COMPANY_PORTRAIT == this.mStartupType ? new RelativeLayout.LayoutParams((int)screenMinSize, (int)maxSize) : new RelativeLayout.LayoutParams((int)maxSize, (int)screenMinSize);
        layoutParams.addRule(13);
        this.mCameraPreview.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mCameraCropLeftView = this.findViewById(R.id.camera_crop_left_view);
        this.mCameraCropContainerLayout = (LinearLayout)this.findViewById(R.id.camera_crop_container_layout);
        this.mCameraCropImage = (ImageView)this.findViewById(R.id.camera_crop_image);
        float width = 0.0f;
        float height = 0.0f;
        if (StartupType.CAMERA_COMPANY_PORTRAIT == this.mStartupType) {
            width = (int)((double)screenMinSize * 0.8);
            height = (int)(width * 43.0f / 30.0f);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, (int)height);
            this.mCameraCropContainerLayout.setLayoutParams((ViewGroup.LayoutParams)params);
            params = new LinearLayout.LayoutParams((int)width, (int)height);
            this.mCameraCropImage.setLayoutParams((ViewGroup.LayoutParams)params);
        } else if (StartupType.CAMERA_COMPANY_LANDSCAPE == this.mStartupType) {
            height = (int)((double)screenMinSize * 0.8);
            width = (int)(height * 43.0f / 30.0f);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams((int)width, -1);
            this.mCameraCropContainerLayout.setLayoutParams((ViewGroup.LayoutParams)params);
            params = new LinearLayout.LayoutParams((int)width, (int)height);
            this.mCameraCropImage.setLayoutParams((ViewGroup.LayoutParams)params);
        } else {
            height = (int)((double)screenMinSize * 0.75);
            width = (int)(height * 75.0f / 47.0f);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams((int)width, -1);
            this.mCameraCropContainerLayout.setLayoutParams((ViewGroup.LayoutParams)params);
            params = new LinearLayout.LayoutParams((int)width, (int)height);
            this.mCameraCropImage.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        if (StartupType.CAMERA_IDCARD_FRONT == this.mStartupType) {
            this.mCameraCropImage.setImageResource(R.drawable.camera_idcard_front);
        } else if (StartupType.CAMERA_IDCARD_BACK == this.mStartupType) {
            this.mCameraCropImage.setImageResource(R.drawable.camera_idcard_back);
        } else if (StartupType.CAMERA_COMPANY_PORTRAIT == this.mStartupType) {
            this.mCameraCropImage.setImageResource(R.drawable.camera_company_portrait);
        } else if (StartupType.CAMERA_COMPANY_LANDSCAPE == this.mStartupType) {
            this.mCameraCropImage.setImageResource(R.drawable.camera_company_landscape);
        }
        this.mCameraOptionLayout = (LinearLayout)this.findViewById(R.id.camera_option_layout);
        this.mCameraFlashImage = (ImageView)this.findViewById(R.id.camera_flash_image);
        this.mCameraResultLayout = (LinearLayout)this.findViewById(R.id.camera_result_layout);
        this.mCameraPreview.setOnClickListener(this);
        this.findViewById(R.id.camera_close_image).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.camera_take_image).setOnClickListener((View.OnClickListener)this);
        this.mCameraFlashImage.setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.camera_confirm_image).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.camera_cancel_image).setOnClickListener((View.OnClickListener)this);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                CameraLandscapeActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        CameraLandscapeActivity.this.mCameraPreview.setVisibility(0);
                    }
                });
            }
        }, 500L);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.camera_preview) {
            this.mCameraPreview.focus();
        } else if (id2 == R.id.camera_close_image) {
            this.finish();
        } else if (id2 == R.id.camera_take_image) {
            this.takePhoto();
        } else if (id2 == R.id.camera_flash_image) {
            boolean isFlashOn = this.mCameraPreview.switchFlashLight();
            this.mCameraFlashImage.setImageResource(isFlashOn ? R.drawable.camera_flash_on : R.drawable.camera_flash_off);
        } else if (id2 == R.id.camera_confirm_image) {
            this.confirm();
        } else if (id2 == R.id.camera_cancel_image) {
            this.mCameraOptionLayout.setVisibility(0);
            this.mCameraResultLayout.setVisibility(8);
            this.mCameraPreview.setEnabled(true);
            this.mCameraPreview.startPreview();
        }
    }

    private void takePhoto() {
        this.mCameraOptionLayout.setVisibility(8);
        this.mCameraPreview.setEnabled(false);
        CameraUtils.getCamera().setOneShotPreviewCallback(new Camera.PreviewCallback(){

            public void onPreviewFrame(final byte[] bytes, Camera camera) {
                final Camera.Size size = camera.getParameters().getPreviewSize();
                camera.stopPreview();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            float bottom;
                            float right;
                            float top;
                            float left;
                            Bitmap bitmap = ImageUtils.getBitmapFromByte(bytes, size.width, size.height);
                            if (StartupType.CAMERA_COMPANY_PORTRAIT == CameraLandscapeActivity.this.mStartupType) {
                                left = (float)CameraLandscapeActivity.this.mCameraCropImage.getLeft() / (float)CameraLandscapeActivity.this.mCameraPreview.getWidth();
                                top = ((float)CameraLandscapeActivity.this.mCameraCropContainerLayout.getTop() - (float)CameraLandscapeActivity.this.mCameraPreview.getTop()) / (float)CameraLandscapeActivity.this.mCameraPreview.getHeight();
                                right = (float)CameraLandscapeActivity.this.mCameraCropImage.getRight() / (float)CameraLandscapeActivity.this.mCameraPreview.getWidth();
                                bottom = (float)CameraLandscapeActivity.this.mCameraCropContainerLayout.getBottom() / (float)CameraLandscapeActivity.this.mCameraPreview.getHeight();
                            } else {
                                left = ((float)CameraLandscapeActivity.this.mCameraCropContainerLayout.getLeft() - (float)CameraLandscapeActivity.this.mCameraPreview.getLeft()) / (float)CameraLandscapeActivity.this.mCameraPreview.getWidth();
                                top = (float)CameraLandscapeActivity.this.mCameraCropImage.getTop() / (float)CameraLandscapeActivity.this.mCameraPreview.getHeight();
                                right = (float)CameraLandscapeActivity.this.mCameraCropContainerLayout.getRight() / (float)CameraLandscapeActivity.this.mCameraPreview.getWidth();
                                bottom = (float)CameraLandscapeActivity.this.mCameraCropImage.getBottom() / (float)CameraLandscapeActivity.this.mCameraPreview.getHeight();
                            }
                            Bitmap cropBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)((int)(left * (float)bitmap.getWidth())), (int)((int)(top * (float)bitmap.getHeight())), (int)((int)((right - left) * (float)bitmap.getWidth())), (int)((int)((bottom - top) * (float)bitmap.getHeight())));
                            File cropFile = CameraLandscapeActivity.this.getCropFile();
                            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(cropFile));
                            cropBitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
                            bos.flush();
                            bos.close();
                            CameraLandscapeActivity.this.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    CameraLandscapeActivity.this.mCameraResultLayout.setVisibility(0);
                                }
                            });
                            return;
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        CameraLandscapeActivity.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                CameraLandscapeActivity.this.mCameraOptionLayout.setVisibility(0);
                                CameraLandscapeActivity.this.mCameraPreview.setEnabled(true);
                            }
                        });
                    }
                }).start();
            }
        });
    }

    private void takePhoto1() {
        this.mCameraOptionLayout.setVisibility(8);
        this.mCameraPreview.setEnabled(false);
        this.mCameraPreview.takePhoto(new Camera.PictureCallback(){

            public void onPictureTaken(final byte[] data, Camera camera) {
                camera.stopPreview();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            float bottom;
                            float right;
                            float top;
                            float left;
                            File originalFile = CameraLandscapeActivity.this.getOriginalFile();
                            FileOutputStream originalFileOutputStream = new FileOutputStream(originalFile);
                            originalFileOutputStream.write(data);
                            originalFileOutputStream.close();
                            Bitmap bitmap = BitmapFactory.decodeFile((String)originalFile.getPath());
                            if (StartupType.CAMERA_COMPANY_PORTRAIT == CameraLandscapeActivity.this.mStartupType) {
                                left = (float)CameraLandscapeActivity.this.mCameraCropImage.getLeft() / (float)CameraLandscapeActivity.this.mCameraPreview.getWidth();
                                top = ((float)CameraLandscapeActivity.this.mCameraCropContainerLayout.getTop() - (float)CameraLandscapeActivity.this.mCameraPreview.getTop()) / (float)CameraLandscapeActivity.this.mCameraPreview.getHeight();
                                right = (float)CameraLandscapeActivity.this.mCameraCropImage.getRight() / (float)CameraLandscapeActivity.this.mCameraPreview.getWidth();
                                bottom = (float)CameraLandscapeActivity.this.mCameraCropContainerLayout.getBottom() / (float)CameraLandscapeActivity.this.mCameraPreview.getHeight();
                            } else {
                                left = ((float)CameraLandscapeActivity.this.mCameraCropContainerLayout.getLeft() - (float)CameraLandscapeActivity.this.mCameraPreview.getLeft()) / (float)CameraLandscapeActivity.this.mCameraPreview.getWidth();
                                top = (float)CameraLandscapeActivity.this.mCameraCropImage.getTop() / (float)CameraLandscapeActivity.this.mCameraPreview.getHeight();
                                right = (float)CameraLandscapeActivity.this.mCameraCropContainerLayout.getRight() / (float)CameraLandscapeActivity.this.mCameraPreview.getWidth();
                                bottom = (float)CameraLandscapeActivity.this.mCameraCropImage.getBottom() / (float)CameraLandscapeActivity.this.mCameraPreview.getHeight();
                            }
                            Bitmap cropBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)((int)(left * (float)bitmap.getWidth())), (int)((int)(top * (float)bitmap.getHeight())), (int)((int)((right - left) * (float)bitmap.getWidth())), (int)((int)((bottom - top) * (float)bitmap.getHeight())));
                            File cropFile = CameraLandscapeActivity.this.getCropFile();
                            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(cropFile));
                            cropBitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
                            bos.flush();
                            bos.close();
                            CameraLandscapeActivity.this.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    CameraLandscapeActivity.this.mCameraResultLayout.setVisibility(0);
                                }
                            });
                            return;
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        CameraLandscapeActivity.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                CameraLandscapeActivity.this.mCameraOptionLayout.setVisibility(0);
                                CameraLandscapeActivity.this.mCameraPreview.setEnabled(true);
                            }
                        });
                    }
                }).start();
            }
        });
    }

    private File getOriginalFile() {
        if (StartupType.CAMERA_IDCARD_FRONT == this.mStartupType) {
            return new File(this.getExternalCacheDir(), "idCardFront.jpg");
        }
        if (StartupType.CAMERA_IDCARD_BACK == this.mStartupType) {
            return new File(this.getExternalCacheDir(), "idCardBack.jpg");
        }
        if (StartupType.CAMERA_COMPANY_PORTRAIT == this.mStartupType) {
            return new File(this.getExternalCacheDir(), "companyInfo.jpg");
        }
        if (StartupType.CAMERA_COMPANY_LANDSCAPE == this.mStartupType) {
            return new File(this.getExternalCacheDir(), "companyInfo.jpg");
        }
        return new File(this.getExternalCacheDir(), "picture.jpg");
    }

    private File getCropFile() {
        if (StartupType.CAMERA_IDCARD_FRONT == this.mStartupType) {
            return new File(this.getExternalCacheDir(), "idCardFrontCrop.jpg");
        }
        if (StartupType.CAMERA_IDCARD_BACK == this.mStartupType) {
            return new File(this.getExternalCacheDir(), "idCardBackCrop.jpg");
        }
        if (StartupType.CAMERA_COMPANY_PORTRAIT == this.mStartupType) {
            return new File(this.getExternalCacheDir(), "companyInfoCrop.jpg");
        }
        if (StartupType.CAMERA_COMPANY_LANDSCAPE == this.mStartupType) {
            return new File(this.getExternalCacheDir(), "companyInfoCrop.jpg");
        }
        return new File(this.getExternalCacheDir(), "pictureCrop.jpg");
    }

    private void confirm() {
        Intent intent = new Intent();
        intent.putExtra("keyOfCertificateTypeResult", this.mStartupType.getValue());
        intent.putExtra("keyOfCertificatePathResult", this.getCropFile().getPath());
        this.setResult(-1, intent);
        this.finish();
    }

    protected void onStart() {
        super.onStart();
        if (this.mCameraPreview != null) {
            this.mCameraPreview.onStart();
        }
    }

    protected void onStop() {
        super.onStop();
        if (this.mCameraPreview != null) {
            this.mCameraPreview.onStop();
        }
    }
}

