/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.Activity;
import android.app.Fragment;
import android.app.ProgressDialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.bubing.camera.R;
import com.bubing.camera.constant.ImageType;
import com.bubing.camera.exception.BException;
import com.bubing.camera.exception.BExceptionType;
import com.bubing.camera.models.ContextWrap;
import com.bubing.camera.models.ResultPhoto;
import com.bubing.camera.models.ad.AdListener;
import com.bubing.camera.models.ad.AdUtils;
import com.bubing.camera.models.album.AlbumModel;
import com.bubing.camera.models.album.entity.Photo;
import com.bubing.camera.models.compress.CompressImage;
import com.bubing.camera.models.compress.CompressImageImpl;
import com.bubing.camera.models.crop.CropOptions;
import com.bubing.camera.models.crop.CropUtils;
import com.bubing.camera.models.crop.MultipleCrop;
import com.bubing.camera.result.ResultStorage;
import com.bubing.camera.setting.Setting;
import com.bubing.camera.ui.ImagePreviewActivity;
import com.bubing.camera.ui.PuzzleSelectorActivity;
import com.bubing.camera.ui.adapter.AlbumItemsAdapter;
import com.bubing.camera.ui.adapter.PhotosAdapter;
import com.bubing.camera.utils.BubingLog;
import com.bubing.camera.utils.CameraUtils;
import com.bubing.camera.utils.ColorUtils;
import com.bubing.camera.utils.FilePathUtils;
import com.bubing.camera.utils.FileUtils;
import com.bubing.camera.utils.ImageFiles;
import com.bubing.camera.utils.PermissionUtil;
import com.bubing.camera.utils.PhotoUtils;
import com.bubing.camera.utils.SettingsUtils;
import com.bubing.camera.utils.StringUtils;
import com.bubing.camera.utils.UriUtils;
import com.bubing.camera.utils.bitmap.BitmapUtils;
import com.bubing.camera.utils.media.DurationUtils;
import com.bubing.camera.utils.media.MediaScannerConnectionUtils;
import com.bubing.camera.utils.system.SystemUtils;
import com.bubing.camera.widget.PressedTextView;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class CameraAlbumActivity
extends AppCompatActivity
implements AlbumItemsAdapter.OnClickListener,
PhotosAdapter.OnClickListener,
AdListener,
View.OnClickListener {
    private static final String TAG = CameraAlbumActivity.class.getSimpleName();
    private AlbumModel albumModel;
    private ArrayList<Object> photoList = new ArrayList();
    private ArrayList<Object> albumItemList = new ArrayList();
    private RecyclerView rvPhotos;
    private PhotosAdapter photosAdapter;
    private GridLayoutManager gridLayoutManager;
    private RecyclerView rvAlbumItems;
    private AlbumItemsAdapter albumItemsAdapter;
    private RelativeLayout rootViewAlbumItems;
    private PressedTextView tvAlbumItems;
    private PressedTextView tvDone;
    private PressedTextView tvPreview;
    private TextView tvOriginal;
    private AnimatorSet setHide;
    private AnimatorSet setShow;
    private int currAlbumItemIndex = 0;
    private ImageView ivCamera;
    private TextView tvTitle;
    private LinearLayout mSecondMenus;
    private RelativeLayout permissionView;
    private TextView tvPermission;
    private View mBottomBar;
    private File tempImageFile = null;
    private Uri tempImageUri = null;
    private Uri tempImageQUri = null;
    private ResultPhoto mResultPhoto;
    private MultipleCrop multipleCrop;
    private ProgressDialog wailLoadDialog;

    public static void start(Activity activity, int requestCode) {
        Intent intent = new Intent((Context)activity, CameraAlbumActivity.class);
        activity.startActivityForResult(intent, requestCode);
    }

    public static void start(Fragment fragment, int requestCode) {
        Intent intent = new Intent((Context)fragment.getActivity(), CameraAlbumActivity.class);
        fragment.startActivityForResult(intent, requestCode);
    }

    public static void start(androidx.fragment.app.Fragment fragment, int requestCode) {
        Intent intent = new Intent(fragment.getContext(), CameraAlbumActivity.class);
        fragment.startActivityForResult(intent, requestCode);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_camera_album);
        this.hideActionBar();
        this.adaptationStatusBar();
        if (!Setting.onlyStartCamera && null == Setting.imageEngine) {
            this.finish();
            return;
        }
        this.initSomeViews();
        if (PermissionUtil.checkAndRequestPermissionsInActivity((Activity)this, this.getNeedPermissions())) {
            this.hasPermissions();
        } else {
            this.permissionView.setVisibility(0);
        }
    }

    private void hideActionBar() {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.hide();
        }
    }

    private void adaptationStatusBar() {
        if (Build.VERSION.SDK_INT >= 23) {
            int statusColor = this.getWindow().getStatusBarColor();
            if (statusColor == 0) {
                statusColor = ContextCompat.getColor((Context)this, (int)R.color.statubar_primary_dark);
            }
            if (ColorUtils.isWhiteColor(statusColor)) {
                SystemUtils.getInstance().setStatusDark((Activity)this, true);
            }
        }
    }

    private void initSomeViews() {
        this.mBottomBar = this.findViewById(R.id.m_bottom_bar);
        this.permissionView = (RelativeLayout)this.findViewById(R.id.rl_permissions_view);
        this.tvPermission = (TextView)this.findViewById(R.id.tv_permission);
        this.rootViewAlbumItems = (RelativeLayout)this.findViewById(R.id.root_view_album_items);
        this.tvTitle = (TextView)this.findViewById(R.id.tv_title);
        if (Setting.isOnlyVideo()) {
            this.tvTitle.setText(R.string.video_selection);
        }
        this.findViewById(R.id.iv_second_menu).setVisibility(Setting.showPuzzleMenu || Setting.showCleanMenu || Setting.showOriginalMenu ? 0 : 8);
        this.setClick(R.id.iv_back);
    }

    private void hasPermissions() {
        this.permissionView.setVisibility(8);
        if (Setting.onlyStartCamera) {
            this.launchCamera(11);
            return;
        }
        AlbumModel.CallBack albumModelCallBack = new AlbumModel.CallBack(){

            @Override
            public void onAlbumWorkedCallBack() {
                CameraAlbumActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        CameraAlbumActivity.this.onAlbumWorkedDo();
                    }
                });
            }
        };
        this.albumModel = AlbumModel.getInstance();
        this.albumModel.query((Context)this, albumModelCallBack);
    }

    protected String[] getNeedPermissions() {
        if (Setting.isShowCamera) {
            if (Build.VERSION.SDK_INT >= 16) {
                return new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
            }
            return new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"};
        }
        if (Build.VERSION.SDK_INT >= 16) {
            return new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
        }
        return new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
    }

    private void onAlbumWorkedDo() {
        this.initView();
    }

    private void initView() {
        if (this.albumModel.getAlbumItems().isEmpty()) {
            Toast.makeText((Context)this, (int)R.string.no_photos, (int)1).show();
            if (Setting.isShowCamera) {
                this.launchCamera(11);
            } else {
                this.finish();
            }
            return;
        }
        AdUtils.setAdListener(this);
        if (Setting.hasPhotosAd()) {
            this.findViewById(R.id.m_tool_bar_bottom_line).setVisibility(8);
        }
        this.ivCamera = (ImageView)this.findViewById(R.id.fab_camera);
        if (Setting.isShowCamera && Setting.isBottomRightCamera()) {
            this.ivCamera.setVisibility(0);
        }
        if (!Setting.showPuzzleMenu) {
            this.findViewById(R.id.tv_puzzle).setVisibility(8);
        }
        this.mSecondMenus = (LinearLayout)this.findViewById(R.id.m_second_level_menu);
        int columns = this.getResources().getInteger(R.integer.photos_columns);
        this.tvAlbumItems = (PressedTextView)this.findViewById(R.id.tv_album_items);
        this.tvAlbumItems.setText(this.albumModel.getAlbumItems().get((int)0).name);
        this.tvDone = (PressedTextView)this.findViewById(R.id.tv_done);
        this.rvPhotos = (RecyclerView)this.findViewById(R.id.rv_photos);
        ((SimpleItemAnimator)this.rvPhotos.getItemAnimator()).setSupportsChangeAnimations(false);
        this.photoList.clear();
        this.photoList.addAll(this.albumModel.getCurrAlbumItemPhotos(0));
        int index = 0;
        if (Setting.hasPhotosAd()) {
            this.photoList.add(index, Setting.photosAdView);
        }
        if (Setting.isShowCamera && !Setting.isBottomRightCamera()) {
            if (Setting.hasPhotosAd()) {
                index = 1;
            }
            this.photoList.add(index, null);
        }
        this.photosAdapter = new PhotosAdapter((Context)this, this.photoList, this);
        this.gridLayoutManager = new GridLayoutManager((Context)this, columns);
        if (Setting.hasPhotosAd()) {
            this.gridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    if (position == 0) {
                        return CameraAlbumActivity.this.gridLayoutManager.getSpanCount();
                    }
                    return 1;
                }
            });
        }
        this.rvPhotos.setLayoutManager((RecyclerView.LayoutManager)this.gridLayoutManager);
        this.rvPhotos.setAdapter((RecyclerView.Adapter)this.photosAdapter);
        this.tvOriginal = (TextView)this.findViewById(R.id.tv_original);
        if (Setting.showOriginalMenu) {
            this.processOriginalMenu();
        } else {
            this.tvOriginal.setVisibility(8);
        }
        this.tvPreview = (PressedTextView)this.findViewById(R.id.tv_preview);
        this.initAlbumItems();
        this.shouldShowMenuDone();
        this.setClick(R.id.iv_album_items, R.id.tv_clear, R.id.iv_second_menu, R.id.tv_puzzle);
        this.setClick(new View[]{this.tvAlbumItems, this.rootViewAlbumItems, this.tvDone, this.tvOriginal, this.tvPreview, this.ivCamera});
    }

    private void initAlbumItems() {
        this.rvAlbumItems = (RecyclerView)this.findViewById(R.id.rv_album_items);
        this.albumItemList.clear();
        this.albumItemList.addAll(this.albumModel.getAlbumItems());
        if (Setting.hasAlbumItemsAd()) {
            int albumItemsAdIndex = 2;
            if (this.albumItemList.size() < albumItemsAdIndex + 1) {
                albumItemsAdIndex = this.albumItemList.size() - 1;
            }
            this.albumItemList.add(albumItemsAdIndex, Setting.albumItemsAdView);
        }
        this.albumItemsAdapter = new AlbumItemsAdapter((Context)this, this.albumItemList, 0, this);
        this.rvAlbumItems.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.rvAlbumItems.setAdapter((RecyclerView.Adapter)this.albumItemsAdapter);
    }

    private void setClick(int ... ids) {
        for (int id2 : ids) {
            this.findViewById(id2).setOnClickListener((View.OnClickListener)this);
        }
    }

    private void setClick(View ... views) {
        for (View v : views) {
            v.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (R.id.tv_album_items == id2 || R.id.iv_album_items == id2) {
            this.showAlbumItems(8 == this.rootViewAlbumItems.getVisibility());
        } else if (R.id.root_view_album_items == id2) {
            this.showAlbumItems(false);
        } else if (R.id.iv_back == id2) {
            this.onBackPressed();
        } else if (R.id.tv_done == id2) {
            this.doneMenu();
        } else if (R.id.tv_clear == id2) {
            if (ResultStorage.isEmpty()) {
                this.processSecondMenu();
                return;
            }
            ResultStorage.removeAll();
            this.photosAdapter.change();
            this.shouldShowMenuDone();
            this.processSecondMenu();
        } else if (R.id.tv_original == id2) {
            if (!Setting.originalMenuUsable) {
                if (!TextUtils.isEmpty((CharSequence)Setting.originalMenuUnusableHint)) {
                    Toast.makeText((Context)this, (CharSequence)Setting.originalMenuUnusableHint, (int)0).show();
                }
                return;
            }
            Setting.selectedOriginal = !Setting.selectedOriginal;
            this.processOriginalMenu();
            this.processSecondMenu();
        } else if (R.id.tv_preview == id2) {
            ImagePreviewActivity.start((Activity)this, -1, 0);
        } else if (R.id.fab_camera == id2) {
            this.launchCamera(11);
        } else if (R.id.iv_second_menu == id2) {
            this.processSecondMenu();
        } else if (R.id.tv_puzzle == id2) {
            this.processSecondMenu();
            PuzzleSelectorActivity.start((Activity)this);
        }
    }

    public void processSecondMenu() {
        if (this.mSecondMenus == null) {
            return;
        }
        if (0 == this.mSecondMenus.getVisibility()) {
            this.mSecondMenus.setVisibility(4);
            if (Setting.isShowCamera && Setting.isBottomRightCamera()) {
                this.ivCamera.setVisibility(0);
            }
        } else {
            this.mSecondMenus.setVisibility(0);
            if (Setting.isShowCamera && Setting.isBottomRightCamera()) {
                this.ivCamera.setVisibility(4);
            }
        }
    }

    private void doneMenu() {
        if (Setting.isCrop()) {
            try {
                this.onMultipleCrop(MultipleCrop.of((Activity)this, ResultStorage.photos, ImageType.OTHER), Setting.cropOptions);
            }
            catch (BException e) {
                this.onAlbumResult();
                e.printStackTrace();
            }
        } else {
            this.onAlbumResult();
        }
    }

    private void processOriginalMenu() {
        if (!Setting.showOriginalMenu) {
            return;
        }
        if (Setting.selectedOriginal) {
            this.tvOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.fg_accent));
        } else if (Setting.originalMenuUsable) {
            this.tvOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.fg_primary));
        } else {
            this.tvOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.fg_primary_dark));
        }
    }

    private void showAlbumItems(boolean isShow) {
        if (null == this.setShow) {
            this.newAnimators();
        }
        if (isShow) {
            this.rootViewAlbumItems.setVisibility(0);
            this.setShow.start();
        } else {
            this.setHide.start();
        }
    }

    private void newAnimators() {
        this.newHideAnim();
        this.newShowAnim();
    }

    private void newShowAnim() {
        ObjectAnimator translationShow = ObjectAnimator.ofFloat((Object)this.rvAlbumItems, (String)"translationY", (float[])new float[]{this.mBottomBar.getTop(), 0.0f});
        ObjectAnimator alphaShow = ObjectAnimator.ofFloat((Object)this.rootViewAlbumItems, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        translationShow.setDuration(300L);
        this.setShow = new AnimatorSet();
        this.setShow.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.setShow.play((Animator)translationShow).with((Animator)alphaShow);
    }

    private void newHideAnim() {
        ObjectAnimator translationHide = ObjectAnimator.ofFloat((Object)this.rvAlbumItems, (String)"translationY", (float[])new float[]{0.0f, this.mBottomBar.getTop()});
        ObjectAnimator alphaHide = ObjectAnimator.ofFloat((Object)this.rootViewAlbumItems, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        translationHide.setDuration(200L);
        this.setHide = new AnimatorSet();
        this.setHide.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                CameraAlbumActivity.this.rootViewAlbumItems.setVisibility(8);
            }
        });
        this.setHide.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        this.setHide.play((Animator)translationHide).with((Animator)alphaHide);
    }

    @Override
    public void onAlbumItemClick(int position, int realPosition) {
        this.updatePhotos(realPosition);
        this.showAlbumItems(false);
        this.tvAlbumItems.setText(this.albumModel.getAlbumItems().get((int)realPosition).name);
    }

    private void updatePhotos(int currAlbumItemIndex) {
        this.currAlbumItemIndex = currAlbumItemIndex;
        this.photoList.clear();
        this.photoList.addAll(this.albumModel.getCurrAlbumItemPhotos(currAlbumItemIndex));
        int index = 0;
        if (Setting.hasPhotosAd()) {
            this.photoList.add(index, Setting.photosAdView);
        }
        if (Setting.isShowCamera && !Setting.isBottomRightCamera()) {
            if (Setting.hasPhotosAd()) {
                index = 1;
            }
            this.photoList.add(index, null);
        }
        this.photosAdapter.change();
        this.rvPhotos.scrollToPosition(0);
    }

    private void shouldShowMenuDone() {
        if (ResultStorage.isEmpty()) {
            if (0 == this.tvDone.getVisibility()) {
                ScaleAnimation scaleHide = new ScaleAnimation(1.0f, 0.0f, 1.0f, 0.0f);
                scaleHide.setDuration(200L);
                this.tvDone.startAnimation((Animation)scaleHide);
            }
            this.tvDone.setVisibility(4);
            this.tvPreview.setVisibility(4);
        } else {
            if (4 == this.tvDone.getVisibility()) {
                ScaleAnimation scaleShow = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f);
                scaleShow.setDuration(200L);
                this.tvDone.startAnimation((Animation)scaleShow);
            }
            this.tvDone.setVisibility(0);
            this.tvPreview.setVisibility(0);
        }
        this.tvDone.setText(this.getString(R.string.selector_action_done, new Object[]{ResultStorage.count(), Setting.count}));
    }

    @Override
    public void onCameraClick() {
        this.launchCamera(11);
    }

    @Override
    public void onPhotoClick(int position, int realPosition) {
        ImagePreviewActivity.start((Activity)this, this.currAlbumItemIndex, realPosition);
    }

    @Override
    public void onSelectorOutOfMax(@Nullable Integer result) {
        if (result == null) {
            if (Setting.isOnlyVideo()) {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.selector_reach_max_video_hint, new Object[]{Setting.count}), (int)0).show();
            } else if (Setting.showVideo) {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.selector_reach_max_hint, new Object[]{Setting.count}), (int)0).show();
            } else {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.selector_reach_max_image_hint, new Object[]{Setting.count}), (int)0).show();
            }
            return;
        }
        switch (result) {
            case -1: {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.selector_reach_max_image_hint, new Object[]{Setting.pictureCount}), (int)0).show();
                break;
            }
            case -2: {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.selector_reach_max_video_hint, new Object[]{Setting.videoCount}), (int)0).show();
            }
        }
    }

    @Override
    public void onSelectorChanged() {
        this.shouldShowMenuDone();
    }

    public void onBackPressed() {
        if (null != this.rootViewAlbumItems && this.rootViewAlbumItems.getVisibility() == 0) {
            this.showAlbumItems(false);
            return;
        }
        if (null != this.mSecondMenus && 0 == this.mSecondMenus.getVisibility()) {
            this.processSecondMenu();
            return;
        }
        if (this.albumModel != null) {
            this.albumModel.stopQuery();
        }
        if (Setting.hasPhotosAd()) {
            this.photosAdapter.clearAd();
        }
        if (Setting.hasAlbumItemsAd()) {
            this.albumItemsAdapter.clearAd();
        }
        this.setResult(0);
        this.finish();
    }

    protected void onDestroy() {
        if (this.albumModel != null) {
            this.albumModel.stopQuery();
        }
        super.onDestroy();
    }

    @Override
    public void onPhotosAdLoaded() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CameraAlbumActivity.this.photosAdapter.change();
            }
        });
    }

    @Override
    public void onAlbumItemsAdLoaded() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CameraAlbumActivity.this.albumItemsAdapter.notifyDataSetChanged();
            }
        });
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        PermissionUtil.onPermissionResult((Activity)this, permissions, grantResults, new PermissionUtil.PermissionCallBack(){

            @Override
            public void onSuccess() {
                CameraAlbumActivity.this.hasPermissions();
            }

            @Override
            public void onShouldShow() {
                CameraAlbumActivity.this.tvPermission.setText(R.string.permissions_again);
                CameraAlbumActivity.this.permissionView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (PermissionUtil.checkAndRequestPermissionsInActivity((Activity)CameraAlbumActivity.this, CameraAlbumActivity.this.getNeedPermissions())) {
                            CameraAlbumActivity.this.hasPermissions();
                        }
                    }
                });
            }

            @Override
            public void onFailed() {
                CameraAlbumActivity.this.tvPermission.setText(R.string.permissions_die);
                CameraAlbumActivity.this.permissionView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        SettingsUtils.startMyApplicationDetailsForResult((Activity)CameraAlbumActivity.this, CameraAlbumActivity.this.getPackageName());
                    }
                });
            }
        });
    }

    private Uri createImageUri() {
        if (Environment.getExternalStorageState().equals("mounted")) {
            return this.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new ContentValues());
        }
        return this.getContentResolver().insert(MediaStore.Images.Media.INTERNAL_CONTENT_URI, new ContentValues());
    }

    private File createImageTempFile() {
        try {
            File dirFile = FilePathUtils.getFileDcimDir((Context)this);
            return File.createTempFile("IMG", ".jpg", dirFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void launchCamera(int requestCode) {
        if (!CameraUtils.cameraIsCanUse()) {
            this.permissionView.setVisibility(0);
            this.tvPermission.setText(R.string.permissions_die);
            this.permissionView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    SettingsUtils.startMyApplicationDetailsForResult((Activity)CameraAlbumActivity.this, CameraAlbumActivity.this.getPackageName());
                }
            });
            return;
        }
        this.toAndroidCamera(requestCode);
    }

    private void toAndroidCamera(int requestCode) {
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
            if (Build.VERSION.SDK_INT > 28) {
                this.tempImageQUri = this.createImageUri();
                cameraIntent.putExtra("output", (Parcelable)this.tempImageQUri);
                cameraIntent.addFlags(2);
                this.startActivityForResult(cameraIntent, requestCode);
                return;
            }
            this.tempImageFile = this.createImageTempFile();
            if (this.tempImageFile != null && this.tempImageFile.exists()) {
                this.tempImageUri = UriUtils.getUri((Context)this, this.tempImageFile);
                cameraIntent.addFlags(1);
                cameraIntent.putExtra("output", (Parcelable)this.tempImageUri);
                this.startActivityForResult(cameraIntent, requestCode);
            } else {
                Toast.makeText((Context)this, (int)R.string.camera_temp_file_error, (int)0).show();
            }
        } else {
            Toast.makeText((Context)this, (int)R.string.msg_no_camera, (int)0).show();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 14) {
            if (PermissionUtil.checkAndRequestPermissionsInActivity((Activity)this, this.getNeedPermissions())) {
                this.hasPermissions();
            } else {
                this.permissionView.setVisibility(0);
            }
            return;
        }
        if (requestCode == 11) {
            if (resultCode == -1) {
                Uri imageUri = null;
                Photo photo = null;
                if (Build.VERSION.SDK_INT > 28) {
                    photo = PhotoUtils.getPhoto((Context)this, this.tempImageQUri);
                    BubingLog.e(TAG, "onCameraResultForQ() -\u300bphoto = " + photo);
                    if (photo != null) {
                        imageUri = this.tempImageQUri;
                    }
                } else if (this.tempImageFile != null && this.tempImageFile.exists()) {
                    imageUri = this.tempImageUri;
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inJustDecodeBounds = true;
                    BitmapFactory.decodeFile((String)this.tempImageFile.getAbsolutePath(), (BitmapFactory.Options)options);
                    photo = new Photo(this.tempImageFile.getName(), imageUri, this.tempImageFile.getAbsolutePath(), this.tempImageFile.lastModified() / 1000L, options.outWidth, options.outHeight, this.tempImageFile.length(), DurationUtils.getDuration(this.tempImageFile.getAbsolutePath()), options.outMimeType);
                    photo.selectedOriginal = Setting.selectedOriginal;
                }
                if (imageUri != null) {
                    if (Setting.isCrop()) {
                        try {
                            this.onSingleCrop(photo, PhotoUtils.getCropPhoto((Activity)this, photo, ImageType.CAMERA), Setting.cropOptions);
                        }
                        catch (BException e) {
                            this.onCameraResult(photo);
                            e.printStackTrace();
                        }
                    } else {
                        this.onCameraResult(photo);
                    }
                } else {
                    Toast.makeText((Context)this, (CharSequence)"\u62cd\u7167\u4fdd\u5b58\u7684\u56fe\u7247\u4e0d\u5b58\u5728", (int)0).show();
                }
            } else if (resultCode == 0) {
                if (this.tempImageFile != null && this.tempImageFile.exists()) {
                    this.tempImageFile.delete();
                    this.tempImageFile = null;
                }
                if (Setting.onlyStartCamera) {
                    this.finish();
                }
            }
        } else if (requestCode == 13) {
            if (resultCode == -1) {
                if (data.getBooleanExtra("keyOfPreviewClickDone", false)) {
                    this.doneMenu();
                    return;
                }
                this.photosAdapter.change();
                this.processOriginalMenu();
                this.shouldShowMenuDone();
            } else if (resultCode == 0) {
                this.processOriginalMenu();
            }
        } else if (requestCode == 16) {
            if (resultCode == -1) {
                Photo puzzlePhoto = (Photo)data.getParcelableExtra("keyOfEasyPhotosResult");
                if (puzzlePhoto != null) {
                    this.addNewPhoto(puzzlePhoto);
                }
            } else if (resultCode == 0) {
                // empty if block
            }
        } else if (requestCode == 1001 || requestCode == 6709) {
            if (resultCode == -1) {
                if (this.multipleCrop != null) {
                    this.cropContinue(true);
                } else {
                    ArrayList<ResultPhoto> resultPhotos = new ArrayList<ResultPhoto>();
                    this.mResultPhoto.setCropped(true);
                    resultPhotos.add(this.mResultPhoto);
                    this.takeCompressResult(resultPhotos, new String[0]);
                }
            } else if (resultCode == 0) {
                if (this.multipleCrop != null) {
                    if (data != null) {
                        Bitmap bitmap = (Bitmap)data.getParcelableExtra("data");
                        ImageFiles.writeToFile(bitmap, this.mResultPhoto.getOriginalUri());
                        this.cropContinue(true);
                    } else {
                        this.cropContinue(false);
                    }
                } else if (data != null) {
                    Bitmap bitmap = (Bitmap)data.getParcelableExtra("data");
                    ImageFiles.writeToFile(bitmap, this.mResultPhoto.getOriginalUri());
                    ArrayList<ResultPhoto> resultPhotos = new ArrayList<ResultPhoto>();
                    this.mResultPhoto.setCropped(true);
                    resultPhotos.add(this.mResultPhoto);
                    this.takeCompressResult(resultPhotos, new String[0]);
                }
            } else if (this.multipleCrop != null) {
                this.cropContinue(false);
            }
        }
    }

    private void addNewPhoto(Photo photo) {
        MediaScannerConnectionUtils.refresh((Context)this, photo.path);
        photo.selectedOriginal = Setting.selectedOriginal;
        String albumItem_all_name = this.albumModel.getAllAlbumName((Context)this);
        this.albumModel.album.getAlbumItem(albumItem_all_name).addImageItem(0, photo);
        String folderPath = new File(photo.path).getParentFile().getAbsolutePath();
        String albumName = StringUtils.getLastPathSegment(folderPath);
        this.albumModel.album.addAlbumItem(albumName, folderPath, photo.path, photo.uri);
        this.albumModel.album.getAlbumItem(albumName).addImageItem(0, photo);
        this.albumItemList.clear();
        this.albumItemList.addAll(this.albumModel.getAlbumItems());
        if (Setting.hasAlbumItemsAd()) {
            int albumItemsAdIndex = 2;
            if (this.albumItemList.size() < albumItemsAdIndex + 1) {
                albumItemsAdIndex = this.albumItemList.size() - 1;
            }
            this.albumItemList.add(albumItemsAdIndex, Setting.albumItemsAdView);
        }
        this.albumItemsAdapter.notifyDataSetChanged();
        if (Setting.count == 1) {
            ResultStorage.clear();
            this.onSelectorOutOfMax(ResultStorage.addPhoto(photo));
        } else if (ResultStorage.count() >= Setting.count) {
            this.onSelectorOutOfMax(null);
        } else {
            this.onSelectorOutOfMax(ResultStorage.addPhoto(photo));
        }
        this.rvAlbumItems.scrollToPosition(0);
        this.albumItemsAdapter.setSelectedPosition(0);
        this.shouldShowMenuDone();
    }

    private void onCameraResult(Photo photo) {
        if (Build.VERSION.SDK_INT > 28) {
            if (Setting.onlyStartCamera || this.albumModel.getAlbumItems().isEmpty()) {
                photo.selectedOriginal = Setting.selectedOriginal;
                ArrayList<ResultPhoto> resultPhotos = new ArrayList<ResultPhoto>();
                resultPhotos.add(PhotoUtils.getResultPhoto((Activity)this, photo, ImageType.CAMERA));
                this.setActivityResult(resultPhotos);
                return;
            }
            this.addNewPhoto(photo);
        } else {
            if (Setting.onlyStartCamera || this.albumModel.getAlbumItems().isEmpty()) {
                photo.selectedOriginal = Setting.selectedOriginal;
                ArrayList<ResultPhoto> resultPhotos = new ArrayList<ResultPhoto>();
                resultPhotos.add(PhotoUtils.getResultPhoto((Activity)this, photo, ImageType.CAMERA));
                this.setActivityResult(resultPhotos);
                return;
            }
            this.addNewPhoto(photo);
        }
    }

    private void onAlbumResult() {
        ArrayList<ResultPhoto> resultPhotos = new ArrayList<ResultPhoto>();
        for (Photo photo : ResultStorage.photos) {
            try {
                if (photo.width == 0 || photo.height == 0) {
                    BitmapUtils.calculateLocalImageSizeThroughBitmapOptions((Context)this, photo);
                }
                if (BitmapUtils.needChangeWidthAndHeight((Context)this, photo).booleanValue()) {
                    int h = photo.width;
                    photo.width = photo.height;
                    photo.height = h;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            resultPhotos.add(PhotoUtils.getResultPhoto((Activity)this, photo, ImageType.CAMERA));
        }
        ResultStorage.processOriginal();
        this.setActivityResult(resultPhotos);
    }

    public void onSingleCrop(Photo photo, ResultPhoto resultPhoto, CropOptions options) throws BException {
        this.mResultPhoto = resultPhoto;
        BubingLog.d(TAG, " onSingleCrop Photo\uff1a" + photo.toString() + " resultPhoto\uff1a" + resultPhoto.toString());
        if (!ImageFiles.checkMimeType((Context)this, ImageFiles.getMimeType((Activity)this, photo.uri))) {
            Toast.makeText((Context)this, (CharSequence)this.getResources().getText(R.string.tip_type_not_image), (int)0).show();
            throw new BException(BExceptionType.TYPE_NOT_IMAGE);
        }
        this.cropWithNonException(photo, this.mResultPhoto, options);
    }

    public void onMultipleCrop(MultipleCrop multipleCrop, CropOptions options) throws BException {
        this.multipleCrop = multipleCrop;
        this.onSingleCrop(multipleCrop.getPhotos().get(0), multipleCrop.getResultPhotos().get(0), options);
    }

    private void cropWithNonException(Photo photo, ResultPhoto resultPhoto, CropOptions options) {
        this.mResultPhoto = resultPhoto;
        if (options.isWithOwnCrop()) {
            CropUtils.cropWithOwnApp(ContextWrap.of((Activity)this), photo.uri, resultPhoto.getOriginalUri(), options);
        } else {
            CropUtils.cropWithOtherAppBySafely(ContextWrap.of((Activity)this), photo.uri, resultPhoto.getOriginalUri(), options);
        }
    }

    private void cropContinue(boolean preSuccess) {
        Map result = this.multipleCrop.setCropWithUri(this.mResultPhoto, preSuccess);
        int index = (Integer)result.get("index");
        boolean isLast = (Boolean)result.get("isLast");
        if (isLast) {
            if (preSuccess) {
                this.takeCompressResult(this.multipleCrop.getResultPhotos(), new String[0]);
            } else {
                this.takeCompressResult(this.multipleCrop.getResultPhotos(), this.mResultPhoto.getOriginalUri().getPath() + this.getResources().getString(R.string.msg_crop_canceled));
            }
        } else {
            this.cropWithNonException(this.multipleCrop.getPhotos().get(index + 1), this.multipleCrop.getResultPhotos().get(index + 1), Setting.cropOptions);
        }
    }

    private void deleteRawFile(ArrayList<ResultPhoto> images) {
        for (ResultPhoto image : images) {
            if (ImageType.CAMERA != image.getImageType()) continue;
            FileUtils.delete(image.getOriginalPath());
            image.setOriginalPath("");
        }
    }

    private void takeCompressResult(final ArrayList<ResultPhoto> resultPhotos, final String ... message) {
        if (!Setting.isCompress()) {
            this.onTakeResult(resultPhotos, message);
        } else {
            if (Setting.isCompressDialog()) {
                this.wailLoadDialog = CropUtils.showProgressDialog((Activity)this, this.getResources().getString(R.string.tip_compress));
            }
            CompressImageImpl.of((Context)this, Setting.compressConfig, resultPhotos, new CompressImage.CompressListener(){

                @Override
                public void onCompressSuccess(ArrayList<ResultPhoto> images) {
                    if (!Setting.compressConfig.isEnableReserveRaw()) {
                        CameraAlbumActivity.this.deleteRawFile(images);
                    }
                    CameraAlbumActivity.this.onTakeResult(resultPhotos, new String[0]);
                    if (CameraAlbumActivity.this.wailLoadDialog != null && !CameraAlbumActivity.this.isFinishing()) {
                        CameraAlbumActivity.this.wailLoadDialog.dismiss();
                    }
                }

                @Override
                public void onCompressFailed(ArrayList<ResultPhoto> images, String msg) {
                    if (!Setting.compressConfig.isEnableReserveRaw()) {
                        CameraAlbumActivity.this.deleteRawFile(images);
                    }
                    CameraAlbumActivity.this.onTakeResult(images, new String[]{String.format(CameraAlbumActivity.this.getResources().getString(R.string.tip_compress_failed), message.length > 0 ? message[0] : "", msg, ((ResultPhoto)resultPhotos.get(0)).getCompressPath())});
                    if (CameraAlbumActivity.this.wailLoadDialog != null && !CameraAlbumActivity.this.isFinishing()) {
                        CameraAlbumActivity.this.wailLoadDialog.dismiss();
                    }
                }
            }).compress();
        }
    }

    private void onTakeResult(ArrayList<ResultPhoto> resultPhotos, String ... message) {
        if (message.length > 0 && !TextUtils.isEmpty((CharSequence)message[0])) {
            Toast.makeText((Context)this, (CharSequence)message[0], (int)0).show();
            BubingLog.i("onResultCallBack result\uff1a" + resultPhotos.toString() + " message\uff1a" + message[0]);
        } else if (this.multipleCrop != null && this.multipleCrop.isHasFailed()) {
            Toast.makeText((Context)this, (CharSequence)this.getResources().getString(R.string.msg_crop_failed), (int)0).show();
            BubingLog.i("onResultCallBack resultPhotos\uff1a" + resultPhotos.toString() + " message\uff1a" + this.getResources().getString(R.string.msg_crop_failed));
        } else if (Setting.compressConfig != null) {
            boolean hasFailed = false;
            for (ResultPhoto image : resultPhotos) {
                if (image != null && image.isCompressed()) continue;
                hasFailed = true;
                break;
            }
            if (hasFailed) {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.msg_compress_failed), (int)0).show();
                BubingLog.i("onResultCallBack hasFailed\uff1a" + hasFailed + " message\uff1a" + this.getString(R.string.msg_compress_failed));
            } else {
                BubingLog.i("onResultCallBack hasFailed\uff1a" + hasFailed + " result\uff1a" + resultPhotos.toString());
                this.setActivityResult(resultPhotos);
            }
        } else {
            BubingLog.i("onResultCallBack result\uff1a" + resultPhotos.toString());
            this.setActivityResult(resultPhotos);
        }
        this.clearParams();
    }

    private void setActivityResult(ArrayList<ResultPhoto> resultPhotos) {
        Intent intent = new Intent();
        intent.putParcelableArrayListExtra("keyOfEasyPhotosResult", resultPhotos);
        intent.putExtra("keyOfEasyPhotosResultSelectedOriginal", Setting.selectedOriginal);
        this.setResult(-1, intent);
        this.finish();
    }

    private void clearParams() {
        this.multipleCrop = null;
    }
}

