/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.result;

import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.bubing.camera.callback.PuzzleCallback;
import com.bubing.camera.callback.SelectCallback;
import com.bubing.camera.engine.ImageEngine;
import com.bubing.camera.models.album.entity.Photo;
import com.bubing.camera.ui.CameraAlbumActivity;
import com.bubing.camera.ui.PuzzleActivity;
import java.util.ArrayList;

public class HolderFragment
extends Fragment {
    private static final int HOLDER_SELECT_REQUEST_CODE = 68;
    private static final int HOLDER_PUZZLE_REQUEST_CODE = 85;
    private SelectCallback mSelectCallback;
    private PuzzleCallback mPuzzleCallback;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
    }

    public void startEasyPhoto(SelectCallback callback) {
        this.mSelectCallback = callback;
        CameraAlbumActivity.start(this, 68);
    }

    public void startPuzzleWithPhotos(ArrayList<Photo> photos, String puzzleSaveDirPath, String puzzleSaveNamePrefix, boolean replaceCustom, @NonNull ImageEngine imageEngine, PuzzleCallback callback) {
        this.mPuzzleCallback = callback;
        PuzzleActivity.startWithPhotos(this, photos, puzzleSaveDirPath, puzzleSaveNamePrefix, 85, replaceCustom, imageEngine);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (-1 == resultCode) {
            switch (requestCode) {
                case 68: {
                    if (this.mSelectCallback == null) break;
                    ArrayList resultPhotos = data.getParcelableArrayListExtra("keyOfEasyPhotosResult");
                    boolean selectedOriginal = data.getBooleanExtra("keyOfEasyPhotosResultSelectedOriginal", false);
                    this.mSelectCallback.onResult(resultPhotos, selectedOriginal);
                    break;
                }
                case 85: {
                    if (this.mPuzzleCallback == null) break;
                    Photo puzzlePhoto = (Photo)data.getParcelableExtra("keyOfEasyPhotosResult");
                    this.mPuzzleCallback.onResult(puzzlePhoto);
                }
            }
        }
    }
}

