/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.models.puzzle.straight;

import android.graphics.PointF;
import android.graphics.RectF;
import android.util.Pair;
import com.bubing.camera.models.puzzle.Area;
import com.bubing.camera.models.puzzle.Line;
import com.bubing.camera.models.puzzle.PuzzleLayout;
import com.bubing.camera.models.puzzle.straight.StraightArea;
import com.bubing.camera.models.puzzle.straight.StraightLine;
import com.bubing.camera.models.puzzle.straight.StraightUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class StraightPuzzleLayout
implements PuzzleLayout {
    private RectF bounds;
    private StraightArea outerArea;
    private List<StraightArea> areas = new ArrayList<StraightArea>();
    private List<Line> lines = new ArrayList<Line>();
    private List<Line> outerLines = new ArrayList<Line>(4);
    private float padding;
    private float radian;
    private int color;
    private Comparator<StraightArea> areaComparator = new StraightArea.AreaComparator();
    private ArrayList<PuzzleLayout.Step> steps = new ArrayList();

    protected StraightPuzzleLayout() {
    }

    @Override
    public void setOuterBounds(RectF bounds) {
        this.reset();
        this.bounds = bounds;
        PointF one = new PointF(bounds.left, bounds.top);
        PointF two = new PointF(bounds.right, bounds.top);
        PointF three = new PointF(bounds.left, bounds.bottom);
        PointF four = new PointF(bounds.right, bounds.bottom);
        StraightLine lineLeft = new StraightLine(one, three);
        StraightLine lineTop = new StraightLine(one, two);
        StraightLine lineRight = new StraightLine(two, four);
        StraightLine lineBottom = new StraightLine(three, four);
        this.outerLines.clear();
        this.outerLines.add(lineLeft);
        this.outerLines.add(lineTop);
        this.outerLines.add(lineRight);
        this.outerLines.add(lineBottom);
        this.outerArea = new StraightArea();
        this.outerArea.lineLeft = lineLeft;
        this.outerArea.lineTop = lineTop;
        this.outerArea.lineRight = lineRight;
        this.outerArea.lineBottom = lineBottom;
        this.areas.clear();
        this.areas.add(this.outerArea);
    }

    @Override
    public abstract void layout();

    @Override
    public int getAreaCount() {
        return this.areas.size();
    }

    @Override
    public List<Line> getOuterLines() {
        return this.outerLines;
    }

    @Override
    public List<Line> getLines() {
        return this.lines;
    }

    @Override
    public void update() {
        for (Line line : this.lines) {
            line.update(this.width(), this.height());
        }
    }

    @Override
    public float width() {
        return this.outerArea == null ? 0.0f : this.outerArea.width();
    }

    @Override
    public float height() {
        return this.outerArea == null ? 0.0f : this.outerArea.height();
    }

    @Override
    public void reset() {
        this.lines.clear();
        this.areas.clear();
        this.areas.add(this.outerArea);
        this.steps.clear();
    }

    @Override
    public Area getArea(int position) {
        return this.areas.get(position);
    }

    @Override
    public StraightArea getOuterArea() {
        return this.outerArea;
    }

    @Override
    public void setPadding(float padding) {
        this.padding = padding;
        for (Area area : this.areas) {
            area.setPadding(padding);
        }
        this.outerArea.lineLeft.startPoint().set(this.bounds.left + padding, this.bounds.top + padding);
        this.outerArea.lineLeft.endPoint().set(this.bounds.left + padding, this.bounds.bottom - padding);
        this.outerArea.lineRight.startPoint().set(this.bounds.right - padding, this.bounds.top + padding);
        this.outerArea.lineRight.endPoint().set(this.bounds.right - padding, this.bounds.bottom - padding);
        this.update();
    }

    @Override
    public float getPadding() {
        return this.padding;
    }

    protected void addLine(int position, Line.Direction direction, float ratio) {
        StraightArea area = this.areas.get(position);
        this.addLine(area, direction, ratio);
        PuzzleLayout.Step step = new PuzzleLayout.Step();
        step.type = 0;
        step.direction = direction == Line.Direction.HORIZONTAL ? 0 : 1;
        step.position = position;
        this.steps.add(step);
    }

    private List<StraightArea> addLine(StraightArea area, Line.Direction direction, float ratio) {
        this.areas.remove(area);
        StraightLine line = StraightUtils.createLine(area, direction, ratio);
        this.lines.add(line);
        List<StraightArea> increasedArea = StraightUtils.cutArea(area, line);
        this.areas.addAll(increasedArea);
        this.updateLineLimit();
        this.sortAreas();
        return increasedArea;
    }

    protected void cutAreaEqualPart(int position, int part, Line.Direction direction) {
        StraightArea temp = this.areas.get(position);
        for (int i = part; i > 1; --i) {
            temp = this.addLine(temp, direction, (float)(i - 1) / (float)i).get(0);
        }
        PuzzleLayout.Step step = new PuzzleLayout.Step();
        step.type = 3;
        step.part = part;
        step.position = position;
        step.direction = direction == Line.Direction.HORIZONTAL ? 0 : 1;
        this.steps.add(step);
    }

    protected void addCross(int position, float ratio) {
        this.addCross(position, ratio, ratio);
    }

    protected void addCross(int position, float horizontalRatio, float verticalRatio) {
        StraightArea area = this.areas.get(position);
        this.areas.remove(area);
        StraightLine horizontal = StraightUtils.createLine(area, Line.Direction.HORIZONTAL, horizontalRatio);
        StraightLine vertical = StraightUtils.createLine(area, Line.Direction.VERTICAL, verticalRatio);
        this.lines.add(horizontal);
        this.lines.add(vertical);
        List<StraightArea> newAreas = StraightUtils.cutAreaCross(area, horizontal, vertical);
        this.areas.addAll(newAreas);
        this.updateLineLimit();
        this.sortAreas();
        PuzzleLayout.Step step = new PuzzleLayout.Step();
        step.type = 1;
        step.position = position;
        this.steps.add(step);
    }

    protected void cutAreaEqualPart(int position, int hSize, int vSize) {
        StraightArea area = this.areas.get(position);
        this.areas.remove(area);
        Pair<List<StraightLine>, List<StraightArea>> increased = StraightUtils.cutArea(area, hSize, vSize);
        List newLines = (List)increased.first;
        List newAreas = (List)increased.second;
        this.lines.addAll(newLines);
        this.areas.addAll(newAreas);
        this.updateLineLimit();
        this.sortAreas();
        PuzzleLayout.Step step = new PuzzleLayout.Step();
        step.type = 2;
        step.position = position;
        step.hSize = hSize;
        step.vSize = vSize;
        this.steps.add(step);
    }

    protected void cutSpiral(int position) {
        StraightArea area = this.areas.get(position);
        this.areas.remove(area);
        Pair<List<StraightLine>, List<StraightArea>> spilt = StraightUtils.cutAreaSpiral(area);
        this.lines.addAll((Collection)spilt.first);
        this.areas.addAll((Collection)spilt.second);
        this.updateLineLimit();
        this.sortAreas();
        PuzzleLayout.Step step = new PuzzleLayout.Step();
        step.type = 4;
        step.position = position;
        this.steps.add(step);
    }

    private void sortAreas() {
        Collections.sort(this.areas, this.areaComparator);
    }

    private void updateLineLimit() {
        for (int i = 0; i < this.lines.size(); ++i) {
            Line line = this.lines.get(i);
            this.updateUpperLine(line);
            this.updateLowerLine(line);
        }
    }

    private void updateLowerLine(Line line) {
        for (int i = 0; i < this.lines.size(); ++i) {
            Line l = this.lines.get(i);
            if (l == line || l.direction() != line.direction()) continue;
            if (l.direction() == Line.Direction.HORIZONTAL) {
                if (l.maxX() <= line.minX() || line.maxX() <= l.minX() || !(l.minY() > line.lowerLine().maxY()) || !(l.maxY() < line.minY())) continue;
                line.setLowerLine(l);
                continue;
            }
            if (l.maxY() <= line.minY() || line.maxY() <= l.minY() || !(l.minX() > line.lowerLine().maxX()) || !(l.maxX() < line.minX())) continue;
            line.setLowerLine(l);
        }
    }

    private void updateUpperLine(Line line) {
        for (int i = 0; i < this.lines.size(); ++i) {
            Line l = this.lines.get(i);
            if (l == line || l.direction() != line.direction()) continue;
            if (l.direction() == Line.Direction.HORIZONTAL) {
                if (l.maxX() <= line.minX() || line.maxX() <= l.minX() || !(l.maxY() < line.upperLine().minY()) || !(l.minY() > line.maxY())) continue;
                line.setUpperLine(l);
                continue;
            }
            if (l.maxY() <= line.minY() || line.maxY() <= l.minY() || !(l.maxX() < line.upperLine().minX()) || !(l.minX() > line.maxX())) continue;
            line.setUpperLine(l);
        }
    }

    @Override
    public float getRadian() {
        return this.radian;
    }

    @Override
    public void setRadian(float radian) {
        this.radian = radian;
        for (Area area : this.areas) {
            area.setRadian(radian);
        }
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setColor(int color2) {
        this.color = color2;
    }

    @Override
    public PuzzleLayout.Info generateInfo() {
        PuzzleLayout.Info info = new PuzzleLayout.Info();
        info.type = 0;
        info.padding = this.padding;
        info.radian = this.radian;
        info.color = this.color;
        info.steps = this.steps;
        ArrayList<PuzzleLayout.LineInfo> lineInfos = new ArrayList<PuzzleLayout.LineInfo>();
        for (Line line : this.lines) {
            PuzzleLayout.LineInfo lineInfo = new PuzzleLayout.LineInfo(line);
            lineInfos.add(lineInfo);
        }
        info.lineInfos = lineInfos;
        return info;
    }
}

