/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.models.crop;

import android.app.Activity;
import com.bubing.camera.constant.ImageType;
import com.bubing.camera.exception.BException;
import com.bubing.camera.models.ResultPhoto;
import com.bubing.camera.models.album.entity.Photo;
import com.bubing.camera.utils.PhotoUtils;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MultipleCrop {
    private ArrayList<Photo> photos;
    private ArrayList<ResultPhoto> resultPhotos;
    private ImageType imageType;
    private boolean hasFailed;

    public static MultipleCrop of(Activity activity, ArrayList<Photo> photos, ImageType imageType) throws BException {
        return new MultipleCrop(activity, photos, imageType);
    }

    public static MultipleCrop of(ArrayList<Photo> photos, ArrayList<ResultPhoto> cropPhotos, ImageType imageType) {
        return new MultipleCrop(photos, cropPhotos, imageType);
    }

    private MultipleCrop(Activity activity, ArrayList<Photo> photos, ImageType imageType) throws BException {
        this.photos = photos;
        ArrayList<ResultPhoto> resultPhotos = new ArrayList<ResultPhoto>();
        for (Photo photo : photos) {
            resultPhotos.add(PhotoUtils.getCropPhoto(activity, photo, imageType));
        }
        this.resultPhotos = resultPhotos;
        this.imageType = imageType;
    }

    private MultipleCrop(ArrayList<Photo> photos, ArrayList<ResultPhoto> resultPhotos, ImageType imageType) {
        this.photos = photos;
        this.resultPhotos = resultPhotos;
        this.imageType = imageType;
    }

    public ArrayList<Photo> getPhotos() {
        return this.photos;
    }

    public void setPhotos(ArrayList<Photo> photos) {
        this.photos = photos;
    }

    public ArrayList<ResultPhoto> getResultPhotos() {
        return this.resultPhotos;
    }

    public void setResultPhotos(ArrayList<ResultPhoto> resultPhotos) {
        this.resultPhotos = resultPhotos;
    }

    public ImageType getImageType() {
        return this.imageType;
    }

    public void setImageType(ImageType imageType) {
        this.imageType = imageType;
    }

    public boolean isHasFailed() {
        return this.hasFailed;
    }

    public void setHasFailed(boolean hasFailed) {
        this.hasFailed = hasFailed;
    }

    public Map setCropWithUri(ResultPhoto resultPhoto, boolean cropped) {
        if (!cropped) {
            this.hasFailed = true;
        }
        int index = this.resultPhotos.indexOf(resultPhoto);
        this.resultPhotos.get(index).setCropped(cropped);
        HashMap<String, Constable> result = new HashMap<String, Constable>();
        result.put("index", Integer.valueOf(index));
        result.put("isLast", Boolean.valueOf(index == this.resultPhotos.size() - 1));
        return result;
    }
}

