/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.models.crop;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.widget.Toast;
import com.bubing.camera.exception.BException;
import com.bubing.camera.exception.BExceptionType;
import com.bubing.camera.models.ContextWrap;
import com.bubing.camera.models.IntentWap;
import com.bubing.camera.models.crop.CropOptions;
import com.bubing.camera.utils.BubingLog;
import com.bubing.camera.utils.IntentUtils;
import com.soundcloud.android.crop.Crop;
import java.util.List;

public class CropUtils {
    private static final String TAG = CropUtils.class.getName();

    public static void startActivityForResult(ContextWrap contextWrap, IntentWap intentWap) {
        if (contextWrap.getFragment() != null) {
            contextWrap.getFragment().startActivityForResult(intentWap.getIntent(), intentWap.getRequestCode());
        } else {
            contextWrap.getActivity().startActivityForResult(intentWap.getIntent(), intentWap.getRequestCode());
        }
    }

    public static void sendIntentBySafely(ContextWrap contextWrap, List<IntentWap> intentWapList, int defaultIndex, boolean isCrop) throws BException {
        if (defaultIndex + 1 > intentWapList.size()) {
            throw new BException(isCrop ? BExceptionType.TYPE_NO_MATCH_PICK_INTENT : BExceptionType.TYPE_NO_MATCH_CROP_INTENT);
        }
        IntentWap intentWap = intentWapList.get(defaultIndex);
        List result = contextWrap.getActivity().getPackageManager().queryIntentActivities(intentWap.getIntent(), 131072);
        if (result.isEmpty()) {
            CropUtils.sendIntentBySafely(contextWrap, intentWapList, ++defaultIndex, isCrop);
        } else {
            CropUtils.startActivityForResult(contextWrap, intentWap);
        }
    }

    public static void captureBySafely(ContextWrap contextWrap, IntentWap intentWap) throws BException {
        List result = contextWrap.getActivity().getPackageManager().queryIntentActivities(intentWap.getIntent(), 131072);
        if (result.isEmpty()) {
            Toast.makeText((Context)contextWrap.getActivity(), (CharSequence)"\u6ca1\u6709\u76f8\u673a", (int)0).show();
            throw new BException(BExceptionType.TYPE_NO_CAMERA);
        }
        CropUtils.startActivityForResult(contextWrap, intentWap);
    }

    public static void cropWithOtherAppBySafely(ContextWrap contextWrap, Uri imageUri, Uri outPutUri, CropOptions options) {
        Intent nativeCropIntent = IntentUtils.getCropIntentWithOtherApp(imageUri, outPutUri, options);
        List result = contextWrap.getActivity().getPackageManager().queryIntentActivities(nativeCropIntent, 131072);
        if (result.isEmpty()) {
            CropUtils.cropWithOwnApp(contextWrap, imageUri, outPutUri, options);
        } else {
            CropUtils.startActivityForResult(contextWrap, new IntentWap(IntentUtils.getCropIntentWithOtherApp(imageUri, outPutUri, options), 1001));
        }
    }

    public static void cropWithOwnApp(ContextWrap contextWrap, Uri imageUri, Uri outPutUri, CropOptions options) {
        if (options.getAspectX() * options.getAspectY() > 0) {
            if (contextWrap.getFragment() != null) {
                Crop.of((Uri)imageUri, (Uri)outPutUri).withAspect(options.getAspectX(), options.getAspectY()).start((Context)contextWrap.getActivity(), contextWrap.getFragment());
            } else {
                Crop.of((Uri)imageUri, (Uri)outPutUri).withAspect(options.getAspectX(), options.getAspectY()).start(contextWrap.getActivity());
            }
        } else if (options.getOutputX() * options.getOutputY() > 0) {
            if (contextWrap.getFragment() != null) {
                Crop.of((Uri)imageUri, (Uri)outPutUri).withMaxSize(options.getOutputX(), options.getOutputY()).start((Context)contextWrap.getActivity(), contextWrap.getFragment());
            } else {
                Crop.of((Uri)imageUri, (Uri)outPutUri).withMaxSize(options.getOutputX(), options.getOutputY()).start(contextWrap.getActivity());
            }
        } else if (contextWrap.getFragment() != null) {
            Crop.of((Uri)imageUri, (Uri)outPutUri).asSquare().start((Context)contextWrap.getActivity(), contextWrap.getFragment());
        } else {
            Crop.of((Uri)imageUri, (Uri)outPutUri).asSquare().start(contextWrap.getActivity());
        }
    }

    public static boolean isReturnData() {
        String release = Build.VERSION.RELEASE;
        int sdk = Build.VERSION.SDK_INT;
        BubingLog.i(TAG, "release:" + release + "sdk:" + sdk);
        String manufacturer = Build.MANUFACTURER;
        return !TextUtils.isEmpty((CharSequence)manufacturer) && manufacturer.toLowerCase().contains("lenovo");
    }

    public static ProgressDialog showProgressDialog(Activity activity, String ... progressTitle) {
        if (activity == null || activity.isFinishing()) {
            return null;
        }
        String title = "\u63d0\u793a";
        if (progressTitle != null && progressTitle.length > 0) {
            title = progressTitle[0];
        }
        ProgressDialog progressDialog = new ProgressDialog((Context)activity);
        progressDialog.setTitle((CharSequence)title);
        progressDialog.setCancelable(false);
        progressDialog.show();
        return progressDialog;
    }
}

