/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.models.compress;

import android.content.Context;
import android.text.TextUtils;
import com.bubing.camera.models.ResultPhoto;
import com.bubing.camera.models.compress.CompressConfig;
import com.bubing.camera.models.compress.CompressImage;
import com.bubing.camera.models.compress.CompressImageUtil;
import com.bubing.camera.models.compress.CompressWithLuBan;
import java.io.File;
import java.util.ArrayList;

public class CompressImageImpl
implements CompressImage {
    private CompressImageUtil compressImageUtil;
    private ArrayList<ResultPhoto> images;
    private CompressImage.CompressListener listener;

    public static CompressImage of(Context context, CompressConfig config, ArrayList<ResultPhoto> images, CompressImage.CompressListener listener) {
        if (config.getLubanOptions() != null) {
            return new CompressWithLuBan(context, config, images, listener);
        }
        return new CompressImageImpl(context, config, images, listener);
    }

    private CompressImageImpl(Context context, CompressConfig config, ArrayList<ResultPhoto> images, CompressImage.CompressListener listener) {
        this.compressImageUtil = new CompressImageUtil(context, config);
        this.images = images;
        this.listener = listener;
    }

    @Override
    public void compress() {
        if (this.images == null || this.images.isEmpty()) {
            this.listener.onCompressFailed(this.images, " images is null");
        }
        for (ResultPhoto image : this.images) {
            if (image != null) continue;
            this.listener.onCompressFailed(this.images, " There are pictures of compress  is null.");
            return;
        }
        this.compress(this.images.get(0));
    }

    private void compress(final ResultPhoto image) {
        if (TextUtils.isEmpty((CharSequence)image.getOriginalPath())) {
            this.continueCompress(image, false, new String[0]);
            return;
        }
        File file = new File(image.getOriginalPath());
        if (file == null || !file.exists() || !file.isFile()) {
            this.continueCompress(image, false, new String[0]);
            return;
        }
        this.compressImageUtil.compress(image.getOriginalPath(), new CompressImageUtil.CompressListener(){

            @Override
            public void onCompressSuccess(String imgPath) {
                image.setCompressPath(imgPath);
                CompressImageImpl.this.continueCompress(image, true, new String[0]);
            }

            @Override
            public void onCompressFailed(String imgPath, String msg) {
                CompressImageImpl.this.continueCompress(image, false, new String[]{msg});
            }
        });
    }

    private void continueCompress(ResultPhoto image, boolean preSuccess, String ... message) {
        boolean isLast;
        image.setCompressed(preSuccess);
        int index = this.images.indexOf(image);
        boolean bl = isLast = index == this.images.size() - 1;
        if (isLast) {
            this.handleCompressCallBack(message);
        } else {
            this.compress(this.images.get(index + 1));
        }
    }

    private void handleCompressCallBack(String ... message) {
        if (message.length > 0) {
            this.listener.onCompressFailed(this.images, message[0]);
            return;
        }
        for (ResultPhoto image : this.images) {
            if (image.isCompressed()) continue;
            this.listener.onCompressFailed(this.images, image.getCompressPath() + " is compress failures");
            return;
        }
        this.listener.onCompressSuccess(this.images);
    }
}

