/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.models;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.bubing.camera.constant.ImageType;
import com.bubing.camera.utils.BubingLog;

public class ResultPhoto
implements Parcelable {
    private static final String TAG = "Photo";
    public static final Parcelable.Creator<ResultPhoto> CREATOR = new Parcelable.Creator<ResultPhoto>(){

        public ResultPhoto createFromParcel(Parcel source) {
            return new ResultPhoto(source);
        }

        public ResultPhoto[] newArray(int size) {
            return new ResultPhoto[size];
        }
    };
    private Uri uri;
    private String name;
    private String path;
    private String type;
    private int width;
    private int height;
    private long size;
    private long duration;
    private long time;
    private boolean selectedOriginal;
    private ImageType imageType;
    private Uri originalUri;
    private String originalPath;
    private String compressPath;
    private boolean cropped;
    private boolean compressed;

    public ResultPhoto() {
    }

    protected ResultPhoto(Parcel in) {
        this.uri = (Uri)in.readParcelable(Uri.class.getClassLoader());
        this.name = in.readString();
        this.path = in.readString();
        this.type = in.readString();
        this.width = in.readInt();
        this.height = in.readInt();
        this.size = in.readLong();
        this.duration = in.readLong();
        this.time = in.readLong();
        this.selectedOriginal = in.readByte() != 0;
        this.originalUri = (Uri)in.readParcelable(Uri.class.getClassLoader());
        this.originalPath = in.readString();
        this.compressPath = in.readString();
        this.cropped = in.readByte() != 0;
        this.compressed = in.readByte() != 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.uri, flags);
        dest.writeString(this.name);
        dest.writeString(this.path);
        dest.writeString(this.type);
        dest.writeInt(this.width);
        dest.writeInt(this.height);
        dest.writeLong(this.size);
        dest.writeLong(this.duration);
        dest.writeLong(this.time);
        dest.writeByte(this.selectedOriginal ? (byte)1 : 0);
        dest.writeParcelable((Parcelable)this.originalUri, flags);
        dest.writeString(this.originalPath);
        dest.writeString(this.compressPath);
        dest.writeByte(this.cropped ? (byte)1 : 0);
        dest.writeByte(this.compressed ? (byte)1 : 0);
    }

    public boolean equals(Object o) {
        try {
            ResultPhoto other = (ResultPhoto)o;
            return this.path.equalsIgnoreCase(other.path);
        }
        catch (ClassCastException e) {
            BubingLog.e(TAG, "equals: " + BubingLog.getStackTraceString(e));
            return super.equals(o);
        }
    }

    public String toString() {
        return "ResultPhoto{uri:" + this.uri.toString() + ", name:" + this.name + ", path:" + this.path + ", type:" + this.type + ", width:" + this.width + ", height:" + this.height + ", size:" + this.size + ", duration:" + this.duration + ", time:" + this.time + ", selectedOriginal:" + this.selectedOriginal + ", originalUri:" + this.originalUri.toString() + ", originalPath:" + this.originalPath + ", compressPath:" + this.compressPath + ", cropped:" + this.cropped + ", compressed:" + this.compressed + '}';
    }

    public Uri getUri() {
        return this.uri;
    }

    public void setUri(Uri uri) {
        this.uri = uri;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public boolean isSelectedOriginal() {
        return this.selectedOriginal;
    }

    public void setSelectedOriginal(boolean selectedOriginal) {
        this.selectedOriginal = selectedOriginal;
    }

    public ImageType getImageType() {
        return this.imageType;
    }

    public void setImageType(ImageType imageType) {
        this.imageType = imageType;
    }

    public Uri getOriginalUri() {
        return this.originalUri;
    }

    public void setOriginalUri(Uri originalUri) {
        this.originalUri = originalUri;
    }

    public String getOriginalPath() {
        return this.originalPath;
    }

    public void setOriginalPath(String originalPath) {
        this.originalPath = originalPath;
    }

    public String getCompressPath() {
        return this.compressPath;
    }

    public void setCompressPath(String compressPath) {
        this.compressPath = compressPath;
    }

    public boolean isCropped() {
        return this.cropped;
    }

    public void setCropped(boolean cropped) {
        this.cropped = cropped;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }
}

