/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.net.Uri;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import com.bubing.camera.callback.SelectCallback;
import com.bubing.camera.constant.StartupType;
import com.bubing.camera.engine.ImageEngine;
import com.bubing.camera.models.ad.AdListener;
import com.bubing.camera.models.album.entity.Photo;
import com.bubing.camera.models.compress.CompressConfig;
import com.bubing.camera.models.crop.CropOptions;
import com.bubing.camera.result.ResultStorage;
import com.bubing.camera.result.TakeResult;
import com.bubing.camera.setting.Setting;
import com.bubing.camera.ui.CameraAlbumActivity;
import com.bubing.camera.ui.CameraLandscapeActivity;
import com.bubing.camera.ui.CameraPortraitActivity;
import com.bubing.camera.utils.UriUtils;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;

public class TakePhotoImpl {
    private static final String TAG = TakePhotoImpl.class.getName();
    public WeakReference<Activity> mActivity;
    public WeakReference<androidx.fragment.app.Fragment> mFragmentV;
    public WeakReference<Fragment> mFragment;
    public StartupType startupType;
    private static TakePhotoImpl instance;
    private WeakReference<AdListener> adListener;

    private TakePhotoImpl(Activity activity, StartupType startupType) {
        this.mActivity = new WeakReference<Activity>(activity);
        this.startupType = startupType;
    }

    private TakePhotoImpl(FragmentActivity activity, StartupType startupType) {
        this.mActivity = new WeakReference<FragmentActivity>(activity);
        this.startupType = startupType;
    }

    private TakePhotoImpl(Fragment fragment, StartupType startupType) {
        this.mFragment = new WeakReference<Fragment>(fragment);
        this.startupType = startupType;
    }

    private TakePhotoImpl(androidx.fragment.app.Fragment fragment, StartupType startupType) {
        this.mFragmentV = new WeakReference<androidx.fragment.app.Fragment>(fragment);
        this.startupType = startupType;
    }

    private static TakePhotoImpl with(Activity activity, StartupType startupType) {
        TakePhotoImpl.clear();
        instance = new TakePhotoImpl(activity, startupType);
        return instance;
    }

    private static TakePhotoImpl with(Fragment fragment, StartupType startupType) {
        TakePhotoImpl.clear();
        instance = new TakePhotoImpl(fragment, startupType);
        return instance;
    }

    private static TakePhotoImpl with(FragmentActivity activity, StartupType startupType) {
        TakePhotoImpl.clear();
        instance = new TakePhotoImpl(activity, startupType);
        return instance;
    }

    private static TakePhotoImpl with(androidx.fragment.app.Fragment fragmentV, StartupType startupType) {
        TakePhotoImpl.clear();
        instance = new TakePhotoImpl(fragmentV, startupType);
        return instance;
    }

    public static TakePhotoImpl createCamera(Activity activity) {
        return TakePhotoImpl.with(activity, StartupType.CAMERA);
    }

    public static TakePhotoImpl createCamera(Fragment fragment) {
        return TakePhotoImpl.with(fragment, StartupType.CAMERA);
    }

    public static TakePhotoImpl createCamera(FragmentActivity activity) {
        return TakePhotoImpl.with(activity, StartupType.CAMERA);
    }

    public static TakePhotoImpl createCamera(androidx.fragment.app.Fragment fragmentV) {
        return TakePhotoImpl.with(fragmentV, StartupType.CAMERA);
    }

    public static TakePhotoImpl createCamera(Activity activity, StartupType startupType) {
        return TakePhotoImpl.with(activity, StartupType.CAMERA);
    }

    public static TakePhotoImpl createCamera(Fragment fragment, StartupType startupType) {
        return TakePhotoImpl.with(fragment, StartupType.CAMERA);
    }

    public static TakePhotoImpl createCamera(FragmentActivity activity, StartupType startupType) {
        return TakePhotoImpl.with(activity, StartupType.CAMERA);
    }

    public static TakePhotoImpl createCamera(androidx.fragment.app.Fragment fragmentV, StartupType startupType) {
        return TakePhotoImpl.with(fragmentV, StartupType.CAMERA);
    }

    public static TakePhotoImpl createAlbum(Activity activity, boolean isShowCamera, @NonNull ImageEngine imageEngine) {
        if (Setting.imageEngine != imageEngine) {
            Setting.imageEngine = imageEngine;
        }
        if (isShowCamera) {
            return TakePhotoImpl.with(activity, StartupType.ALBUM_CAMERA);
        }
        return TakePhotoImpl.with(activity, StartupType.ALBUM);
    }

    public static TakePhotoImpl createAlbum(Fragment fragment, boolean isShowCamera, @NonNull ImageEngine imageEngine) {
        if (Setting.imageEngine != imageEngine) {
            Setting.imageEngine = imageEngine;
        }
        if (isShowCamera) {
            return TakePhotoImpl.with(fragment, StartupType.ALBUM_CAMERA);
        }
        return TakePhotoImpl.with(fragment, StartupType.ALBUM);
    }

    public static TakePhotoImpl createAlbum(FragmentActivity activity, boolean isShowCamera, @NonNull ImageEngine imageEngine) {
        if (Setting.imageEngine != imageEngine) {
            Setting.imageEngine = imageEngine;
        }
        if (isShowCamera) {
            return TakePhotoImpl.with(activity, StartupType.ALBUM_CAMERA);
        }
        return TakePhotoImpl.with(activity, StartupType.ALBUM);
    }

    public static TakePhotoImpl createAlbum(androidx.fragment.app.Fragment fragmentV, boolean isShowCamera, @NonNull ImageEngine imageEngine) {
        if (Setting.imageEngine != imageEngine) {
            Setting.imageEngine = imageEngine;
        }
        if (isShowCamera) {
            return TakePhotoImpl.with(fragmentV, StartupType.ALBUM_CAMERA);
        }
        return TakePhotoImpl.with(fragmentV, StartupType.ALBUM);
    }

    private void setSettingParams() {
        switch (this.startupType) {
            case CAMERA: {
                Setting.onlyStartCamera = true;
                Setting.isShowCamera = true;
                break;
            }
            case ALBUM: {
                Setting.isShowCamera = false;
                break;
            }
            case ALBUM_CAMERA: {
                Setting.isShowCamera = true;
            }
        }
        if (!Setting.filterTypes.isEmpty()) {
            if (Setting.isFilter("gif")) {
                Setting.showGif = true;
            }
            if (Setting.isFilter("video")) {
                Setting.showVideo = true;
            }
        }
        if (Setting.isOnlyVideo()) {
            Setting.isShowCamera = false;
            Setting.showPuzzleMenu = false;
            Setting.showGif = false;
            Setting.showVideo = true;
        }
        if (Setting.pictureCount != -1 || Setting.videoCount != -1) {
            Setting.count = Setting.pictureCount + Setting.videoCount;
            if (Setting.pictureCount == -1 || Setting.videoCount == -1) {
                ++Setting.count;
            }
        }
    }

    private void launchActivity(int requestCode) {
        if (null != this.mActivity && null != this.mActivity.get()) {
            CameraAlbumActivity.start((Activity)this.mActivity.get(), requestCode);
            return;
        }
        if (null != this.mFragment && null != this.mFragment.get()) {
            CameraAlbumActivity.start((Fragment)this.mFragment.get(), requestCode);
            return;
        }
        if (null != this.mFragmentV && null != this.mFragmentV.get()) {
            CameraAlbumActivity.start((androidx.fragment.app.Fragment)this.mFragmentV.get(), requestCode);
        }
    }

    public void openActivity(int requestCode) {
        if (this.startupType == StartupType.CAMERA_COMPANY_PORTRAIT) {
            if (null != this.mActivity && null != this.mActivity.get()) {
                CameraPortraitActivity.start((Activity)this.mActivity.get(), this.startupType, requestCode);
                return;
            }
            if (null != this.mFragment && null != this.mFragment.get()) {
                CameraPortraitActivity.start((Fragment)this.mFragment.get(), this.startupType, requestCode);
                return;
            }
            if (null != this.mFragmentV && null != this.mFragmentV.get()) {
                CameraPortraitActivity.start((androidx.fragment.app.Fragment)this.mFragmentV.get(), this.startupType, requestCode);
            }
        } else {
            if (null != this.mActivity && null != this.mActivity.get()) {
                CameraLandscapeActivity.start((Activity)this.mActivity.get(), this.startupType, requestCode);
                return;
            }
            if (null != this.mFragment && null != this.mFragment.get()) {
                CameraLandscapeActivity.start((Fragment)this.mFragment.get(), this.startupType, requestCode);
                return;
            }
            if (null != this.mFragmentV && null != this.mFragmentV.get()) {
                CameraLandscapeActivity.start((androidx.fragment.app.Fragment)this.mFragmentV.get(), this.startupType, requestCode);
            }
        }
    }

    public void start(int requestCode) {
        if (this.startupType != null && (StartupType.CAMERA_IDCARD_FRONT == this.startupType || StartupType.CAMERA_IDCARD_BACK == this.startupType || StartupType.CAMERA_COMPANY_PORTRAIT == this.startupType || StartupType.CAMERA_COMPANY_LANDSCAPE == this.startupType)) {
            this.openActivity(requestCode);
        } else {
            this.setSettingParams();
            this.launchActivity(requestCode);
        }
    }

    public void start(SelectCallback callback) {
        this.setSettingParams();
        if (null != this.mActivity && null != this.mActivity.get() && this.mActivity.get() instanceof FragmentActivity) {
            TakeResult.get((FragmentActivity)this.mActivity.get()).startEasyPhoto(callback);
            return;
        }
        if (null != this.mFragmentV && null != this.mFragmentV.get()) {
            TakeResult.get((androidx.fragment.app.Fragment)this.mFragmentV.get()).startEasyPhoto(callback);
            return;
        }
        throw new RuntimeException("mActivity or mFragmentV maybe null, you can not use this method... ");
    }

    private static void clear() {
        ResultStorage.clear();
        Setting.clear();
        instance = null;
    }

    public TakePhotoImpl setCount(int selectorMaxCount) {
        Setting.count = selectorMaxCount;
        return this;
    }

    public TakePhotoImpl setPictureCount(int selectorMaxCount) {
        Setting.pictureCount = selectorMaxCount;
        return this;
    }

    public TakePhotoImpl setVideoCount(int selectorMaxCount) {
        Setting.videoCount = selectorMaxCount;
        return this;
    }

    public TakePhotoImpl setCameraLocation(int cLocation) {
        Setting.cameraLocation = cLocation;
        return this;
    }

    public TakePhotoImpl setMinFileSize(long minFileSize) {
        Setting.minSize = minFileSize;
        return this;
    }

    public TakePhotoImpl setMinWidth(int minWidth) {
        Setting.minWidth = minWidth;
        return this;
    }

    public TakePhotoImpl setMinHeight(int minHeight) {
        Setting.minHeight = minHeight;
        return this;
    }

    public TakePhotoImpl setSelectedPhotos(ArrayList<Photo> selectedPhotos) {
        Setting.selectedPhotos.clear();
        if (selectedPhotos == null || selectedPhotos.isEmpty()) {
            return this;
        }
        Setting.selectedPhotos.addAll(selectedPhotos);
        Setting.selectedOriginal = selectedPhotos.get((int)0).selectedOriginal;
        return this;
    }

    @Deprecated
    public TakePhotoImpl setSelectedPhotoPaths(ArrayList<String> selectedPhotoPaths) {
        Setting.selectedPhotos.clear();
        ArrayList<Photo> selectedPhotos = new ArrayList<Photo>();
        for (String path : selectedPhotoPaths) {
            File file = new File(path);
            Uri uri = null;
            if (null != this.mActivity && null != this.mActivity.get()) {
                uri = UriUtils.getUri((Context)this.mActivity.get(), file);
            }
            if (null != this.mFragment && null != this.mFragment.get()) {
                uri = UriUtils.getUri((Context)((Fragment)this.mFragment.get()).getActivity(), file);
            }
            if (null != this.mFragmentV && null != this.mFragmentV.get()) {
                uri = UriUtils.getUri((Context)((androidx.fragment.app.Fragment)this.mFragmentV.get()).getActivity(), file);
            }
            if (uri == null) {
                uri = Uri.fromFile((File)file);
            }
            selectedPhotos.add(new Photo(null, uri, path, 0L, 0, 0, 0L, 0L, null));
        }
        Setting.selectedPhotos.addAll(selectedPhotos);
        return this;
    }

    public TakePhotoImpl setOriginalMenu(boolean shouldShow, boolean isChecked, boolean usable, String unusableHint) {
        Setting.showOriginalMenu = shouldShow;
        Setting.selectedOriginal = isChecked;
        Setting.originalMenuUsable = usable;
        Setting.originalMenuUnusableHint = unusableHint;
        return this;
    }

    public TakePhotoImpl setOriginalMenu(boolean isChecked, boolean usable, String unusableHint) {
        return this.setOriginalMenu(true, isChecked, usable, unusableHint);
    }

    public TakePhotoImpl setPuzzleMenu(boolean shouldShow) {
        Setting.showPuzzleMenu = shouldShow;
        return this;
    }

    public TakePhotoImpl onlyVideo() {
        return this.filter("video");
    }

    public TakePhotoImpl filter(String ... types) {
        Setting.filterTypes = Arrays.asList(types);
        return this;
    }

    public TakePhotoImpl setGif(boolean shouldShow) {
        Setting.showGif = shouldShow;
        return this;
    }

    public TakePhotoImpl setVideo(boolean shouldShow) {
        Setting.showVideo = shouldShow;
        return this;
    }

    public TakePhotoImpl setVideoMinSecond(int second) {
        Setting.videoMinSecond = second * 1000;
        return this;
    }

    public TakePhotoImpl setVideoMaxSecond(int second) {
        Setting.videoMaxSecond = second * 1000;
        return this;
    }

    public TakePhotoImpl setCleanMenu(boolean shouldShow) {
        Setting.showCleanMenu = shouldShow;
        return this;
    }

    public TakePhotoImpl setCropOptions(CropOptions cropOptions) {
        Setting.cropOptions = cropOptions;
        return this;
    }

    public TakePhotoImpl setCropOptions(boolean correctImage) {
        Setting.correctImage = correctImage;
        return this;
    }

    public TakePhotoImpl setCompressConfig(CompressConfig compressConfig) {
        Setting.compressConfig = compressConfig;
        return this;
    }

    public TakePhotoImpl setCompressDialog(boolean compressDialog) {
        Setting.compressDialog = compressDialog;
        return this;
    }

    public TakePhotoImpl setAdView(View photosAdView, boolean photosAdIsLoaded, View albumItemsAdView, boolean albumItemsAdIsLoaded) {
        Setting.photosAdView = new WeakReference<View>(photosAdView);
        Setting.albumItemsAdView = new WeakReference<View>(albumItemsAdView);
        Setting.photoAdIsOk = photosAdIsLoaded;
        Setting.albumItemsAdIsOk = albumItemsAdIsLoaded;
        return this;
    }

    public static void setAdListener(AdListener adListener) {
        if (null == instance || TakePhotoImpl.instance.startupType == StartupType.CAMERA) {
            return;
        }
        TakePhotoImpl.instance.adListener = new WeakReference<AdListener>(adListener);
    }

    public static void notifyPhotosAdLoaded() {
        if (Setting.photoAdIsOk) {
            return;
        }
        if (null == instance || TakePhotoImpl.instance.startupType == StartupType.CAMERA) {
            return;
        }
        if (null == TakePhotoImpl.instance.adListener) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (null != instance && null != instance.adListener) {
                        Setting.photoAdIsOk = true;
                        ((AdListener)instance.adListener.get()).onPhotosAdLoaded();
                    }
                }
            }).start();
            return;
        }
        Setting.photoAdIsOk = true;
        ((AdListener)TakePhotoImpl.instance.adListener.get()).onPhotosAdLoaded();
    }

    public static void notifyAlbumItemsAdLoaded() {
        if (Setting.albumItemsAdIsOk) {
            return;
        }
        if (null == instance || TakePhotoImpl.instance.startupType == StartupType.CAMERA) {
            return;
        }
        if (null == TakePhotoImpl.instance.adListener) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (null != instance && null != instance.adListener) {
                        Setting.albumItemsAdIsOk = true;
                        ((AdListener)instance.adListener.get()).onAlbumItemsAdLoaded();
                    }
                }
            }).start();
            return;
        }
        Setting.albumItemsAdIsOk = true;
        ((AdListener)TakePhotoImpl.instance.adListener.get()).onAlbumItemsAdLoaded();
    }
}

