/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.bubing.camera.utils.CameraUtils;
import com.bubing.camera.utils.ScreenUtils;
import com.bubing.camera.widget.AutoFocusManager;
import com.bubing.camera.widget.SensorControler;
import java.util.List;

public class CameraPreview
extends SurfaceView
implements SurfaceHolder.Callback {
    private static String TAG = CameraPreview.class.getName();
    private Camera camera;
    private AutoFocusManager mAutoFocusManager;
    private SensorControler mSensorControler;
    private Context mContext;
    private SurfaceHolder mSurfaceHolder;

    public CameraPreview(Context context) {
        super(context);
        this.init(context);
    }

    public CameraPreview(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public CameraPreview(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @TargetApi(value=21)
    public CameraPreview(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        this.mSurfaceHolder = this.getHolder();
        this.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.mSurfaceHolder.setKeepScreenOn(true);
        this.mSurfaceHolder.setType(3);
        this.mSensorControler = SensorControler.getInstance(context.getApplicationContext());
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.camera = CameraUtils.openCamera();
        if (this.camera != null) {
            try {
                this.camera.setPreviewDisplay(holder);
                Camera.Parameters parameters = this.camera.getParameters();
                if (this.getResources().getConfiguration().orientation == 1) {
                    this.camera.setDisplayOrientation(90);
                    parameters.setRotation(90);
                } else {
                    this.camera.setDisplayOrientation(0);
                    parameters.setRotation(0);
                }
                List sizeList = parameters.getSupportedPreviewSizes();
                Camera.Size bestSize = this.getOptimalPreviewSize(sizeList, ScreenUtils.getScreenWidth(this.mContext), ScreenUtils.getScreenHeight(this.mContext));
                parameters.setPreviewSize(bestSize.width, bestSize.height);
                this.camera.setParameters(parameters);
                this.camera.startPreview();
                this.focus();
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)("Error setting camera preview: " + e.getMessage()));
                try {
                    Camera.Parameters parameters = this.camera.getParameters();
                    if (this.getResources().getConfiguration().orientation == 1) {
                        this.camera.setDisplayOrientation(90);
                        parameters.setRotation(90);
                    } else {
                        this.camera.setDisplayOrientation(0);
                        parameters.setRotation(0);
                    }
                    this.camera.setParameters(parameters);
                    this.camera.startPreview();
                    this.focus();
                }
                catch (Exception e1) {
                    e.printStackTrace();
                    this.camera = null;
                }
            }
        }
    }

    private Camera.Size getOptimalPreviewSize(List<Camera.Size> sizes, int w, int h) {
        double ASPECT_TOLERANCE = 0.1;
        double targetRatio = (double)w / (double)h;
        if (sizes == null) {
            return null;
        }
        Camera.Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        int targetHeight = h;
        for (Camera.Size size : sizes) {
            double ratio = (double)size.width / (double)size.height;
            if (Math.abs(ratio - targetRatio) > 0.1 || !((double)Math.abs(size.height - targetHeight) < minDiff)) continue;
            optimalSize = size;
            minDiff = Math.abs(size.height - targetHeight);
        }
        if (optimalSize == null) {
            minDiff = Double.MAX_VALUE;
            for (Camera.Size size : sizes) {
                if (!((double)Math.abs(size.height - targetHeight) < minDiff)) continue;
                optimalSize = size;
                minDiff = Math.abs(size.height - targetHeight);
            }
        }
        return optimalSize;
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        holder.removeCallback((SurfaceHolder.Callback)this);
        this.release();
    }

    private void release() {
        if (this.camera != null) {
            this.camera.setPreviewCallback(null);
            this.camera.stopPreview();
            this.camera.release();
            this.camera = null;
            if (this.mAutoFocusManager != null) {
                this.mAutoFocusManager.stop();
                this.mAutoFocusManager = null;
            }
        }
    }

    public void focus() {
        if (this.camera != null) {
            try {
                this.camera.autoFocus(null);
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)("takePhoto " + e));
            }
        }
    }

    public boolean switchFlashLight() {
        if (this.camera != null) {
            Camera.Parameters parameters = this.camera.getParameters();
            if (parameters.getFlashMode().equals("off")) {
                parameters.setFlashMode("torch");
                this.camera.setParameters(parameters);
                return true;
            }
            parameters.setFlashMode("off");
            this.camera.setParameters(parameters);
            return false;
        }
        return false;
    }

    public void takePhoto(Camera.PictureCallback pictureCallback) {
        if (this.camera != null) {
            try {
                this.camera.takePicture(null, null, pictureCallback);
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)("takePhoto " + e));
            }
        }
    }

    public void startPreview() {
        if (this.camera != null) {
            this.camera.startPreview();
        }
    }

    public void onStart() {
        this.addCallback();
        if (this.mSensorControler != null) {
            this.mSensorControler.onStart();
            this.mSensorControler.setCameraFocusListener(new SensorControler.CameraFocusListener(){

                @Override
                public void onFocus() {
                    CameraPreview.this.focus();
                }
            });
        }
    }

    public void onStop() {
        if (this.mSensorControler != null) {
            this.mSensorControler.onStop();
        }
    }

    public void addCallback() {
        if (this.mSurfaceHolder != null) {
            this.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this);
        }
    }
}

