/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.fragment.app.Fragment;
import com.bubing.camera.CameraLandscapeActivity;
import com.bubing.camera.CameraPortraitActivity;
import com.bubing.camera.DirectionMode;
import java.lang.ref.WeakReference;

public class CameraTools {
    private final WeakReference<Activity> mActivity;
    private final WeakReference<Fragment> mFragment;

    public static CameraTools create(Activity activity) {
        return new CameraTools(activity);
    }

    public static CameraTools create(Fragment fragment) {
        return new CameraTools(fragment);
    }

    private CameraTools(Activity activity) {
        this(activity, null);
    }

    private CameraTools(Fragment fragment) {
        this((Activity)fragment.getActivity(), fragment);
    }

    private CameraTools(Activity activity, Fragment fragment) {
        this.mActivity = new WeakReference<Activity>(activity);
        this.mFragment = new WeakReference<Fragment>(fragment);
    }

    public void openCertificateCamera(DirectionMode directionMode) {
        Activity activity = (Activity)this.mActivity.get();
        Fragment fragment = (Fragment)this.mFragment.get();
        Intent intent = null;
        intent = directionMode == DirectionMode.MODE_COMPANY_PORTRAIT ? new Intent((Context)activity, CameraPortraitActivity.class) : new Intent((Context)activity, CameraLandscapeActivity.class);
        if (intent != null) {
            intent.putExtra("take_type", directionMode.getValue());
            if (fragment != null) {
                fragment.startActivityForResult(intent, directionMode.getValue());
            } else {
                activity.startActivityForResult(intent, directionMode.getValue());
            }
        }
    }

    public static String getImagePath(Intent data) {
        if (data != null) {
            return data.getStringExtra("image_path");
        }
        return "";
    }
}

