/*
 * Decompiled with CFR 0.152.
 */
package com.gemalto.wsq;

import android.graphics.Bitmap;
import android.util.Log;
import com.gemalto.wsq.Native;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class WSQEncoder {
    private static final String TAG = "WSQEncoder";
    private static final int MAX_COMMENT_LENGTH = 65533;
    public static final int UNKNOWN_PPI = -1;
    public static final float BITRATE_5_TO_1 = 2.25f;
    public static final float BITRATE_15_TO_1 = 0.75f;
    private Bitmap bmp;
    private float bitrate = 2.25f;
    private int ppi = -1;
    private String comment = null;

    public WSQEncoder(Bitmap bmp) {
        if (bmp == null) {
            throw new IllegalArgumentException("Bitmap must not be null!");
        }
        this.bmp = bmp;
    }

    public WSQEncoder setBitrate(float bitrate) {
        if (bitrate <= 0.0f) {
            throw new IllegalArgumentException("Bitrate must be a positive number");
        }
        this.bitrate = bitrate;
        return this;
    }

    public WSQEncoder setPpi(int ppi) {
        if (ppi < -1) {
            throw new IllegalArgumentException("PPI must be positive or -1");
        }
        this.ppi = ppi;
        return this;
    }

    public WSQEncoder setComment(String comment) {
        if (comment != null && comment.getBytes().length > 65533) {
            throw new IllegalArgumentException("Maximum comment length is 65533 bytes");
        }
        this.comment = comment;
        return this;
    }

    public byte[] encode() {
        return this.encodeInternal();
    }

    public int encode(OutputStream out) throws IOException {
        byte[] data = this.encodeInternal();
        if (data == null) {
            return 0;
        }
        out.write(data);
        return data.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean encode(String fileName) {
        byte[] data = this.encodeInternal();
        if (data == null || data.length == 0) {
            return false;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(fileName);
            out.write(data);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Error writing WSQ into " + fileName), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private byte[] encodeInternal() {
        if (this.bmp == null) {
            return null;
        }
        int[] pixels = new int[this.bmp.getWidth() * this.bmp.getHeight()];
        this.bmp.getPixels(pixels, 0, this.bmp.getWidth(), 0, 0, this.bmp.getWidth(), this.bmp.getHeight());
        return Native.encodeWSQByteArray(pixels, this.bmp.getWidth(), this.bmp.getHeight(), this.bitrate, this.ppi, this.comment);
    }
}

