/*
 * Decompiled with CFR 0.152.
 */
package com.gemalto.wsq;

import android.graphics.Bitmap;
import com.gemalto.wsq.Native;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class WSQDecoder {
    public static WSQDecodedImage decode(String filename) {
        int[] res = Native.decodeWSQFile(filename);
        return WSQDecoder.nativeToImageData(res);
    }

    public static WSQDecodedImage decode(byte[] data) {
        int[] res = Native.decodeWSQByteArray(data);
        return WSQDecoder.nativeToImageData(res);
    }

    public static WSQDecodedImage decode(InputStream in) {
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream(in.available());
            byte[] buffer = new byte[16384];
            int bytesRead = in.read(buffer);
            while (bytesRead >= 0) {
                out.write(buffer, 0, bytesRead);
                bytesRead = in.read(buffer);
            }
            return WSQDecoder.decode(out.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static WSQDecodedImage nativeToImageData(int[] data) {
        if (data == null || data.length < 3) {
            return null;
        }
        int width = data[0];
        int height = data[1];
        int ppi = data[2];
        Bitmap bmp = Bitmap.createBitmap((int[])data, (int)3, (int)width, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bmp.setHasAlpha(false);
        return new WSQDecodedImage(bmp, ppi);
    }

    public static class WSQDecodedImage {
        private Bitmap bitmap;
        private int ppi;

        private WSQDecodedImage(Bitmap bitmap, int ppi) {
            this.bitmap = bitmap;
            this.ppi = ppi;
        }

        public Bitmap getBitmap() {
            return this.bitmap;
        }

        public int getPpi() {
            return this.ppi;
        }
    }
}

