/*
 * Decompiled with CFR 0.152.
 */
package com.gemalto.wsq;

import android.graphics.Bitmap;
import com.gemalto.wsq.Native;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class WSQDecoder {
    public static Bitmap decode(String filename) {
        int[] res = Native.decodeWSQFile(filename);
        return WSQDecoder.nativeToBitmap(res);
    }

    public static Bitmap decode(byte[] data) {
        int[] res = Native.decodeWSQByteArray(data);
        return WSQDecoder.nativeToBitmap(res);
    }

    public static Bitmap decode(InputStream in) {
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream(in.available());
            byte[] buffer = new byte[16384];
            int bytesRead = in.read(buffer);
            while (bytesRead >= 0) {
                out.write(buffer, 0, bytesRead);
                bytesRead = in.read(buffer);
            }
            return WSQDecoder.decode(out.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Bitmap nativeToBitmap(int[] data) {
        if (data == null || data.length < 2) {
            return null;
        }
        int width = data[0];
        int height = data[1];
        Bitmap bmp = Bitmap.createBitmap((int[])data, (int)2, (int)width, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bmp.setHasAlpha(false);
        return bmp;
    }
}

