/*
 * Decompiled with CFR 0.152.
 */
package com.geely.gbop.eventapi;

import com.geely.gbop.api.GbopApiException;
import com.geely.gbop.api.contant.HttpContentType;
import com.geely.gbop.api.util.GbopHttpBuild;
import com.geely.gbop.api.util.JsonUtils;
import com.geely.gbop.eventapi.EventProtocolType;
import com.geely.gbop.eventapi.GbopEventApp;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.provider.EventFormatProvider;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.UUID;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class GbopEventHttpBuild {
    public static Request buildRequest(CloudEvent cloudEvent, GbopEventApp app) {
        Headers headers = GbopEventHttpBuild.buildHeader(cloudEvent, app);
        Request.Builder builder = new Request.Builder();
        String url = GbopEventHttpBuild.buildUrl(app.getServerHost());
        RequestBody body = GbopEventHttpBuild.buildBody(cloudEvent);
        Request request = builder.url(url).headers(headers).post(body).build();
        return request;
    }

    private static String buildUrl(String serverHost) {
        return serverHost + "/eventmesh/publish";
    }

    private static RequestBody buildBody(CloudEvent cloudEvent) {
        EventFormat eventFormat = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json");
        EventFormatProvider.getInstance().registerFormat(eventFormat);
        return RequestBody.create((String)new String(eventFormat.serialize(cloudEvent), StandardCharsets.UTF_8), (MediaType)MediaType.parse((String)HttpContentType.JSON.getValue()));
    }

    public static Headers buildHeader(CloudEvent cloudEvent, GbopEventApp app) {
        Headers.Builder mHeaderBuild = new Headers.Builder();
        mHeaderBuild.add("producergroup", app.getProducerGroup());
        mHeaderBuild.add("token", app.getToken());
        mHeaderBuild.add("language", "java");
        mHeaderBuild.add("sdk-version", GbopHttpBuild.GBOP_SDK_VERSION);
        mHeaderBuild.add("protocoltype", EventProtocolType.CLOUDEVENTS.getValue());
        mHeaderBuild.add("Content-Type", HttpContentType.JSON.getValue());
        return mHeaderBuild.build();
    }

    @Deprecated
    public static CloudEvent buildCloudEvent(GbopEventApp app, String eventTopic, Object eventContent) {
        if (eventTopic == null || eventContent == null) {
            throw new GbopApiException(" gbop event request param is illegal");
        }
        io.cloudevents.core.v1.CloudEventBuilder cloudEventBuilder = (io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(UUID.randomUUID().toString()).withTime(OffsetDateTime.now()).withSubject(eventTopic).withType("business:ObjectCreated:PostObject").withSource(URI.create("gbop.business")).withExtension("language", "JAVA");
        if (eventContent instanceof byte[]) {
            cloudEventBuilder.withData((byte[])eventContent);
            cloudEventBuilder.withDataContentType("application/octet-stream");
        } else {
            cloudEventBuilder.withData(JsonUtils.writeValueAsString(eventContent).getBytes(StandardCharsets.UTF_8));
        }
        return cloudEventBuilder.build();
    }

    public static CloudEvent buildCloudEvent(String eventTopic, Object eventContent) {
        if (eventTopic == null || eventContent == null) {
            throw new GbopApiException(" gbop event request param is illegal");
        }
        io.cloudevents.core.v1.CloudEventBuilder cloudEventBuilder = (io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(UUID.randomUUID().toString()).withTime(OffsetDateTime.now()).withSubject(eventTopic).withType("business:ObjectCreated:PostObject").withSource(URI.create("gbop.business")).withExtension("language", "JAVA");
        if (eventContent instanceof byte[]) {
            cloudEventBuilder.withData((byte[])eventContent);
            cloudEventBuilder.withDataContentType("application/octet-stream");
        } else {
            cloudEventBuilder.withData(JsonUtils.writeValueAsString(eventContent).getBytes(StandardCharsets.UTF_8));
        }
        return cloudEventBuilder.build();
    }

    public static CloudEvent configCloudEvent(CloudEvent cloudEvent, String type, String source) {
        if (cloudEvent == null) {
            throw new GbopApiException(" gbop event request param is illegal");
        }
        CloudEventBuilder cloudEventBuilder = CloudEventBuilder.from((CloudEvent)cloudEvent);
        if (type != null && !type.trim().equals("")) {
            cloudEventBuilder.withType(type);
        } else if (source != null && !source.trim().equals("")) {
            cloudEventBuilder.withSource(URI.create(source));
        }
        return cloudEventBuilder.build();
    }
}

