/*
 * Decompiled with CFR 0.152.
 */
package com.geely.gbop.eventapi;

import com.geely.gbop.api.GbopApiResponse;
import com.geely.gbop.api.util.GbopHttpsUtil;
import com.geely.gbop.api.util.JsonUtils;
import com.geely.gbop.eventapi.EventResRetCode;
import com.geely.gbop.eventapi.EventRuntimeResponse;
import com.geely.gbop.eventapi.GbopEventApp;
import com.geely.gbop.eventapi.GbopEventHttpBuild;
import io.cloudevents.CloudEvent;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class GbopEventClient {
    private GbopEventApp eventApp;
    private OkHttpClient httpClient;

    public GbopEventClient(GbopEventApp eventApp) {
        this.eventApp = eventApp;
        this.initHttpClient();
    }

    public GbopEventClient(GbopEventApp eventApp, OkHttpClient httpClient) {
        this.eventApp = eventApp;
        this.httpClient = httpClient;
    }

    private void initHttpClient() {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        okHttpClientBuilder.connectTimeout(10L, TimeUnit.SECONDS);
        okHttpClientBuilder.readTimeout(300L, TimeUnit.SECONDS);
        okHttpClientBuilder.writeTimeout(300L, TimeUnit.SECONDS);
        okHttpClientBuilder.followRedirects(true);
        okHttpClientBuilder.retryOnConnectionFailure(true);
        okHttpClientBuilder.hostnameVerifier(GbopHttpsUtil.getHostnameVerifier());
        okHttpClientBuilder.sslSocketFactory(GbopHttpsUtil.getSSLSocketFactory(), GbopHttpsUtil.getX509TrustManager());
        this.httpClient = okHttpClientBuilder.build();
    }

    public GbopApiResponse publish(CloudEvent cloudEvent) {
        Request request = GbopEventHttpBuild.buildRequest(cloudEvent, this.eventApp);
        try (Response response = null;){
            response = this.httpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                EventRuntimeResponse proxyResponse = JsonUtils.readValue(response.body().string(), EventRuntimeResponse.class);
                if (EventResRetCode.SUCCESS.getRetCode().equals(proxyResponse.getRetCode())) {
                    GbopApiResponse gbopApiResponse = new GbopApiResponse(response.code(), proxyResponse.getRetMsg());
                    return gbopApiResponse;
                }
                GbopApiResponse gbopApiResponse = new GbopApiResponse(GbopEventClient.handleRetCode(proxyResponse.getRetCode()), null, " err:" + proxyResponse.getRetMsg());
                return gbopApiResponse;
            }
            GbopApiResponse proxyResponse = new GbopApiResponse(response.code(), response.body() == null ? null : response.body().string(), response.message());
            return proxyResponse;
        }
    }

    public static int handleRetCode(int retCode) {
        if (EventResRetCode.OVERLOAD.getRetCode().equals(retCode) || EventResRetCode.SEND_SYNC_MSG_ERR.getRetCode().equals(retCode) || EventResRetCode.WAITING_RR_MSG_ERR.getRetCode().equals(retCode) || EventResRetCode.STOP.getRetCode().equals(retCode) || EventResRetCode.REJECT_BY_PROCESSOR_ERROR.getRetCode().equals(retCode) || EventResRetCode.BATCH_PRODUCER_STOPED_ERR.getRetCode().equals(retCode) || EventResRetCode.PACKAGE_MSG_ERR.getRetCode().equals(retCode) || EventResRetCode.GROUP_PRODUCER_STOPED_ERR.getRetCode().equals(retCode) || EventResRetCode.SEND_ASYNC_MSG_ERR.getRetCode().equals(retCode) || EventResRetCode.REPLY_MSG_ERR.getRetCode().equals(retCode) || EventResRetCode.SEND_BATCHLOG_MSG_ERR.getRetCode().equals(retCode) || EventResRetCode.RUNTIME_ERR.getRetCode().equals(retCode) || EventResRetCode.PUBLISH_ERR.getRetCode().equals(retCode) || EventResRetCode.NO_NODE_USED.getRetCode().equals(retCode) || EventResRetCode.GROUP_LACK.getRetCode().equals(retCode)) {
            return 500;
        }
        if (EventResRetCode.REQUESTCODE_INVALID.getRetCode().equals(retCode) || EventResRetCode.PROTOCOL_HEADER_ERR.getRetCode().equals(retCode) || EventResRetCode.PROTOCOL_BODY_ERR.getRetCode().equals(retCode) || EventResRetCode.PROTOCOL_BODY_SIZE_ERR.getRetCode().equals(retCode) || EventResRetCode.URL_INVALID.getRetCode().equals(retCode)) {
            return 400;
        }
        if (EventResRetCode.ACL_ERR.getRetCode().equals(retCode)) {
            return 401;
        }
        if (EventResRetCode.BATCH_SPEED_OVER_LIMIT_ERR.getRetCode().equals(retCode) || EventResRetCode.HTTP_MES_SEND_OVER_LIMIT_ERR.getRetCode().equals(retCode)) {
            return 429;
        }
        return 503;
    }
}

