/*
 * Decompiled with CFR 0.152.
 */
package com.geely.gbop.api.sign;

import com.geely.gbop.api.GbopApiApp;
import com.geely.gbop.api.GbopApiException;
import com.geely.gbop.api.GbopApiRequest;
import com.geely.gbop.api.contant.HttpMethod;
import com.geely.gbop.api.sign.ISigner;
import com.geely.gbop.api.sign.SignMehod;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class HmacAuthSha256Sign
implements ISigner {
    public static final String METHOD = SignMehod.HmacSha256.getMethod();

    @Override
    public Object sign(GbopApiApp app, String host, HttpMethod method, GbopApiRequest apiRequest) {
        StringBuilder sb = new StringBuilder("X-Gapi-Ca-Timestamp");
        for (String customHeader : apiRequest.getCustomSignHeaders()) {
            if (!apiRequest.getHeaders().containsKey(customHeader)) {
                throw new GbopApiException("\u81ea\u5b9a\u4e49\u7684\u7b7e\u540dheader\u4e0d\u5b58\u5728\uff1aheader=" + customHeader);
            }
            sb.append(";").append(customHeader);
        }
        Date date = new Date();
        apiRequest.getHeaders().put("X-Gapi-Ca-Timestamp", String.valueOf(date.getTime()));
        apiRequest.getHeaders().put("X-Gapi-Ca-Algorithm", SignMehod.HmacSha256.getValue());
        apiRequest.getHeaders().put("X-Gapi-Ca-Access-Key", app.getAppKey());
        apiRequest.getHeaders().put("X-Gapi-Ca-Signed-Headers", sb.toString());
        apiRequest.getHeaders().put("Date", HmacAuthSha256Sign.formatDate(date));
        String serverHost = host.toLowerCase().replaceFirst("(http|https)://", "");
        apiRequest.getHeaders().put("Host", serverHost);
        if (apiRequest.getBeta().booleanValue()) {
            apiRequest.getHeaders().put("X-Gapi-Route-Flag", "beta");
        }
        apiRequest.getHeaders().put("X-Gapi-Ca-Signature", HmacAuthSha256Sign.toSign(app.getAppSecret(), method.getValue(), apiRequest.getPath(), apiRequest.getHeaders(), apiRequest.getParams()));
        return apiRequest.getHeaders();
    }

    private static String formatDate(Date date) {
        SimpleDateFormat greenwichDate = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        greenwichDate.setTimeZone(TimeZone.getTimeZone("GMT"));
        return greenwichDate.format(date);
    }

    public static String toSign(String secret, String method, String path, Map<String, String> headers, Map<String, Object> querys) {
        try {
            Mac hmacSha256 = Mac.getInstance(SignMehod.HmacSha256.getMethod());
            byte[] keyBytes = secret.getBytes("utf-8");
            hmacSha256.init(new SecretKeySpec(keyBytes, 0, keyBytes.length, SignMehod.HmacSha256.getMethod()));
            return new String(Base64.encodeBase64((byte[])hmacSha256.doFinal(HmacAuthSha256Sign.buildStringToSign(method, path, headers, querys).getBytes("utf-8"))), "utf-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String buildStringToSign(String method, String path, Map<String, String> headers, Map<String, Object> querys) throws Exception {
        String[] header;
        StringBuilder sb = new StringBuilder();
        sb.append(method.toUpperCase()).append("\n").append(path).append("\n").append(HmacAuthSha256Sign.queryStringSign(querys)).append("\n").append(headers.get("X-Gapi-Ca-Access-Key")).append("\n").append(headers.get("Date")).append("\n");
        String custHeaders = headers.get("X-Gapi-Ca-Signed-Headers");
        for (String item : header = custHeaders.split(";")) {
            sb.append(item).append(":");
            if (null != headers.get(item)) {
                sb.append(headers.get(item));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String queryStringSign(Map<String, Object> querys) throws Exception {
        StringBuilder sb = new StringBuilder();
        TreeMap<String, Object> sortMap = new TreeMap<String, Object>();
        if (null != querys) {
            for (Map.Entry<String, Object> query : querys.entrySet()) {
                if (StringUtils.isBlank((CharSequence)query.getKey())) continue;
                sortMap.put(query.getKey(), query.getValue());
            }
        }
        StringBuilder sbParam = new StringBuilder();
        for (Map.Entry item : sortMap.entrySet()) {
            if (StringUtils.isBlank((CharSequence)((CharSequence)item.getKey()))) continue;
            if (0 < sbParam.length()) {
                sbParam.append("&");
            }
            if (item.getValue() == null) {
                sbParam.append((String)item.getKey()).append("=");
                continue;
            }
            if (item.getValue() instanceof List) {
                List valueStrs = ((List)item.getValue()).stream().map(e -> e.toString()).collect(Collectors.toList());
                Collections.sort(valueStrs);
                for (int i = 0; i < valueStrs.size(); ++i) {
                    sbParam.append((String)item.getKey()).append("=");
                    sbParam.append((String)valueStrs.get(i));
                    if (i >= valueStrs.size() - 1) continue;
                    sbParam.append("&");
                }
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)item.getValue().toString())) {
                sbParam.append((String)item.getKey()).append("=");
                sbParam.append(item.getValue().toString());
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)item.getValue().toString())) continue;
            sbParam.append((String)item.getKey()).append("=");
        }
        if (0 < sbParam.length()) {
            sb.append((CharSequence)sbParam);
        }
        return sb.toString();
    }
}

