/*
 * Decompiled with CFR 0.152.
 */
package com.geejoe.edgeslidingback;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.Scroller;
import com.geejoe.edgeslidingback.EdgeSlidingBackActivity;
import com.geejoe.edgeslidingback.EdgeSlidingBackFragment;
import com.geejoe.edgeslidingback.R;

public class EdgeSlidingBackLayout
extends FrameLayout {
    private EdgeSlidingBackActivity mActivity;
    private EdgeSlidingBackFragment mFragment;
    private Scroller mScroller;
    private int mScreenWidth;
    private int mTouchAreaWidth;
    private int mTouchSlope;
    private int mLastX;
    private int mLastY;
    private int mActionDownX;
    private Drawable mShadow;
    private int mShadowWidth;

    public EdgeSlidingBackLayout(Context context) {
        this(context, null, 0);
    }

    public EdgeSlidingBackLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EdgeSlidingBackLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mScroller = new Scroller(context);
        this.mScreenWidth = context.getResources().getDisplayMetrics().widthPixels;
        this.mTouchAreaWidth = this.mScreenWidth / 12;
        this.mTouchSlope = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mShadow = context.getResources().getDrawable(R.drawable.left_shadow);
        this.mShadowWidth = (int)context.getResources().getDisplayMetrics().density * 16;
    }

    public void bindActivity(EdgeSlidingBackActivity activity) {
        this.mActivity = activity;
        ViewGroup decorView = (ViewGroup)this.mActivity.getWindow().getDecorView();
        View rootView = decorView.getChildAt(0);
        decorView.removeView(rootView);
        this.addView(rootView);
        decorView.addView((View)this);
    }

    public void bindFrgment(EdgeSlidingBackFragment fragment) {
        this.mFragment = fragment;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean intercept = false;
        int x = (int)ev.getX();
        int y = (int)ev.getY();
        switch (ev.getAction()) {
            case 0: {
                this.mActionDownX = (int)ev.getX();
                this.mLastX = x;
                this.mLastY = x;
                break;
            }
            case 2: {
                int deltaX = x - this.mLastX;
                int deltaY = y - this.mLastY;
                if (this.mActionDownX >= this.mTouchAreaWidth || deltaX <= this.mTouchSlope || Math.abs(deltaX) <= Math.abs(deltaY)) break;
                intercept = true;
                break;
            }
            case 1: {
                intercept = false;
            }
        }
        return intercept;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        switch (event.getAction()) {
            case 0: {
                this.mLastX = x;
                this.mLastY = y;
                break;
            }
            case 2: {
                int deltaX = x - this.mLastX;
                int deltaY = y - this.mLastY;
                if (this.mActionDownX < this.mTouchAreaWidth && Math.abs(deltaX) > Math.abs(deltaY)) {
                    int moveX = -deltaX;
                    if (-this.getScrollX() < 0) {
                        this.scrollTo(0, 0);
                    } else {
                        this.scrollBy(moveX, 0);
                    }
                }
                this.mLastX = x;
                this.mLastY = y;
                break;
            }
            case 1: {
                if (-this.getScrollX() < this.mScreenWidth / 3) {
                    this.scrollResume();
                    break;
                }
                this.scrollRightOut();
            }
        }
        return true;
    }

    private void scrollResume() {
        int startX = this.getScrollX();
        int distance = -this.getScrollX();
        this.mScroller.startScroll(startX, 0, distance, 0, 300);
        this.invalidate();
    }

    private void scrollRightOut() {
        int startX = this.getScrollX();
        int distance = -this.mScreenWidth - startX;
        this.mScroller.startScroll(startX, 0, distance, 0, 300);
        this.invalidate();
        this.mActivity.finish();
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            this.scrollTo(this.mScroller.getCurrX(), 0);
            this.postInvalidate();
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.drawShadow(canvas);
    }

    private void drawShadow(Canvas canvas) {
        this.mShadow.setBounds(0, 0, this.mShadowWidth, this.getHeight());
        canvas.save();
        canvas.translate((float)(-this.mShadowWidth), 0.0f);
        this.mShadow.draw(canvas);
        canvas.restore();
    }
}

