/*
 * Decompiled with CFR 0.152.
 */
package com.ge.research.semtk.services.results.cleanUp;

import com.ge.research.semtk.auth.AuthorizationManager;
import com.ge.research.semtk.edc.JobTracker;
import com.ge.research.semtk.edc.resultsStorage.TableResultsStorage;
import com.ge.research.semtk.springutillib.properties.ServicesGraphProperties;
import com.ge.research.semtk.utility.LocalLogger;
import java.io.File;
import java.util.Calendar;
import java.util.Date;

public class DeleteThread
extends Thread {
    private int runFrequencyInMilliseconds;
    private int frequencyInMinutes;
    private File locationToDeleteFrom;
    private JobTracker jTracker;
    private TableResultsStorage trstore;

    public DeleteThread(String fileStorageLocation, int frequencyInMinutes, ServicesGraphProperties edcProp) {
        this.locationToDeleteFrom = new File(fileStorageLocation);
        this.runFrequencyInMilliseconds = frequencyInMinutes * 60 * 1000;
        this.frequencyInMinutes = frequencyInMinutes;
        this.trstore = new TableResultsStorage(fileStorageLocation);
        try {
            this.jTracker = new JobTracker(edcProp.buildSei());
        }
        catch (Exception e) {
            LocalLogger.logToStdErr((String)("unable to get a job tracker instance. reason given: " + e.getMessage()));
            LocalLogger.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LocalLogger.logToStdErr((String)"Clean up initialized...");
        while (true) {
            try {
                Calendar cal = Calendar.getInstance();
                cal.add(14, -1 * this.runFrequencyInMilliseconds);
                Date cutoff = cal.getTime();
                long cutoffMsec = cutoff.getTime();
                LocalLogger.logToStdErr((String)"Clean up started...");
                try {
                    AuthorizationManager.setSemtkSuper();
                    this.jTracker.deleteJobsAndFiles(cutoff, this.trstore);
                }
                finally {
                    AuthorizationManager.clearSemtkSuper();
                }
                for (File f : this.locationToDeleteFrom.listFiles()) {
                    if (!f.exists() || f.lastModified() >= cutoffMsec) continue;
                    try {
                        f.delete();
                        LocalLogger.logToStdOut((String)("Deleted leftover: " + f.getAbsolutePath()));
                    }
                    catch (Exception e1) {
                        LocalLogger.printStackTrace((Throwable)e1);
                    }
                }
            }
            catch (Exception iei) {
                LocalLogger.printStackTrace((Throwable)iei);
            }
            try {
                LocalLogger.logToStdErr((String)("Clean up about to sleep for " + (double)this.runFrequencyInMilliseconds / 60000.0 + " minutes. "));
                Thread.sleep(this.runFrequencyInMilliseconds);
                continue;
            }
            catch (InterruptedException e) {
                LocalLogger.logToStdErr((String)"Sleep failed");
                continue;
            }
            break;
        }
    }
}

