/*
 * Decompiled with CFR 0.152.
 */
package com.ge.research.semtk.services.results;

import com.ge.research.semtk.services.results.cleanUp.DeleteThread;
import com.ge.research.semtk.springutillib.properties.ServicesGraphProperties;
import com.ge.research.semtk.utility.LocalLogger;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ResultsServiceStartup
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Integer DEFAULT_CLEANUP_FREQUENCY = 120;
    @Autowired
    ServicesGraphProperties servicesgraph_prop;

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.initializeResultsLocation(event);
        this.cleanUpFileLocation(event);
    }

    private void initializeResultsLocation(ApplicationReadyEvent event) {
        String resultsTempStoreLocation = event.getApplicationContext().getEnvironment().getProperty("results.fileLocation");
        LocalLogger.logToStdErr((String)"attempting to create results location");
        File dirToCreate = new File(resultsTempStoreLocation);
        if (dirToCreate.mkdirs()) {
            LocalLogger.logToStdErr((String)("requested temp storage directory (" + resultsTempStoreLocation + ") successfully created."));
        } else if (dirToCreate.isDirectory()) {
            LocalLogger.logToStdOut((String)("requested temp storage directory (" + resultsTempStoreLocation + ") already exists."));
        } else {
            LocalLogger.logToStdErr((String)("temp storage directory (" + resultsTempStoreLocation + ") could not be created. Exiting..."));
            System.exit(-1);
        }
    }

    private void cleanUpFileLocation(ApplicationReadyEvent event) {
        LocalLogger.logToStdErr((String)"set up for cleanup job");
        String runCleanUp = null;
        try {
            runCleanUp = event.getApplicationContext().getEnvironment().getProperty("results.cleanUpThreadEnabled");
        }
        catch (Exception eee) {
            LocalLogger.logToStdErr((String)"Unable to convert results.cleanUpThreadEnabled to a boolean value. no cleanup will be performed.");
            return;
        }
        Integer cleanUpFreq = null;
        if (runCleanUp.equalsIgnoreCase("yes")) {
            try {
                cleanUpFreq = Integer.parseInt(event.getApplicationContext().getEnvironment().getProperty("results.cleanUpThreadFrequency"));
                LocalLogger.logToStdErr((String)("Declared cleanup frequency is " + cleanUpFreq + " minutes."));
                if (cleanUpFreq == null) {
                    cleanUpFreq = DEFAULT_CLEANUP_FREQUENCY;
                    LocalLogger.logToStdErr((String)("Declared cleanup frequency is null. Overriding to " + cleanUpFreq + " minutes."));
                }
            }
            catch (Exception eee) {
                LocalLogger.logToStdErr((String)eee.getMessage());
                cleanUpFreq = DEFAULT_CLEANUP_FREQUENCY;
                LocalLogger.logToStdErr((String)("Declared cleanup frequency is null. Overriding to " + cleanUpFreq + " minutes."));
            }
        } else {
            LocalLogger.logToStdErr((String)"cleanup disabled. no cleanup will be performed.");
            return;
        }
        String fileStore = event.getApplicationContext().getEnvironment().getProperty("results.fileLocation");
        DeleteThread ripper = new DeleteThread(fileStore, cleanUpFreq.intValue(), this.servicesgraph_prop);
        ripper.start();
    }
}

