/*
 * Decompiled with CFR 0.152.
 */
package com.ge.research.semtk.services.results;

import com.ge.research.semtk.auth.AuthorizationException;
import com.ge.research.semtk.auth.AuthorizationManager;
import com.ge.research.semtk.auth.AuthorizationProperties;
import com.ge.research.semtk.auth.ThreadAuthenticator;
import com.ge.research.semtk.edc.JobFileInfo;
import com.ge.research.semtk.edc.JobTracker;
import com.ge.research.semtk.edc.resultsStorage.GenericJsonBlobResultsSerializer;
import com.ge.research.semtk.edc.resultsStorage.GenericJsonBlobResultsStorage;
import com.ge.research.semtk.edc.resultsStorage.JsonLdResultsSerializer;
import com.ge.research.semtk.edc.resultsStorage.JsonLdResultsStorage;
import com.ge.research.semtk.edc.resultsStorage.TableResultsSerializer;
import com.ge.research.semtk.edc.resultsStorage.TableResultsStorage;
import com.ge.research.semtk.logging.easyLogger.EasyLogEnabledConfigProperties;
import com.ge.research.semtk.logging.easyLogger.LoggerRestClient;
import com.ge.research.semtk.resultSet.ResultType;
import com.ge.research.semtk.resultSet.SimpleResultSet;
import com.ge.research.semtk.resultSet.Table;
import com.ge.research.semtk.resultSet.TableResultSet;
import com.ge.research.semtk.services.results.ResultsLoggingProperties;
import com.ge.research.semtk.services.results.ResultsProperties;
import com.ge.research.semtk.services.results.requests.JsonBlobRequestBody;
import com.ge.research.semtk.services.results.requests.JsonLdStoreRequestBody;
import com.ge.research.semtk.services.results.requests.ResultsRequestBodyCsvMaxRows;
import com.ge.research.semtk.services.results.requests.ResultsRequestBodyFileExtContents;
import com.ge.research.semtk.services.results.requests.ResultsRequestBodyFinalizeTableResultsJson;
import com.ge.research.semtk.services.results.requests.ResultsRequestBodyInitializeTableResultsJson;
import com.ge.research.semtk.services.results.requests.ResultsRequestBodyMaxRows;
import com.ge.research.semtk.services.results.requests.ResultsRequestBodyPath;
import com.ge.research.semtk.springutilib.requests.JobIdRequest;
import com.ge.research.semtk.springutillib.headers.HeadersManager;
import com.ge.research.semtk.springutillib.properties.AuthProperties;
import com.ge.research.semtk.springutillib.properties.EnvironmentProperties;
import com.ge.research.semtk.springutillib.properties.ServicesGraphProperties;
import com.ge.research.semtk.utility.LocalLogger;
import com.ge.research.semtk.utility.Utility;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@CrossOrigin
@RestController
@RequestMapping(value={"/results"})
@ComponentScan(basePackages={"com.ge.research.semtk.springutillib"})
public class ResultsServiceRestController {
    static final String SERVICE_NAME = "ResultsService";
    @Autowired
    ResultsProperties prop;
    @Autowired
    ServicesGraphProperties servicesgraph_prop;
    @Autowired
    ResultsLoggingProperties log_prop;
    @Autowired
    AuthProperties auth_prop;
    @Autowired
    private ApplicationContext appContext;

    @PostConstruct
    public void init() {
        EnvironmentProperties env_prop = new EnvironmentProperties(this.appContext, EnvironmentProperties.SEMTK_REQ_PROPS, EnvironmentProperties.SEMTK_OPT_PROPS);
        env_prop.validateWithExit();
        this.prop.validateWithExit();
        this.servicesgraph_prop.validateWithExit();
        this.log_prop.validateWithExit();
        this.auth_prop.validateWithExit();
        AuthorizationManager.authorizeWithExit((AuthorizationProperties)this.auth_prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CrossOrigin
    @RequestMapping(value={"/storeJsonLdResults"}, method={RequestMethod.POST})
    public JSONObject storeJsonLdResults(@RequestBody JsonLdStoreRequestBody requestBody, @RequestHeader HttpHeaders headers) {
        HeadersManager.setHeaders((HttpHeaders)headers);
        LoggerRestClient logger = LoggerRestClient.loggerConfigInitialization((EasyLogEnabledConfigProperties)this.log_prop, (String)ThreadAuthenticator.getThreadUserName());
        try {
            LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"storeJsonLdResults", (String)"jobId", (String)requestBody.jobId, (String)"chars", (String)String.valueOf(requestBody.getJsonRenderedGraph().length()));
            LocalLogger.logToStdOut((String)("Results Service storeJsonLdResults JobId=" + requestBody.jobId));
            SimpleResultSet res = new SimpleResultSet();
            try {
                URL url = this.getJsonLdResultsStorage().storeResults(requestBody.jobId, requestBody.getJsonRenderedHeader(), requestBody.getJsonRenderedGraph());
                this.getJobTracker().setJobResultsURL(requestBody.jobId, url);
                res.setSuccess(Boolean.valueOf(true));
            }
            catch (Exception e) {
                res.setSuccess(Boolean.valueOf(false));
                res.addRationaleMessage(SERVICE_NAME, "storeJsonLdResults", e);
                LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"storeJsonLdResults exception", (String)"message", (String)e.toString());
                LocalLogger.printStackTrace((Throwable)e);
            }
            JSONObject jSONObject = res.toJson();
            return jSONObject;
        }
        finally {
            HeadersManager.clearHeaders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CrossOrigin
    @RequestMapping(value={"/getJsonLdResults"}, method={RequestMethod.POST})
    public void getJsonLdResults(@RequestBody JobIdRequest requestBody, HttpServletResponse resp, @RequestHeader HttpHeaders headers) {
        HeadersManager.setHeaders((HttpHeaders)headers);
        LoggerRestClient logger = LoggerRestClient.loggerConfigInitialization((EasyLogEnabledConfigProperties)this.log_prop, (String)ThreadAuthenticator.getThreadUserName());
        resp.addHeader("content-type", "application/json; charset=utf-8");
        try {
            try {
                URL url = this.getJobTracker().getFullResultsURL(requestBody.jobId);
                JsonLdResultsSerializer retval = this.getJsonLdResultsStorage().getJsonLd(url);
                retval.writeToStream(resp.getWriter());
            }
            catch (Exception e) {
                LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"getJsonLdResults exception", (String)"message", (String)e.toString());
                LocalLogger.printStackTrace((Throwable)e);
            }
            LocalLogger.logToStdErr((String)"done writing output");
        }
        finally {
            HeadersManager.clearHeaders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CrossOrigin
    @RequestMapping(value={"/storeJsonBlobResults"}, method={RequestMethod.POST})
    public JSONObject storeJsonBlobResults(@RequestBody JsonBlobRequestBody requestBody, @RequestHeader HttpHeaders headers) {
        HeadersManager.setHeaders((HttpHeaders)headers);
        LoggerRestClient logger = LoggerRestClient.loggerConfigInitialization((EasyLogEnabledConfigProperties)this.log_prop, (String)ThreadAuthenticator.getThreadUserName());
        try {
            String blobStr = requestBody.getJsonBlobString();
            LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"storeJsonBlobResults", (String)"jobId", (String)requestBody.jobId, (String)"chars", (String)String.valueOf(blobStr.length()));
            LocalLogger.logToStdOut((String)("Results Service storeJsonBlobResults JobId=" + requestBody.jobId));
            SimpleResultSet res = new SimpleResultSet();
            try {
                URL url = this.getJsonBlobResultsStorage().storeResults(requestBody.jobId, blobStr);
                this.getJobTracker().setJobResultsURL(requestBody.jobId, url);
                res.setSuccess(Boolean.valueOf(true));
            }
            catch (Exception e) {
                res.setSuccess(Boolean.valueOf(false));
                res.addRationaleMessage(SERVICE_NAME, "storeJsonBlobResults", e);
                LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"storeJsonBlobResults exception", (String)"message", (String)e.toString());
                LocalLogger.printStackTrace((Throwable)e);
            }
            JSONObject jSONObject = res.toJson();
            return jSONObject;
        }
        finally {
            HeadersManager.clearHeaders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CrossOrigin
    @RequestMapping(value={"/getJsonBlobResults"}, method={RequestMethod.POST})
    public void getJsonBlobResults(@RequestBody JobIdRequest requestBody, HttpServletResponse resp, @RequestHeader HttpHeaders headers) {
        HeadersManager.setHeaders((HttpHeaders)headers);
        LoggerRestClient logger = LoggerRestClient.loggerConfigInitialization((EasyLogEnabledConfigProperties)this.log_prop, (String)ThreadAuthenticator.getThreadUserName());
        resp.addHeader("content-type", "application/json; charset=utf-8");
        try {
            try {
                URL url = this.getJobTracker().getFullResultsURL(requestBody.jobId);
                GenericJsonBlobResultsSerializer retval = this.getJsonBlobResultsStorage().getJsonBlob(url);
                retval.writeToStream(resp.getWriter());
            }
            catch (Exception e) {
                LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"getJsonBlobResults exception", (String)"message", (String)e.toString());
                LocalLogger.printStackTrace((Throwable)e);
            }
            LocalLogger.logToStdErr((String)"done writing output");
        }
        finally {
            HeadersManager.clearHeaders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Get fileIDs of all files in job", notes="binary files are returned in a table with columns 'name' and 'fileId'")
    @CrossOrigin
    @RequestMapping(value={"/getResultsFiles"}, method={RequestMethod.POST})
    public JSONObject getResultsFiles(@RequestBody JobIdRequest requestBody, @RequestHeader HttpHeaders headers) {
        HeadersManager.setHeaders((HttpHeaders)headers);
        LoggerRestClient logger = LoggerRestClient.loggerConfigInitialization((EasyLogEnabledConfigProperties)this.log_prop, (String)ThreadAuthenticator.getThreadUserName());
        try {
            String ENDPOINT_NAME = "getResultsFiles";
            String STRING_TYPE = "http://www.w3.org/2001/XMLSchema#string";
            TableResultSet res = null;
            try {
                JobTracker tracker = this.getJobTracker();
                ArrayList fileInfoList = tracker.getJobBinaryFiles(requestBody.jobId);
                Table table = new Table(new String[]{"name", "fileId"}, new String[]{"http://www.w3.org/2001/XMLSchema#string", ResultType.BINARY_FILE_ID.getPrefixedName()});
                for (JobFileInfo info : fileInfoList) {
                    table.addRow(new String[]{info.getFileName(), info.getFileId()});
                }
                res = new TableResultSet(Boolean.valueOf(true));
                res.addResults(table);
            }
            catch (Exception e) {
                LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"getResultsFiles exception", (String)"message", (String)e.toString());
                LocalLogger.printStackTrace((Throwable)e);
                res = new TableResultSet(Boolean.valueOf(false));
                res.addRationaleMessage(SERVICE_NAME, "getResultsFiles", e);
            }
            JSONObject jSONObject = res.toJson();
            return jSONObject;
        }
        finally {
            HeadersManager.clearHeaders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Store binary file to jobId", notes="Return has fileId <br>")
    @CrossOrigin
    @RequestMapping(value={"/storeBinaryFile"}, method={RequestMethod.POST})
    public JSONObject storeBinaryFile(@RequestParam(value="file") MultipartFile file, @RequestParam(value="jobId") String jobId, HttpServletRequest req, HttpServletResponse resp, @RequestHeader HttpHeaders headers) {
        HeadersManager.setHeaders((HttpHeaders)headers);
        LoggerRestClient logger = LoggerRestClient.loggerConfigInitialization((EasyLogEnabledConfigProperties)this.log_prop, (String)ThreadAuthenticator.getThreadUserName());
        try {
            SimpleResultSet res = null;
            LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"storeBinaryFile", (String)"jobId", (String)jobId, (String)"bytes", (String)String.valueOf(file.getSize()));
            try {
                if (file != null) {
                    String fileId = this.generateFileId();
                    String originalFileName = file.getOriginalFilename();
                    String storagePath = this.buildStoragePath(jobId, fileId);
                    LocalLogger.logToStdOut((String)("Saving original file: " + originalFileName + " to: " + storagePath));
                    File storageFile = new File(storagePath);
                    storageFile.getParentFile().mkdirs();
                    Files.copy(file.getInputStream(), storageFile.toPath(), new CopyOption[0]);
                    res = this.addBinaryFile(jobId, fileId, originalFileName, storagePath.toString());
                    LocalLogger.logToStdOut((String)"done uploading file");
                }
            }
            catch (Exception e) {
                res = new SimpleResultSet();
                res.setSuccess(Boolean.valueOf(false));
                res.addRationaleMessage(SERVICE_NAME, "storeBinaryFile", e);
                LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"storeBinaryFile exception", (String)"message", (String)e.toString());
                LocalLogger.printStackTrace((Throwable)e);
            }
            JSONObject jSONObject = res.toJson();
            return jSONObject;
        }
        finally {
            HeadersManager.clearHeaders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Associate a file with a jobId by path", notes="Return has fileId <br>The path must be accessible by results service.  <br>The file will be removed during results service cleanup.")
    @CrossOrigin
    @RequestMapping(value={"/storeBinaryFilePath"}, method={RequestMethod.POST})
    public JSONObject storeBinaryFilePath(@RequestBody ResultsRequestBodyPath requestBody, @RequestHeader HttpHeaders headers) {
        HeadersManager.setHeaders((HttpHeaders)headers);
        LoggerRestClient logger = LoggerRestClient.loggerConfigInitialization((EasyLogEnabledConfigProperties)this.log_prop, (String)ThreadAuthenticator.getThreadUserName());
        try {
            LocalLogger.logToStdOut((String)("storeBinaryFilePath as " + ThreadAuthenticator.getThreadUserName()));
            SimpleResultSet res = null;
            LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"storeBinaryFilePath", (String)"jobId", (String)requestBody.getJobId(), (String)"bytes", (String)String.valueOf(new File(requestBody.getPath()).length()));
            try {
                File f = new File(requestBody.getPath());
                if (!f.exists()) {
                    this.validatePath(requestBody.getPath());
                    throw new Exception("File is not readable from results service: " + requestBody.getPath());
                }
                String fileId = this.generateFileId();
                res = this.addBinaryFile(requestBody.getJobId(), fileId, requestBody.getFilename(), requestBody.getPath());
                LocalLogger.logToStdOut((String)"done uploading file");
            }
            catch (Exception e) {
                res = new SimpleResultSet();
                res.setSuccess(Boolean.valueOf(false));
                res.addRationaleMessage(SERVICE_NAME, "storeBinaryFilePath", e);
                LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"storeBinaryFilePath exception", (String)"message", (String)e.toString());
                LocalLogger.printStackTrace((Throwable)e);
            }
            JSONObject jSONObject = res.toJson();
            return jSONObject;
        }
        finally {
            HeadersManager.clearHeaders();
        }
    }

    private SimpleResultSet addBinaryFile(String jobId, String fileId, String originalFileName, String fullPath) throws Exception {
        this.validatePath(fullPath);
        this.getJobTracker().addBinaryFile(jobId, fileId, originalFileName, fullPath);
        SimpleResultSet res = new SimpleResultSet(Boolean.valueOf(true));
        res.addResult("fileId", fileId);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @ApiOperation(value="Get binary file", notes="On error, filename will be authorizationError.html or resultsExpired.html, with message inside.")
    @CrossOrigin
    @RequestMapping(value={"/getBinaryFile/{fileId}"}, method={RequestMethod.GET})
    @ResponseBody
    public FileSystemResource getBinaryFile(@PathVariable(value="fileId") String fileId, HttpServletResponse resp, @RequestHeader HttpHeaders headers) {
        HeadersManager.setHeaders((HttpHeaders)headers);
        LoggerRestClient logger = LoggerRestClient.loggerConfigInitialization((EasyLogEnabledConfigProperties)this.log_prop, (String)ThreadAuthenticator.getThreadUserName());
        try {
            LocalLogger.logToStdOut((String)("getBinaryFile as " + ThreadAuthenticator.getThreadUserName()));
            try {
                JobFileInfo metaFile = this.getJobTracker().getBinaryFile(fileId);
                String originalFileName = metaFile.getFileName();
                String dataFilePath = metaFile.getPath();
                if (ThreadAuthenticator.getThreadUserName().equals(metaFile.getUserName())) {
                    LocalLogger.logToStdOut((String)("getBinaryFile users match: " + metaFile.getUserName()));
                } else {
                    LocalLogger.logToStdOut((String)("getBinaryFile file username: " + metaFile.getUserName() + " DOES NOT MATCH CALLER: " + ThreadAuthenticator.getThreadUserName()));
                }
                File file = new File(dataFilePath);
                resp.setHeader("Content-Disposition", "attachment; filename=\"" + originalFileName + "\"");
                FileSystemResource fileSystemResource = new FileSystemResource(file);
                return fileSystemResource;
            }
            catch (Exception e) {
                LocalLogger.printStackTrace((Throwable)e);
                String filename = "";
                String message = "";
                if (e instanceof AuthorizationException) {
                    filename = "authorizationError.html";
                    message = "<html><body>AuthorizationException - " + e.getMessage() + "</body></html>\n";
                } else {
                    filename = "resultExpired.html";
                    message = "<html><body>Exception - Result was not found. It is incorrect or it has expired.<br><br>\nmessage: " + e.getMessage() + "</body></html>\n";
                }
                resp.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
                File f = File.createTempFile("error", ".html");
                f.deleteOnExit();
                BufferedWriter bw = new BufferedWriter(new FileWriter(f));
                bw.write(message);
                bw.close();
                FileSystemResource fileSystemResource = new FileSystemResource(f);
                HeadersManager.clearHeaders();
                return fileSystemResource;
                {
                    catch (Exception e1) {
                        LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"getBinaryFile exception", (String)"message", (String)e.toString());
                        LocalLogger.printStackTrace((Throwable)e1);
                        FileSystemResource fileSystemResource2 = null;
                        HeadersManager.clearHeaders();
                        return fileSystemResource2;
                    }
                }
            }
        }
        finally {
            HeadersManager.clearHeaders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="initialize json table storage", notes="Use this before storeTableResultsJsonAddIncremental")
    @CrossOrigin
    @RequestMapping(value={"/storeTableResultsJsonInitialize"}, method={RequestMethod.POST})
    public JSONObject storeTableResultsJsonInitialize(@RequestBody ResultsRequestBodyInitializeTableResultsJson requestBody, @RequestHeader HttpHeaders headers) {
        HeadersManager.setHeaders((HttpHeaders)headers);
        LoggerRestClient logger = LoggerRestClient.loggerConfigInitialization((EasyLogEnabledConfigProperties)this.log_prop, (String)ThreadAuthenticator.getThreadUserName());
        try {
            LocalLogger.logToStdOut((String)("Results Service storeTableResultsJsonInitialize JobId=" + requestBody.jobId));
            SimpleResultSet res = new SimpleResultSet();
            try {
                this.getTableResultsStorage().storeTableResultsJsonInitialize(requestBody.jobId, requestBody.getJsonRenderedHeader());
                res.setSuccess(Boolean.valueOf(true));
            }
            catch (Exception e) {
                res.setSuccess(Boolean.valueOf(false));
                res.addRationaleMessage(SERVICE_NAME, "storeTableResultsJsonInitialize", e);
                LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"storeTableResultsJsonInitialize exception", (String)"message", (String)e.toString());
                LocalLogger.printStackTrace((Throwable)e);
            }
            JSONObject jSONObject = res.toJson();
            return jSONObject;
        }
        finally {
            HeadersManager.clearHeaders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="store chunk of json table storage", notes="Use this after storeTableResultsJsonInitialize<br>Call storeTableResultsJsonFinalize when done. ")
    @CrossOrigin
    @RequestMapping(value={"/storeTableResultsJsonAddIncremental"}, method={RequestMethod.POST})
    public JSONObject storeTableResultsJsonAddIncremental(@RequestBody ResultsRequestBodyFileExtContents requestBody, @RequestHeader HttpHeaders headers) {
        HeadersManager.setHeaders((HttpHeaders)headers);
        SimpleResultSet res = new SimpleResultSet();
        LoggerRestClient logger = LoggerRestClient.loggerConfigInitialization((EasyLogEnabledConfigProperties)this.log_prop, (String)ThreadAuthenticator.getThreadUserName());
        try {
            String decompressed = Utility.decompress((String)requestBody.getContents());
            LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"storeTableResultsJsonAddIncremental", (String)"jobId", (String)requestBody.jobId, (String)"chars", (String)String.valueOf(decompressed.length()));
            LocalLogger.logToStdOut((String)("Results Service storeTableResultsJsonAddIncremental JobId=" + requestBody.jobId));
            this.getTableResultsStorage().storeTableResultsJsonAddIncremental(requestBody.jobId, decompressed);
            res.setSuccess(Boolean.valueOf(true));
        }
        catch (Exception e) {
            res.setSuccess(Boolean.valueOf(false));
            res.addRationaleMessage(SERVICE_NAME, "storeTableResultsJsonAddIncremental", e);
            LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"storeTableResultsJsonAddIncremental exception", (String)"message", (String)e.toString());
            LocalLogger.printStackTrace((Throwable)e);
        }
        finally {
            HeadersManager.clearHeaders();
        }
        return res.toJson();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="finish json table storage", notes="Use this after storeTableResultsJsonAddIncremental<br>")
    @CrossOrigin
    @RequestMapping(value={"/storeTableResultsJsonFinalize"}, method={RequestMethod.POST})
    public JSONObject storeTableResultsJsonFinalize(@RequestBody ResultsRequestBodyFinalizeTableResultsJson requestBody, @RequestHeader HttpHeaders headers) {
        HeadersManager.setHeaders((HttpHeaders)headers);
        LoggerRestClient logger = LoggerRestClient.loggerConfigInitialization((EasyLogEnabledConfigProperties)this.log_prop, (String)ThreadAuthenticator.getThreadUserName());
        try {
            LocalLogger.logToStdOut((String)("Results Service storeTableResultsJsonFinalize JobId=" + requestBody.jobId));
            SimpleResultSet res = new SimpleResultSet();
            try {
                URL url = this.getTableResultsStorage().storeTableResultsJsonFinalize(requestBody.jobId);
                this.getJobTracker().setJobResultsURL(requestBody.jobId, url);
                res.setSuccess(Boolean.valueOf(true));
            }
            catch (Exception e) {
                res.setSuccess(Boolean.valueOf(false));
                res.addRationaleMessage(SERVICE_NAME, "storeTableResultsJsonFinalize", e);
                LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"storeTableResultsJsonFinalize exception", (String)"message", (String)e.toString());
                LocalLogger.printStackTrace((Throwable)e);
            }
            finally {
                HeadersManager.setHeaders((HttpHeaders)new HttpHeaders());
            }
            JSONObject jSONObject = res.toJson();
            return jSONObject;
        }
        finally {
            HeadersManager.clearHeaders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Get CSV table", notes="Too large a file can fail.  <br>This is good for a preview, for example, in a browser with limited memory.<br>GET /getTableResultsCsvForWebClient safely retrieves entire large files.")
    @CrossOrigin
    @RequestMapping(value={"/getTableResultsCsv"}, method={RequestMethod.POST})
    public void getTableResultsCsv(@RequestBody ResultsRequestBodyCsvMaxRows requestBody, HttpServletResponse resp, @RequestHeader HttpHeaders headers) {
        HeadersManager.setHeaders((HttpHeaders)headers);
        LoggerRestClient logger = LoggerRestClient.loggerConfigInitialization((EasyLogEnabledConfigProperties)this.log_prop, (String)ThreadAuthenticator.getThreadUserName());
        resp.addHeader("content-type", "text/plain; charset=utf-8");
        try {
            try {
                resp.setHeader("Content-Disposition", "attachment; filename=\"" + requestBody.jobId + ".csv\"; filename*=\"" + requestBody.jobId + ".csv\"");
                URL url = this.getJobTracker().getFullResultsURL(requestBody.jobId);
                TableResultsSerializer retval = this.getTableResultsStorage().getCsvTable(url, requestBody.maxRows, requestBody.getStartRow());
                if (requestBody.getAppendDownloadHeaders()) {
                    retval.writeToStream(resp.getWriter());
                } else {
                    retval.writeToStream(resp.getWriter());
                }
                LocalLogger.logToStdErr((String)"done writing output");
            }
            catch (AuthorizationException ae) {
                LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"getTableResultsCsv exception", (String)"message", (String)ae.toString());
                resp.getWriter().println("AuthorizationException\n" + ae.getMessage());
            }
        }
        catch (Exception e) {
            LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"getTableResultsCsv exception", (String)"message", (String)e.toString());
            LocalLogger.printStackTrace((Throwable)e);
        }
        finally {
            HeadersManager.clearHeaders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Get JSON table results", notes="GET triggers browser MIME type handling")
    @CrossOrigin
    @RequestMapping(value={"/getTableResultsJsonForWebClient"}, method={RequestMethod.GET})
    public ResponseEntity<Resource> getTableResultsJsonForWebClient(@RequestParam String jobId, @RequestParam(required=false) Integer maxRows, HttpServletResponse resp, @RequestHeader HttpHeaders headers) {
        HeadersManager.setHeaders((HttpHeaders)headers);
        LoggerRestClient logger = LoggerRestClient.loggerConfigInitialization((EasyLogEnabledConfigProperties)this.log_prop, (String)ThreadAuthenticator.getThreadUserName());
        resp.addHeader("content-type", "application/json; charset=utf-8");
        try {
            if (jobId == null) {
                throw new Exception("no jobId passed to endpoint.");
            }
            URL url = this.getJobTracker().getFullResultsURL(jobId);
            TableResultsSerializer retval = this.getTableResultsStorage().getJsonTable(url, maxRows, Integer.valueOf(0));
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + jobId + ".json\"; filename*=\"" + jobId + ".json\"");
            retval.writeToStream(resp.getWriter());
        }
        catch (Exception e) {
            LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"getTableResultsJsonForWebClient exception", (String)"message", (String)e.toString());
            LocalLogger.printStackTrace((Throwable)e);
        }
        finally {
            HeadersManager.clearHeaders();
        }
        LocalLogger.logToStdErr((String)"done writing output");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Get CSV table results", notes="GET triggers browser MIME type handling")
    @CrossOrigin
    @RequestMapping(value={"/getTableResultsCsvForWebClient"}, method={RequestMethod.GET})
    public void getTableResultsCsvForWebClient(@RequestParam String jobId, @RequestParam(required=false) Integer maxRows, HttpServletResponse resp, @RequestHeader HttpHeaders headers) {
        HeadersManager.setHeaders((HttpHeaders)headers);
        LoggerRestClient logger = LoggerRestClient.loggerConfigInitialization((EasyLogEnabledConfigProperties)this.log_prop, (String)ThreadAuthenticator.getThreadUserName());
        TableResultsSerializer retval = null;
        resp.addHeader("content-type", "text/plain; charset=utf-8");
        try {
            if (jobId == null) {
                throw new Exception("no jobId passed to endpoint.");
            }
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + jobId + ".csv\"; filename*=\"" + jobId + ".csv\"");
            URL url = this.getJobTracker().getFullResultsURL(jobId);
            try {
                retval = this.getTableResultsStorage().getCsvTable(url, maxRows, Integer.valueOf(0));
                retval.writeToStream(resp.getWriter());
            }
            catch (AuthorizationException ae) {
                LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"getTableResultsCsvForWebClient exception", (String)"message", (String)ae.toString());
                resp.getWriter().println("AuthorizationException\n" + ae.getMessage());
            }
        }
        catch (Exception e) {
            LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"getTableResultsCsvForWebClient exception", (String)"message", (String)e.toString());
            LocalLogger.printStackTrace((Throwable)e);
        }
        finally {
            HeadersManager.clearHeaders();
        }
        LocalLogger.logToStdErr((String)"done writing output");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Get table results row count", notes="")
    @CrossOrigin
    @RequestMapping(value={"/getTableResultsRowCount"}, method={RequestMethod.POST})
    public JSONObject getTableResultsRowCount(@RequestBody JobIdRequest requestBody, HttpServletResponse resp, @RequestHeader HttpHeaders headers) {
        HeadersManager.setHeaders((HttpHeaders)headers);
        LoggerRestClient logger = LoggerRestClient.loggerConfigInitialization((EasyLogEnabledConfigProperties)this.log_prop, (String)ThreadAuthenticator.getThreadUserName());
        try {
            SimpleResultSet retTrue = null;
            try {
                URL url = this.getJobTracker().getFullResultsURL(requestBody.jobId);
                int retval = this.getTableResultsStorage().getResultsRowCount(url);
                retTrue = new SimpleResultSet(Boolean.valueOf(true));
                retTrue.addResult("rowCount", retval);
            }
            catch (Exception e) {
                LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"getTableResultsRowCount exception", (String)"message", (String)e.toString());
                retTrue = new SimpleResultSet(Boolean.valueOf(false));
                retTrue.addRationaleMessage(SERVICE_NAME, "getTableResultsRowCount", e);
            }
            finally {
                HeadersManager.setHeaders((HttpHeaders)new HttpHeaders());
            }
            JSONObject jSONObject = retTrue.toJson();
            return jSONObject;
        }
        finally {
            HeadersManager.clearHeaders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Get JSON table", notes="Too large a file can fail.  <br>This is good for a preview, for example, in a browser with limited memory.<br>GET /getTableResultsCsvForWebClient safely retrieves entire large files.")
    @CrossOrigin
    @RequestMapping(value={"/getTableResultsJson"}, method={RequestMethod.POST})
    public void getTableResultsJson(@RequestBody ResultsRequestBodyMaxRows requestBody, HttpServletResponse resp, @RequestHeader HttpHeaders headers) {
        HeadersManager.setHeaders((HttpHeaders)headers);
        resp.addHeader("content-type", "application/json; charset=utf-8");
        LoggerRestClient logger = LoggerRestClient.loggerConfigInitialization((EasyLogEnabledConfigProperties)this.log_prop, (String)ThreadAuthenticator.getThreadUserName());
        String ENDPOINT = "getTableResultsJson";
        try {
            URL url = this.getJobTracker().getFullResultsURL(requestBody.jobId);
            TableResultsSerializer retval = this.getTableResultsStorage().getJsonTable(url, requestBody.maxRows, requestBody.getStartRow());
            this.wrapJsonInTableToSend(retval, resp);
        }
        catch (Exception e) {
            try {
                this.writeError(e, "getTableResultsJson", resp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"getTableResultsJson exception", (String)"message", (String)e.toString());
            LocalLogger.printStackTrace((Throwable)e);
        }
        finally {
            HeadersManager.clearHeaders();
        }
        LocalLogger.logToStdErr((String)"done writing output");
    }

    private void writeError(Exception e, String endpoint, HttpServletResponse resp) throws Exception {
        PrintWriter outPrint = resp.getWriter();
        outPrint.write("\n\n==============\nInternal error in ResultsService/" + endpoint + "\n==============\n");
        e.printStackTrace(outPrint);
        outPrint.write("\n==============\n");
        outPrint.flush();
        outPrint.close();
    }

    private void wrapJsonInTableToSend(TableResultsSerializer trs, HttpServletResponse resp) throws Exception {
        PrintWriter outPrint = resp.getWriter();
        outPrint.write("{\"message\":\"operations succeeded.\",\"table\":{\"@table\":");
        outPrint.flush();
        trs.writeToStream(resp.getWriter());
        outPrint.write("},\"status\":\"success\"}");
        outPrint.flush();
        outPrint.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Get fullURL (csv) and sampleURL (JSON)", notes="DEPRECATED<br>Use /getTableResultsJsonForWebClient and /getTableResultsCsvForWebClient instead <br>URL's may not work in a secure deployment of SemTK")
    @CrossOrigin
    @RequestMapping(value={"/getResults"}, method={RequestMethod.POST})
    public JSONObject getResults(@RequestBody JobIdRequest requestBody, @RequestHeader HttpHeaders headers) {
        HeadersManager.setHeaders((HttpHeaders)headers);
        LoggerRestClient logger = LoggerRestClient.loggerConfigInitialization((EasyLogEnabledConfigProperties)this.log_prop, (String)ThreadAuthenticator.getThreadUserName());
        try {
            SimpleResultSet res = new SimpleResultSet();
            LocalLogger.logToStdOut((String)("Results Service getResults JobId=" + requestBody.jobId));
            try {
                if (!this.getJobTracker().jobExists(requestBody.jobId)) {
                    throw new Exception("No job exists with id " + requestBody.jobId);
                }
                res.addResult("fullURL", this.getFullCsvUserURL(requestBody.jobId));
                res.addResult("sampleURL", this.getSampleJsonUserURL(requestBody.jobId));
                LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"getResults URLs", (String)"sampleURL", (String)this.getSampleJsonUserURL(requestBody.jobId), (String)"fullURL", (String)this.getFullCsvUserURL(requestBody.jobId));
                res.setSuccess(Boolean.valueOf(true));
            }
            catch (Exception e) {
                res.setSuccess(Boolean.valueOf(false));
                res.addRationaleMessage(SERVICE_NAME, "getResults", e);
                LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"getResults exception", (String)"message", (String)e.toString());
                LocalLogger.printStackTrace((Throwable)e);
            }
            JSONObject jSONObject = res.toJson();
            return jSONObject;
        }
        finally {
            HeadersManager.clearHeaders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="delete job", notes="")
    @CrossOrigin
    @RequestMapping(value={"/deleteJob"}, method={RequestMethod.POST})
    public JSONObject deleteStorage(@RequestBody JobIdRequest requestBody, @RequestHeader HttpHeaders headers) {
        HeadersManager.setHeaders((HttpHeaders)headers);
        LoggerRestClient logger = LoggerRestClient.loggerConfigInitialization((EasyLogEnabledConfigProperties)this.log_prop, (String)ThreadAuthenticator.getThreadUserName());
        try {
            LocalLogger.logToStdOut((String)("Results Service deleteStorage JobId=" + requestBody.jobId));
            SimpleResultSet res = new SimpleResultSet();
            try {
                this.getJobTracker().deleteJob(requestBody.jobId, this.getTableResultsStorage());
                res.setSuccess(Boolean.valueOf(true));
            }
            catch (Exception e) {
                res.setSuccess(Boolean.valueOf(false));
                res.addRationaleMessage(SERVICE_NAME, "deleteStorage", e);
                LoggerRestClient.easyLog((LoggerRestClient)logger, (String)SERVICE_NAME, (String)"deleteJob exception", (String)"message", (String)e.toString());
            }
            finally {
                HeadersManager.setHeaders((HttpHeaders)new HttpHeaders());
            }
            JSONObject jSONObject = res.toJson();
            return jSONObject;
        }
        finally {
            HeadersManager.clearHeaders();
        }
    }

    private TableResultsStorage getTableResultsStorage() throws Exception {
        return new TableResultsStorage(this.prop.getFileLocation());
    }

    private JsonLdResultsStorage getJsonLdResultsStorage() throws Exception {
        return new JsonLdResultsStorage(this.prop.getFileLocation());
    }

    private GenericJsonBlobResultsStorage getJsonBlobResultsStorage() throws Exception {
        return new GenericJsonBlobResultsStorage(this.prop.getFileLocation());
    }

    private JobTracker getJobTracker() throws Exception {
        return new JobTracker(this.servicesgraph_prop.buildSei());
    }

    private String getSampleJsonUserURL(String jobId) throws MalformedURLException {
        return new URL(this.prop.getBaseURL() + "/results/getTableResultsJsonForWebClient?jobId=" + jobId + "&maxRows=200").toString();
    }

    private String getFullCsvUserURL(String jobId) throws MalformedURLException {
        return new URL(this.prop.getBaseURL() + "/results/getTableResultsCsvForWebClient?jobId=" + jobId).toString();
    }

    private String generateFileId() {
        return UUID.randomUUID().toString();
    }

    private String buildStoragePath(String jobId, String fileId) throws Exception {
        return this.prop.getFileLocation() + "/" + jobId + "/" + fileId;
    }

    private void validatePathElement(String elem) throws Exception {
        if (Pattern.matches("[^0-9a-zA-Z\\.\\s_-]", elem) || elem.contains("..")) {
            throw new Exception("Value contains bad characters: " + elem);
        }
    }

    private void validatePath(String path) throws Exception {
        Path p = Paths.get(path, new String[0]);
        boolean found = p.startsWith(Paths.get(this.prop.getFileLocation(), new String[0]));
        for (String legal : this.prop.getAdditionalFileLocations()) {
            if (!p.startsWith(Paths.get(legal, new String[0]))) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new Exception("Permission is denied.  Path is not white-listed in properties fileLocation or additionalFileLocations: " + path);
        }
        int nameCount = p.getNameCount();
        for (int i = 0; i < nameCount; ++i) {
            Path last = p.getFileName();
            this.validatePathElement(last.toString());
            p = p.getParent();
        }
    }
}

