/*
 * Decompiled with CFR 0.152.
 */
package com.garethahealy.elasticpostman.scraper.processors;

import com.garethahealy.elasticpostman.scraper.entities.EmailContent;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegExSplitProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(RegExSplitProcessor.class);
    private static final Pattern PATTERN = Pattern.compile("(^From\\s\\w*@redhat.com\\s.*)", 8);

    public void process(Exchange exchange) throws Exception {
        String text = (String)exchange.getIn().getBody(String.class);
        ArrayList<EmailContent> answer = new ArrayList<EmailContent>();
        Matcher matches = PATTERN.matcher(text);
        int lastIndex = 0;
        while (matches.find()) {
            int index = matches.start();
            if (index > 0) {
                LOG.debug("start / end === {} / {}", (Object)lastIndex, (Object)index);
                EmailContent email = new EmailContent(text.substring(lastIndex, index));
                email.parse();
                answer.add(email);
            }
            lastIndex = index;
        }
        EmailContent email = new EmailContent(text.substring(lastIndex, text.length()));
        email.parse();
        answer.add(email);
        exchange.getIn().setBody(answer);
    }
}

