/*
 * Decompiled with CFR 0.152.
 */
package com.garethahealy.elasticpostman.scraper.entities;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.Header;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.commons.collections4.iterators.EnumerationIterator;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.mail.util.MimeMessageParser;
import org.apache.commons.mail.util.MimeMessageUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailContent {
    private static final Logger LOG = LoggerFactory.getLogger(EmailContent.class);
    private final String raw;
    private String from;
    private String subject;
    private String content;
    private Collection<String> contentIds;
    private DateTime sentDate;
    private Map<String, String> headers;

    public EmailContent(String raw) {
        this.raw = raw;
    }

    public void parse() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (String)this.raw);
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        MimeMessageParser parsed = mimeMessageParser.parse();
        this.from = parsed.getFrom();
        this.subject = parsed.getSubject();
        this.content = parsed.getPlainContent();
        this.contentIds = parsed.getContentIds();
        this.sentDate = new DateTime((Object)parsed.getMimeMessage().getSentDate());
        this.headers = new HashMap<String, String>();
        EnumerationIterator it = new EnumerationIterator(parsed.getMimeMessage().getAllHeaders());
        while (it.hasNext()) {
            Header header;
            Object current = it.next();
            if (!(current instanceof Header) || !this.includeHeader((header = (Header)current).getName()).booleanValue()) continue;
            this.headers.put(header.getName(), this.sanatizeValue(header.getName(), header.getValue()));
        }
    }

    private Boolean includeHeader(String header) {
        return !header.startsWith("From ");
    }

    private String sanatizeValue(String header, String value) {
        if (header.equalsIgnoreCase("X-List-Received-Date") || header.equalsIgnoreCase("Date")) {
            DateTime parsed = this.tryParseDate("EEE, dd MMM YYYY HH:mm:ss Z", value = value.trim(), false);
            if (parsed == null && (parsed = this.tryParseDate("EEE, dd MMM YYYY HH:mm:ss Z' ('zzz')'", value, true)) == null) {
                parsed = this.tryParseDate("EEE, dd MMM YYYY HH:mm:ss Z", value.substring(0, value.length() - 6), true);
            }
            if (parsed != null) {
                value = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'").print((ReadableInstant)parsed);
            }
        }
        return value;
    }

    private DateTime tryParseDate(String pattern, String value, Boolean isLogException) {
        DateTime parsed;
        block4: {
            parsed = null;
            try {
                parsed = DateTimeFormat.forPattern((String)pattern).parseDateTime(value);
            }
            catch (UnsupportedOperationException ex) {
                if (isLogException.booleanValue()) {
                    LOG.error(ex.toString());
                }
            }
            catch (IllegalArgumentException ex) {
                if (!isLogException.booleanValue()) break block4;
                LOG.error(ex.toString());
            }
        }
        return parsed;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("from", this.from);
        map.put("subject", this.subject);
        map.put("content", this.content);
        map.put("contentIds", this.contentIds);
        map.put("sentDate", DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'").print((ReadableInstant)this.sentDate));
        map.put("headers", this.headers);
        return map;
    }

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getContent() {
        return this.content;
    }

    public Collection<String> getContentIds() {
        return this.contentIds;
    }

    public DateTime getSentDate() {
        return this.sentDate;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public int gethashCode() {
        return this.hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("raw", (Object)this.raw).append("from", (Object)this.from).append("subject", (Object)this.subject).append("content", (Object)this.content).append("contentIds", this.contentIds).append("sentDate", (Object)this.sentDate).append("headers", this.headers).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailContent that = (EmailContent)o;
        return new EqualsBuilder().append((Object)this.raw, (Object)that.raw).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.raw).toHashCode();
    }
}

