/*
 * Decompiled with CFR 0.152.
 */
package com.garethahealy.camel.dynamic.loadbalancer.statistics.mbeans;

import com.garethahealy.camel.dynamic.loadbalancer.statistics.ProcessorHolder;
import com.garethahealy.camel.dynamic.loadbalancer.statistics.RouteHolder;
import com.garethahealy.camel.dynamic.loadbalancer.statistics.RouteStatistics;
import com.garethahealy.camel.dynamic.loadbalancer.statistics.StatisticsCollectorType;
import com.garethahealy.camel.dynamic.loadbalancer.statistics.mbeans.BaseMBeanAttributeCollector;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.processor.interceptor.DefaultChannel;
import org.apache.camel.util.URISupport;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanRouteStatisticsCollector
extends BaseMBeanAttributeCollector {
    private static final Logger LOG = LoggerFactory.getLogger(MBeanRouteStatisticsCollector.class);
    private StatisticsCollectorType statisticsCollectorType;
    private boolean shouldCacheProcessorHolders;
    private boolean shouldCacheRouteHolders;
    private Map<String, ProcessorHolder> processorHoldersCache;
    private List<RouteHolder> routeHoldersCache;

    public MBeanRouteStatisticsCollector(CamelContext camelContext, MBeanServer mBeanServer, String statisticsCollectorType, boolean shouldCacheProcessorHolders, boolean shouldCacheRouteHolders) {
        super(camelContext, mBeanServer);
        this.statisticsCollectorType = StatisticsCollectorType.fromValue(statisticsCollectorType);
        this.shouldCacheProcessorHolders = shouldCacheProcessorHolders;
        this.shouldCacheRouteHolders = shouldCacheRouteHolders;
    }

    @Override
    public List<RouteStatistics> query(List<Processor> processors, Exchange exchange) {
        Map<String, ProcessorHolder> processorHolders = this.getProcessorHolders(processors, exchange);
        List<RouteHolder> routeHolders = this.getRouteNames(processorHolders);
        ArrayList<RouteStatistics> stats = new ArrayList<RouteStatistics>();
        for (RouteHolder current : routeHolders) {
            stats.add(this.query(processorHolders, current.getCamelContextName(), current.getRouteName()));
        }
        return stats;
    }

    private List<RouteHolder> getRouteNames(Map<String, ProcessorHolder> processorHolders) {
        if (!this.shouldCacheRouteHolders || this.routeHoldersCache == null || this.routeHoldersCache.isEmpty()) {
            this.routeHoldersCache = new ArrayList<RouteHolder>();
            Set<ObjectName> set = this.queryNames(null, null, StatisticsCollectorType.ALL_ROUTES);
            for (ObjectName foundMBean : set) {
                String uri = this.normalizeUri(this.getStringAttribute(foundMBean, "EndpointUri"));
                if (!processorHolders.containsKey(uri)) continue;
                RouteHolder holder = new RouteHolder();
                holder.setCamelContextName(this.getStringAttribute(foundMBean, "CamelId"));
                holder.setRouteName(this.getStringAttribute(foundMBean, "RouteId"));
                holder.setUri(uri);
                this.routeHoldersCache.add(holder);
            }
            if (this.routeHoldersCache.isEmpty()) {
                throw new IllegalStateException("Found no route holders based on keys '" + Arrays.toString(processorHolders.keySet().toArray()) + "'");
            }
            if (this.routeHoldersCache.size() != processorHolders.size()) {
                throw new IllegalStateException("Route holders '" + this.routeHoldersCache.size() + "' does not match process holders '" + processorHolders.size() + "'");
            }
            LOG.debug("Found '{}' routes which match the processors", (Object)Arrays.toString(this.routeHoldersCache.toArray()));
        }
        return this.routeHoldersCache;
    }

    private RouteStatistics query(Map<String, ProcessorHolder> processorHolders, String camelContextName, String name) {
        String uri;
        ObjectName foundMBean;
        String camelId;
        RouteStatistics stats = null;
        Set<ObjectName> set = this.queryNames(camelContextName, name, this.statisticsCollectorType);
        Iterator<ObjectName> iterator = set.iterator();
        if (iterator.hasNext() && (camelId = this.getStringAttribute(foundMBean = iterator.next(), "CamelId")) != null && camelId.equalsIgnoreCase(camelContextName) && processorHolders.containsKey(uri = this.normalizeUri(this.getStringAttribute(foundMBean, "EndpointUri")))) {
            stats = new RouteStatistics();
            stats.setProcessorHolder(processorHolders.get(uri));
            stats.setInflightExchange(this.getIntegerAttribute(foundMBean, "InflightExchanges"));
            stats.setMeanProcessingTime(this.getLongAttribute(foundMBean, "MeanProcessingTime"));
            stats.setLastProcessingTime(this.getLongAttribute(foundMBean, "LastProcessingTime"));
            stats.setLoad01(this.getStringAttribute(foundMBean, "Load01"));
            stats.setLoad05(this.getStringAttribute(foundMBean, "Load05"));
            stats.setLoad15(this.getStringAttribute(foundMBean, "Load15"));
            LOG.debug("Found '{}' stats for '{}' '{}'", new Object[]{stats, camelContextName, name});
        }
        if (stats == null) {
            throw new IllegalStateException("Did not find stats for '" + camelContextName + ":" + name + "' for keys '" + Arrays.toString(processorHolders.keySet().toArray()) + "'");
        }
        return stats;
    }

    private Map<String, ProcessorHolder> getProcessorHolders(List<Processor> processors, Exchange exchange) {
        if (!this.shouldCacheProcessorHolders || this.processorHoldersCache == null || this.processorHoldersCache.isEmpty()) {
            this.processorHoldersCache = new HashMap<String, ProcessorHolder>();
            for (Processor current : processors) {
                String uri = this.getUriFromProcessor(current);
                ProcessorHolder holder = new ProcessorHolder();
                holder.setCamelContextName(exchange.getContext().getName());
                holder.setRouteName(exchange.getFromRouteId());
                holder.setUri(uri);
                holder.setProcessor(current);
                this.processorHoldersCache.put(uri, holder);
            }
            if (this.processorHoldersCache.isEmpty()) {
                throw new IllegalStateException("Found no processor holders based on processors '" + Arrays.toString(processors.toArray()) + "'");
            }
            LOG.debug("Found '{}' processors'", (Object)Arrays.toString(this.processorHoldersCache.values().toArray()));
        }
        return this.processorHoldersCache;
    }

    private String getUriFromProcessor(Processor current) {
        String uri = "";
        if (current instanceof DefaultChannel) {
            DefaultChannel currentChannel = (DefaultChannel)current;
            Object outputValue = null;
            try {
                Field outputField = FieldUtils.getField(DefaultChannel.class, (String)"childDefinition", (boolean)true);
                outputValue = FieldUtils.readField((Field)outputField, (Object)currentChannel, (boolean)true);
            }
            catch (IllegalAccessException ex) {
                LOG.error("Cannot access 'childDefinition' on {} because: {}", (Object)current, (Object)ExceptionUtils.getStackTrace((Throwable)ex));
            }
            if (outputValue != null && outputValue instanceof ToDefinition) {
                ToDefinition to = (ToDefinition)outputValue;
                uri = this.normalizeUri(to.getUri());
            }
        }
        if (uri.isEmpty()) {
            throw new IllegalStateException("Could not get URI from processor '" + current + "'");
        }
        return uri;
    }

    private String normalizeUri(String uri) {
        String normalizeUri = "";
        if (uri != null) {
            try {
                normalizeUri = URISupport.normalizeUri((String)uri);
            }
            catch (URISyntaxException ex) {
                LOG.error("Tried to normalize uri {}, but went wrong: {}", (Object)uri, (Object)ExceptionUtils.getStackTrace((Throwable)ex));
            }
            catch (UnsupportedEncodingException ex) {
                LOG.error("Tried to normalize uri {}, but went wrong: {}", (Object)uri, (Object)ExceptionUtils.getStackTrace((Throwable)ex));
            }
        }
        return normalizeUri;
    }
}

