/*
 * Decompiled with CFR 0.152.
 */
package com.garethahealy.camel.dynamic.loadbalancer.statistics.mbeans;

import com.garethahealy.camel.dynamic.loadbalancer.statistics.StatisticsCollectorType;
import com.garethahealy.camel.dynamic.loadbalancer.statistics.strategy.RouteStatisticsCollector;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.ManagementAgent;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMBeanAttributeCollector
implements RouteStatisticsCollector {
    private static final Logger LOG = LoggerFactory.getLogger(BaseMBeanAttributeCollector.class);
    private ManagementAgent agent;
    private MBeanServer mBeanServer;

    public BaseMBeanAttributeCollector(CamelContext camelContext, MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
        this.agent = camelContext.getManagementStrategy().getManagementAgent();
    }

    protected Set<ObjectName> queryNames(String camelContextName, String name, StatisticsCollectorType type) {
        ObjectName objectName = null;
        if (type == StatisticsCollectorType.ROUTE) {
            objectName = this.createRouteObjectName(name);
        } else if (type == StatisticsCollectorType.PROCESSOR) {
            objectName = this.createProcessorObjectName(name);
        } else if (type == StatisticsCollectorType.ALL_ROUTES) {
            objectName = this.createAllRoutesObjectName();
        } else {
            LOG.error("StatisticsCollectorType '{}' is not supported for {}", (Object)type.value(), (Object)name);
        }
        return this.mBeanServer.queryNames(objectName, null);
    }

    private ObjectName createRouteObjectName(String routeId) {
        return this.createObjectName(":type=routes,name=\"" + routeId + "\",*");
    }

    private ObjectName createProcessorObjectName(String processorId) {
        return this.createObjectName(":type=processors,name=\"" + processorId + "\",*");
    }

    private ObjectName createObjectName(String query) {
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(this.agent.getMBeanObjectDomainName() + query);
        }
        catch (MalformedObjectNameException ex) {
            LOG.error(ExceptionUtils.getStackTrace((Throwable)ex));
        }
        return objectName;
    }

    private ObjectName createAllRoutesObjectName() {
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(this.agent.getMBeanObjectDomainName() + ":type=routes,*");
        }
        catch (MalformedObjectNameException ex) {
            LOG.error(ExceptionUtils.getStackTrace((Throwable)ex));
        }
        return objectName;
    }

    protected Long getLongAttribute(ObjectName routeMBean, String attribute) {
        return (Long)this.getAttribute(routeMBean, attribute);
    }

    protected Integer getIntegerAttribute(ObjectName routeMBean, String attribute) {
        return (Integer)this.getAttribute(routeMBean, attribute);
    }

    protected String getStringAttribute(ObjectName routeMBean, String attribute) {
        return (String)this.getAttribute(routeMBean, attribute);
    }

    private Object getAttribute(ObjectName routeMBean, String attributeName) {
        Object attribute = null;
        if (routeMBean != null) {
            try {
                attribute = this.mBeanServer.getAttribute(routeMBean, attributeName);
            }
            catch (MBeanException ex) {
                LOG.error(ExceptionUtils.getStackTrace((Throwable)ex));
            }
            catch (AttributeNotFoundException ex) {
                LOG.error(ExceptionUtils.getStackTrace((Throwable)ex));
            }
            catch (InstanceNotFoundException ex) {
                LOG.error(ExceptionUtils.getStackTrace((Throwable)ex));
            }
            catch (ReflectionException ex) {
                LOG.error(ExceptionUtils.getStackTrace((Throwable)ex));
            }
        }
        return attribute;
    }
}

