/*
 * Decompiled with CFR 0.152.
 */
package com.garethahealy.camel.dynamic.loadbalancer.statistics;

import com.garethahealy.camel.dynamic.loadbalancer.statistics.RouteStatistics;
import com.garethahealy.camel.dynamic.loadbalancer.statistics.strategy.ProcessorSelectorStrategy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeanProcessingTimeProcessorSelectorStrategy
implements ProcessorSelectorStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MeanProcessingTimeProcessorSelectorStrategy.class);

    @Override
    public Processor getProcessor(List<RouteStatistics> stats) {
        RouteStatistics best = null;
        for (RouteStatistics current : stats) {
            if (best == null) {
                best = current;
            }
            best = best.getMeanProcessingTime() <= current.getMeanProcessingTime() ? best : current;
        }
        LOG.debug("Found '{}' is the best processor", best);
        return best.getProcessorHolder().getProcessor();
    }

    @Override
    public List<Integer> getWeightedProcessors(List<RouteStatistics> stats, List<Processor> processors) {
        Collections.sort(stats, new RouteStatisticsComparator());
        HashMap<Processor, Integer> answer = new HashMap<Processor, Integer>();
        int i = stats.size();
        for (RouteStatistics current : stats) {
            answer.put(current.getProcessorHolder().getProcessor(), i);
            --i;
        }
        ArrayList<Integer> weighting = new ArrayList<Integer>();
        for (Processor current : processors) {
            Integer weight = (Integer)answer.get(current);
            weighting.add(weight);
            LOG.debug("Found '{}' for weighting '{}'", (Object)current, (Object)weight);
        }
        return weighting;
    }

    private static class RouteStatisticsComparator
    implements Comparator<RouteStatistics>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private RouteStatisticsComparator() {
        }

        @Override
        public int compare(RouteStatistics stat1, RouteStatistics stat2) {
            return stat1.getMeanProcessingTime().compareTo(stat2.getMeanProcessingTime());
        }
    }
}

