/*
 * Decompiled with CFR 0.152.
 */
package com.garethahealy.camel.dynamic.loadbalancer.statistics;

import com.garethahealy.camel.dynamic.loadbalancer.statistics.strategy.DeterministicCollectorStrategy;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EveryXDeterministicCollectorStrategy
implements DeterministicCollectorStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(EveryXDeterministicCollectorStrategy.class);
    private AtomicInteger counter = new AtomicInteger(0);
    private AtomicBoolean hasWarmedUp = new AtomicBoolean(false);
    private int warmup;
    private int everyX;

    public EveryXDeterministicCollectorStrategy(int warmup, int everyX) {
        this.warmup = warmup;
        this.everyX = everyX;
    }

    @Override
    public boolean shouldCollect() {
        boolean isGreaterThanEveryX;
        boolean answer = false;
        int current = this.counter.getAndIncrement();
        boolean isGreaterThanWarmupPeriod = this.hasWarmedUp.get() || current >= this.warmup;
        boolean bl = isGreaterThanEveryX = current >= this.everyX;
        if (isGreaterThanWarmupPeriod && isGreaterThanEveryX) {
            this.hasWarmedUp.set(true);
            this.counter.set(0);
            answer = true;
        }
        LOG.debug("shouldCollect is '{}'", (Object)answer);
        return answer;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("counter", (Object)this.counter).append("hasWarmedUp", (Object)this.hasWarmedUp).append("warmup", this.warmup).append("everyX", this.everyX).toString();
    }
}

