/*
 * Decompiled with CFR 0.152.
 */
package com.garethahealy.camel.dynamic.loadbalancer.core;

import com.garethahealy.camel.dynamic.loadbalancer.core.DynamicLoadBalancerConfiguration;
import com.garethahealy.camel.dynamic.loadbalancer.statistics.RouteStatistics;
import com.garethahealy.camel.dynamic.loadbalancer.statistics.strategy.DeterministicCollectorStrategy;
import com.garethahealy.camel.dynamic.loadbalancer.statistics.strategy.ProcessorSelectorStrategy;
import com.garethahealy.camel.dynamic.loadbalancer.statistics.strategy.RouteStatisticsCollector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.loadbalancer.WeightedRoundRobinLoadBalancer;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicWeightedRoundRobinLoadBalancer
extends WeightedRoundRobinLoadBalancer {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicWeightedRoundRobinLoadBalancer.class);
    private DynamicLoadBalancerConfiguration config;

    public DynamicWeightedRoundRobinLoadBalancer(DynamicLoadBalancerConfiguration config) {
        super(new ArrayList());
        this.config = config;
    }

    protected void doStart() throws Exception {
        this.updateWeightings(this.getDefaultRuntimeRatios(this.getProcessors()));
        super.doStart();
    }

    protected synchronized Processor chooseProcessor(List<Processor> processors, Exchange exchange) {
        ProcessorSelectorStrategy selectorStrategy;
        List<Integer> found;
        RouteStatisticsCollector routeStatisticsCollector;
        List<RouteStatistics> stats;
        DeterministicCollectorStrategy deterministicCollectorStrategy = this.config.getDeterministicCollectorStrategy();
        if (deterministicCollectorStrategy.shouldCollect() && (stats = (routeStatisticsCollector = this.config.getRouteStatisticsCollector()).query(processors, exchange)).size() > 0 && (found = (selectorStrategy = this.config.getRouteStatsSelectorStrategy()).getWeightedProcessors(stats, processors)).size() > 0) {
            LOG.info("About to update weightings to '{}'", (Object)Arrays.toString(found.toArray()));
            this.updateWeightings(found);
        }
        return super.chooseProcessor(processors, exchange);
    }

    private void updateWeightings(List<Integer> found) {
        this.setDistributionRatioList(found);
        this.getRuntimeRatios().clear();
        this.loadRuntimeRatios(found);
        if (this.getProcessors().size() != this.getDistributionRatioList().size()) {
            throw new IllegalArgumentException("Loadbalacing with " + this.getProcessors().size() + " should match number of distributions " + this.getDistributionRatioList().size());
        }
    }

    private List<Integer> getDefaultRuntimeRatios(List<Processor> processors) {
        ArrayList<Integer> ratios = new ArrayList<Integer>();
        for (int i = 1; i <= processors.size(); ++i) {
            ratios.add(i);
        }
        LOG.debug("Defaulting weights as '{}'", ratios.toArray());
        return ratios;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("config", (Object)this.config).toString();
    }
}

