/*
 * Decompiled with CFR 0.152.
 */
package com.garethahealy.camel.dynamic.loadbalancer.core;

import com.garethahealy.camel.dynamic.loadbalancer.core.DynamicLoadBalancerConfiguration;
import com.garethahealy.camel.dynamic.loadbalancer.statistics.RouteStatistics;
import com.garethahealy.camel.dynamic.loadbalancer.statistics.strategy.DeterministicCollectorStrategy;
import com.garethahealy.camel.dynamic.loadbalancer.statistics.strategy.ProcessorSelectorStrategy;
import com.garethahealy.camel.dynamic.loadbalancer.statistics.strategy.RouteStatisticsCollector;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.loadbalancer.RoundRobinLoadBalancer;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicRoundRobinLoadBalancer
extends RoundRobinLoadBalancer {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicRoundRobinLoadBalancer.class);
    private DynamicLoadBalancerConfiguration config;

    public DynamicRoundRobinLoadBalancer(DynamicLoadBalancerConfiguration config) {
        this.config = config;
    }

    protected synchronized Processor chooseProcessor(List<Processor> processors, Exchange exchange) {
        RouteStatisticsCollector routeStatisticsCollector;
        List<RouteStatistics> stats;
        Processor answer = null;
        Processor defaultSelection = super.chooseProcessor(processors, exchange);
        DeterministicCollectorStrategy deterministicCollectorStrategy = this.config.getDeterministicCollectorStrategy();
        if (deterministicCollectorStrategy.shouldCollect() && (stats = (routeStatisticsCollector = this.config.getRouteStatisticsCollector()).query(processors, exchange)).size() > 0) {
            ProcessorSelectorStrategy selectorStrategy = this.config.getRouteStatsSelectorStrategy();
            answer = selectorStrategy.getProcessor(stats);
            LOG.info("About to update processor to '{}'", (Object)answer);
        }
        if (answer == null) {
            answer = defaultSelection;
        }
        return answer;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("config", (Object)this.config).toString();
    }
}

