/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.util;

import android.util.Log;
import com.gameofwhales.sdk.GameOfWhales;
import com.gameofwhales.sdk.L;
import com.gameofwhales.sdk.protocol.commands.Command;
import com.gameofwhales.sdk.util.DataStorage;
import com.gameofwhales.sdk.util.InternalResponseListener;
import com.gameofwhales.sdk.util.Utils;
import com.gameofwhales.sdk.util.net.HTTP;
import com.gameofwhales.sdk.util.net.HTTPListener;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class RequestBuilder {
    public static String app_version;
    private static final String TAG = "RequestBuilder";
    private static final String SERVER_URL = "https://api.gameofwhales.com:8443";

    public static void createPackAndSend(HTTP http, DataStorage data, int commandsLimit, InternalResponseListener listener) throws Exception {
        if (http == null) {
            L.e(TAG, "http is null from: createPackAndSend");
            return;
        }
        if (data == null) {
            L.e(TAG, "data is null from: createPackAndSend");
            return;
        }
        List<Command> commands = data.getCommandsAndRemove(commandsLimit);
        JSONArray array = Utils.CommandsToJSONArray(commands);
        if (array == null) {
            Log.e((String)TAG, (String)"createPackAndSend: array is null");
            return;
        }
        if (array.length() == 0) {
            Log.i((String)TAG, (String)"createPackAndSend: array is empty");
            return;
        }
        Log.i((String)TAG, (String)("Commands Left: " + data.getCommands().size()));
        JSONObject object = new JSONObject();
        object.put("game", (Object)data.getGameID());
        object.put("user", (Object)data.getAdvID());
        String version = app_version;
        object.put("platform", (Object)"android");
        object.put("version", (Object)version);
        JSONObject sdk = new JSONObject();
        sdk.put("version", (Object)GameOfWhales.VERSION);
        sdk.put("platform", (Object)GameOfWhales.platform);
        object.put("sdk", (Object)sdk);
        object.put("events", (Object)array);
        String url = "https://api.gameofwhales.com:8443/sdk.events";
        L.i(TAG, "Sending pack: https://api.gameofwhales.com:8443/sdk.events");
        L.i(TAG, "Args " + object.toString());
        http.send("https://api.gameofwhales.com:8443/sdk.events", object.toString(), (HTTPListener)listener);
    }

    public static void create(HTTP http, DataStorage data, Command command, InternalResponseListener listener) throws Exception {
        JSONObject args = command.getArgs();
        if (args == null) {
            L.e(TAG, "Args is null for " + command.getID());
            return;
        }
        args.put("game", (Object)data.getGameID());
        args.put("user", (Object)data.getAdvID());
        String url = "https://api.gameofwhales.com:8443/" + command.getID();
        L.i(TAG, "Sending: " + url);
        L.i(TAG, "Args " + args.toString());
        command.setState(Command.State.WaitingResponse);
        http.send(url, args.toString(), (HTTPListener)listener);
    }
}

