/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.util;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import com.gameofwhales.sdk.GameOfWhales;
import com.gameofwhales.sdk.L;
import com.gameofwhales.sdk.async.NotificationTask;
import com.gameofwhales.sdk.protocol.commands.Command;
import com.gameofwhales.sdk.protocol.commands.PushDeliveredCommand;
import com.gameofwhales.sdk.util.DataStorage;
import com.gameofwhales.sdk.util.GOWBroadcastReceiver;
import com.gameofwhales.sdk.util.InternalResponseListener;
import com.gameofwhales.sdk.util.RequestBuilder;
import com.gameofwhales.sdk.util.Utils;
import com.gameofwhales.sdk.util.net.HTTP;
import org.json.JSONObject;

public class GOWPushService
extends IntentService {
    private static String TAG = "GOW.PushService";
    private Intent intent;
    private DataStorage data = null;
    private HTTP http = null;
    InternalResponseListener listener = new InternalResponseListener(null){

        @Override
        public void OnResponse(Command command, boolean error, JSONObject response) {
            L.i(TAG, "onResponse: error: " + error + ", response: " + response);
            if (error) {
                GOWPushService.this.finishSend();
                GOWPushService.this.complete();
                return;
            }
            GOWPushService.this.sendPack();
        }
    };

    public GOWPushService() {
        super(TAG);
    }

    protected void onHandleIntent(Intent intent) {
        L.i(TAG, "onHandleIntent");
        this.intent = intent;
        Bundle extras = intent.getExtras();
        String campID = extras.getString("camp");
        String title = extras.getString("title");
        String message = extras.getString("subtitle");
        L.i(TAG, "IsForeground: " + GameOfWhales.IsAppForeground());
        if (GameOfWhales.IsAppForeground()) {
            if (GameOfWhales.getInstance() != null) {
                GameOfWhales.getInstance().notifyPushDelivered(campID, title, message);
            }
        } else {
            NotificationTask notification = new NotificationTask((Context)this, extras, null);
            notification.show();
            this.complete();
        }
        if (GameOfWhales.getInstance() != null) {
            GameOfWhales.PushDelivered(campID);
        } else {
            this.data = new DataStorage((Context)this, null);
            this.data.addCommand(new PushDeliveredCommand(campID));
            this.sendPack();
        }
    }

    private void finishSend() {
        this.data = null;
        this.http = null;
        this.complete();
    }

    private void sendPack() {
        if (!Utils.IsOnline((Context)this)) {
            Log.i((String)TAG, (String)"No internet. Will send later");
            this.finishSend();
            return;
        }
        if (this.data == null) {
            this.data = new DataStorage((Context)this, null);
            if (!this.data.isReady()) {
                Log.i((String)TAG, (String)"data is not ready");
                this.finishSend();
                return;
            }
        }
        if (this.data.getCommands().size() == 0) {
            this.finishSend();
            return;
        }
        if (this.http == null) {
            this.http = new HTTP();
        }
        try {
            RequestBuilder.createPackAndSend(this.http, this.data, 10, this.listener);
        }
        catch (Exception e) {
            L.e(TAG, "Request create json error!");
            e.printStackTrace();
            this.finishSend();
            return;
        }
    }

    private void complete() {
        if (this.http == null) {
            GOWBroadcastReceiver.completeWakefulIntent((Intent)this.intent);
        }
    }
}

