/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import com.gameofwhales.sdk.L;
import com.gameofwhales.sdk.protocol.SpecialOfferData;
import com.gameofwhales.sdk.protocol.commands.Command;
import com.gameofwhales.sdk.protocol.commands.CommandFactory;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class DataStorage {
    private static String TAG = "GOW.DataStorage";
    private static final String DATA_FILE = "gow.data";
    private static final String GAME_KEY = "gameOfWhales.gameId";
    private String gameID = "";
    private String advID = "";
    private String token = "";
    private List<Command> commands = new ArrayList<Command>();
    private List<SpecialOfferData> offers = new ArrayList<SpecialOfferData>();
    private Context context;

    public DataStorage(Context context, String gameID) {
        this.gameID = gameID;
        this.context = context;
        this.loadData();
        this.readGameIDFromManifest();
    }

    public List<Command> getCommandsAndRemove(int maxCount) {
        if (this.commands == null) {
            L.e(TAG, "Commands is null from: addCommand");
            return null;
        }
        ArrayList<Command> list = new ArrayList<Command>();
        int count = 0;
        Iterator<Command> iterator = this.commands.iterator();
        while (iterator.hasNext()) {
            Command cmd = iterator.next();
            if (cmd == null) continue;
            list.add(cmd);
            iterator.remove();
            if (++count < maxCount) continue;
            break;
        }
        this.saveData();
        return list;
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public void addCommand(Command command) {
        if (this.commands == null) {
            L.e(TAG, "Commands is null from: addCommand");
            return;
        }
        this.commands.add(command);
        this.saveData();
    }

    public void clearCommands() {
        if (this.commands == null) {
            L.e(TAG, "Commands is null from: clearCommands");
            return;
        }
        this.commands.clear();
        this.saveData();
    }

    public String getGameID() {
        return this.gameID;
    }

    public String getAdvID() {
        return this.advID;
    }

    public String getToken() {
        return this.token;
    }

    public void setGameID(String gameID) {
        this.gameID = gameID;
        this.saveData();
    }

    public void setAdvID(String advID) {
        this.advID = advID;
        this.saveData();
    }

    public void setToken(String token) {
        this.token = token;
        this.saveData();
    }

    public boolean isReady() {
        boolean isReady;
        if (this.advID == null || this.gameID == null) {
            return false;
        }
        boolean bl = isReady = !this.advID.isEmpty() && !this.gameID.isEmpty();
        if (L.isDebug) {
            L.d(TAG, "isSDKReady called");
            L.d(TAG, "    AdverstingID: " + this.advID);
            L.d(TAG, "    gameID:       " + this.gameID);
            L.d(TAG, "    State: " + (isReady ? "Ready" : "Not ready"));
        }
        return isReady;
    }

    public void addSpecialOffer(SpecialOfferData offer) {
        this.offers.add(offer);
    }

    public SpecialOfferData getSpecialOffer(String id) {
        if (this.offers == null) {
            L.e(TAG, "Offers is null from: offers");
            return null;
        }
        for (SpecialOfferData offer : this.offers) {
            if (offer == null || !offer.getId().equals(id)) continue;
            return offer;
        }
        return null;
    }

    public void saveData() {
        L.i(TAG, "Saving data...");
        try {
            JSONObject json = new JSONObject();
            json.put("gameID", (Object)this.gameID);
            json.put("userID", (Object)this.advID);
            json.put("token", (Object)this.token);
            JSONArray commandsArray = new JSONArray();
            int count = 1;
            for (Command command : this.commands) {
                String data = command.save().toString();
                L.i(TAG, "Saving command [" + count + "]: " + data);
                ++count;
                commandsArray.put((Object)command.save());
            }
            json.put("commands", (Object)commandsArray);
            L.i(TAG, "Saved data: " + json.toString());
            FileOutputStream fos = this.context.openFileOutput(DATA_FILE, 0);
            fos.write(json.toString().getBytes());
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadData() {
        L.i(TAG, "Reading data...");
        try {
            try {
                StringBuffer datax = new StringBuffer("");
                FileInputStream fIn = this.context.openFileInput(DATA_FILE);
                InputStreamReader isr = new InputStreamReader(fIn);
                BufferedReader buffreader = new BufferedReader(isr);
                String readString = buffreader.readLine();
                while (readString != null) {
                    datax.append(readString);
                    readString = buffreader.readLine();
                }
                isr.close();
                JSONObject json = new JSONObject(datax.toString());
                L.i(TAG, "Loaded data: " + json.toString());
                if (this.gameID == null || this.gameID.isEmpty()) {
                    this.gameID = json.getString("gameID");
                }
                if (json.has("commands")) {
                    JSONArray commandsArray = json.getJSONArray("commands");
                    for (int i = 0; i < commandsArray.length(); ++i) {
                        JSONObject object = commandsArray.getJSONObject(i);
                        L.i(TAG, "read command: " + object.toString());
                        Command command = CommandFactory.create(object);
                        if (command == null) continue;
                        this.commands.add(command);
                    }
                }
                this.advID = json.getString("userID");
                this.token = json.getString("token");
            }
            catch (FileNotFoundException datax) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readGameIDFromManifest() {
        if (this.gameID == null || this.gameID.isEmpty()) {
            try {
                ApplicationInfo ai = this.context.getPackageManager().getApplicationInfo(this.context.getPackageName(), 128);
                Bundle bundle = ai.metaData;
                if (bundle != null) {
                    this.gameID = bundle.getString(GAME_KEY);
                    this.saveData();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.gameID == null || this.gameID.isEmpty()) {
                L.e(TAG, String.format("GameID is not set! Add <meta-data android:name=\"%s\" android:value=\"YOUR_GAME_ID\" /> to AndroidManifest.xml", GAME_KEY));
            }
        }
    }
}

