/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Process;
import com.gameofwhales.sdk.CommandQueue;
import com.gameofwhales.sdk.GameOfWhalesListener;
import com.gameofwhales.sdk.L;
import com.gameofwhales.sdk.SpecialOffer;
import com.gameofwhales.sdk.async.AdverstingIDAsyncTask;
import com.gameofwhales.sdk.async.AdverstingIDAsyncTaskListener;
import com.gameofwhales.sdk.protocol.Product;
import com.gameofwhales.sdk.protocol.SpecialOfferData;
import com.gameofwhales.sdk.protocol.commands.Command;
import com.gameofwhales.sdk.protocol.commands.ConvertingCommand;
import com.gameofwhales.sdk.protocol.commands.ErrorCommand;
import com.gameofwhales.sdk.protocol.commands.LoginCommand;
import com.gameofwhales.sdk.protocol.commands.ProfileCommand;
import com.gameofwhales.sdk.protocol.commands.PushDeliveredCommand;
import com.gameofwhales.sdk.protocol.commands.PushReactedCommand;
import com.gameofwhales.sdk.protocol.commands.ReceiptCommand;
import com.gameofwhales.sdk.protocol.commands.TokenCommand;
import com.gameofwhales.sdk.util.ActivityLyfecycleListener;
import com.gameofwhales.sdk.util.CommandListener;
import com.gameofwhales.sdk.util.DataStorage;
import com.gameofwhales.sdk.util.GOWGCMService;
import com.gameofwhales.sdk.util.RequestBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public class GameOfWhales {
    public static String platform = "android";
    public static String VERSION = "2.0.6";
    public static final String CAMPAIGN_ID = "camp";
    public static final String PUSH_GOW = "gowpush";
    private static final String TAG = "GOW.GameOfWhales";
    public static final String PROVIDER_FCM = "fcm";
    public static final String PROVIDER_GCM = "gcm";
    public static final String VERIFY_STATE_LEGAL = "legal";
    public static final String VERIFY_STATE_ILLEGAL = "illegal";
    public static final String VERIFY_STATE_UNDEFINED = "undefined";
    public static final String INTENT_ANDROID_ID = "androidID";
    private static final int BATCHING_DELAY = 30000;
    private static GameOfWhales INSTANCE;
    private final Activity activity;
    private CommandQueue queue;
    private Set<String> segments = new HashSet<String>();
    private Set<GameOfWhalesListener> listeners = new HashSet<GameOfWhalesListener>();
    private Map<String, Product> products = new HashMap<String, Product>();
    private List<SpecialOfferData> specialOfferData = new ArrayList<SpecialOfferData>();
    private Map<String, SpecialOffer> activeOffers = new HashMap<String, SpecialOffer>();
    private DataStorage data;
    private ActivityLyfecycleListener cycleListener;
    private Handler batchingHandler = new Handler();
    private Intent lastIntent;
    private CommandListener commandListener = new CommandListener(){

        @Override
        public void onCommandResponse(Command command, JSONObject response) {
            GameOfWhales.this.onCommandResponse(command, response);
        }
    };
    long _lastBatchTime = 0L;
    private Runnable updateRunner = new Runnable(){

        @Override
        public void run() {
            if (GameOfWhales.this.check("updateRunner run")) {
                return;
            }
            long current = System.currentTimeMillis();
            if (current - GameOfWhales.this._lastBatchTime > 30000L) {
                GameOfWhales.this._lastBatchTime = current;
                GameOfWhales.this.queue.tryToSendNext();
            }
            boolean offersChanged = false;
            Iterator it = GameOfWhales.this.activeOffers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                SpecialOffer rep = (SpecialOffer)entry.getValue();
                if (rep == null) {
                    L.e(GameOfWhales.TAG, "rep is null from: updateRunner");
                    continue;
                }
                if (!rep.isExpired()) continue;
                offersChanged = true;
                it.remove();
                GameOfWhales.this.onDisappeared(rep);
            }
            if (offersChanged) {
                GameOfWhales.this.updateSpecialOffers();
            }
            GameOfWhales.this.runUpdate();
        }
    };

    private GameOfWhales(Activity activity, String gameID, GameOfWhalesListener listener) {
        L.d(TAG, "GameOfWhales");
        this.activity = activity;
        RequestBuilder.app_version = this.GetAppVersion();
        this.data = new DataStorage((Context)activity, gameID);
        this.queue = new CommandQueue(activity, this.data, this.commandListener);
        this.cycleListener = new ActivityLyfecycleListener();
        activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.cycleListener);
        if (listener != null) {
            this.addListener(listener);
        }
        if (this.data.getAdvID().isEmpty()) {
            AdverstingIDAsyncTask advTask = new AdverstingIDAsyncTask((Context)activity, new AdverstingIDAsyncTaskListener(){

                @Override
                public void onSuccess(String id) {
                    if (GameOfWhales.this.check("AdverstingIDAsyncTask onSuccess")) {
                        return;
                    }
                    GameOfWhales.this.data.setAdvID(id);
                    GameOfWhales.this.queue.tryToSendNext();
                    GameOfWhales.this.firstlogin();
                }

                @Override
                public void onFailure() {
                    if (GameOfWhales.this.check("AdverstingIDAsyncTask onFailure")) {
                        return;
                    }
                    String id = "gen-android-" + UUID.randomUUID().toString();
                    GameOfWhales.this.data.setAdvID(id);
                    GameOfWhales.this.queue.tryToSendNext();
                    GameOfWhales.this.firstlogin();
                }
            });
            advTask.execute(new Void[0]);
        } else {
            this.firstlogin();
        }
        GameOfWhales.SubscribeErrors();
        this.runUpdate();
        this.data.saveData();
    }

    public static GameOfWhales getInstance() {
        return INSTANCE;
    }

    void firstlogin() {
        if (this.check("firstlogin")) {
            return;
        }
        this.login();
        this.readIntent();
        this.queue.tryToSendNext();
    }

    private void login() {
        if (this.check("login")) {
            return;
        }
        this.queue.add(new LoginCommand());
    }

    private Product getProduct(String sku) {
        if (this.check("getProduct")) {
            return null;
        }
        if (!this.products.containsKey(sku)) {
            this.products.put(sku, new Product(sku));
        }
        return this.products.get(sku);
    }

    private static boolean instanceCheck(String from) {
        if (INSTANCE == null) {
            L.e(TAG, from + ": GameOfWhales not initialized");
            return false;
        }
        return true;
    }

    public void pushDelivered(String campID) {
        if (this.check("pushDelivered")) {
            return;
        }
        if (campID == null || campID.isEmpty()) {
            return;
        }
        PushDeliveredCommand command = new PushDeliveredCommand(campID);
        this.queue.add(command);
    }

    public static void PushDelivered(String campID) {
        if (GameOfWhales.instanceCheck("PushDelivered")) {
            INSTANCE.pushDelivered(campID);
        }
    }

    public void pushReacted(String campID) {
        if (this.check("pushReacted")) {
            return;
        }
        if (campID == null || campID.isEmpty()) {
            return;
        }
        PushReactedCommand command = new PushReactedCommand(campID);
        this.queue.add(command);
    }

    public static void PushReacted(String campID) {
        if (GameOfWhales.instanceCheck("PushReacted")) {
            INSTANCE.pushReacted(campID);
        }
    }

    public static void UpdateToken(String token, String provider) {
        if (GameOfWhales.instanceCheck("UpdateToken")) {
            INSTANCE.updateToken(token, provider);
        }
    }

    public static void ReportError(String message, String stacktrace) {
        if (GameOfWhales.instanceCheck("ReportError")) {
            INSTANCE.reportError(message, stacktrace);
        }
    }

    public void reportError(String message, String stacktrace) {
        ErrorCommand command = new ErrorCommand(message, stacktrace);
        this.queue.add(command);
    }

    String GetAppVersion() {
        PackageManager m = this.activity.getPackageManager();
        String app_ver = "";
        try {
            app_ver = m.getPackageInfo((String)this.activity.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return app_ver;
    }

    public static void DetailsReceived(Bundle data) {
        if (GameOfWhales.instanceCheck("DetailsReceived")) {
            INSTANCE.detailsReceived(data);
        }
    }

    public static boolean IsAppForeground() {
        if (INSTANCE == null) {
            return false;
        }
        if (GameOfWhales.INSTANCE.cycleListener == null) {
            return false;
        }
        return GameOfWhales.INSTANCE.cycleListener.isForeground();
    }

    public static GameOfWhales Init(Activity activity, String gameID, GameOfWhalesListener listener) {
        INSTANCE = new GameOfWhales(activity, gameID, listener);
        return INSTANCE;
    }

    public static GameOfWhales Init(Activity activity, GameOfWhalesListener listener) {
        INSTANCE = new GameOfWhales(activity, null, listener);
        return INSTANCE;
    }

    public void addListener(GameOfWhalesListener listener) {
        if (this.listeners == null) {
            L.e(TAG, "Listeners is null from: addListener");
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(GameOfWhalesListener listener) {
        if (this.listeners == null) {
            L.e(TAG, "Listeners is null from: removeListener");
            return;
        }
        this.listeners.remove(listener);
    }

    private void readSpecialOffers(JSONObject object) throws Exception {
        if (object == null) {
            return;
        }
        String id = "specialOffers";
        if (!object.has("specialOffers")) {
            return;
        }
        L.i(TAG, "Reading spectial offers");
        JSONArray array = object.getJSONArray("specialOffers");
        this.specialOfferData.clear();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject jsonSO = array.getJSONObject(i);
            SpecialOfferData so = new SpecialOfferData(jsonSO);
            this.specialOfferData.add(so);
        }
        this.updateSpecialOffers();
    }

    public boolean hasSpecialOffer(String productID) {
        if (this.check("hasSpecialOffer")) {
            return false;
        }
        return this.activeOffers.get(productID) != null;
    }

    SpecialOffer getActiveOfferFor(String product) {
        if (this.check("getActiveOfferFor")) {
            return null;
        }
        return this.activeOffers.get(product);
    }

    void updateSpecialOffers() {
        try {
            SpecialOffer specialOffer;
            HashSet<String> appeared = new HashSet<String>();
            ArrayList<String> removed = new ArrayList<String>();
            for (SpecialOfferData specialOfferData : this.specialOfferData) {
                if (specialOfferData == null || specialOfferData.isExpired() || this.isSpecialOfferUsed(specialOfferData.getId())) continue;
                List<String> products = specialOfferData.getProducts();
                for (String product : products) {
                    boolean add;
                    SpecialOffer currentActiveOffer = this.getActiveOfferFor(product);
                    boolean bl = add = currentActiveOffer == null;
                    if (currentActiveOffer != null) {
                        float newValue;
                        float activeValue = currentActiveOffer.priceFactor == 0.0f ? currentActiveOffer.countFactor : currentActiveOffer.countFactor / currentActiveOffer.priceFactor;
                        float f = newValue = specialOfferData.getPriceFactor() == 0.0f ? specialOfferData.getCountFactor() : specialOfferData.getCountFactor() / specialOfferData.getPriceFactor();
                        if (newValue > activeValue || currentActiveOffer.isExpired()) {
                            add = true;
                        }
                    }
                    if (!add) continue;
                    SpecialOffer offer = new SpecialOffer();
                    offer.campaign = specialOfferData.getId();
                    offer.product = product;
                    offer.priceFactor = specialOfferData.getPriceFactor();
                    offer.countFactor = specialOfferData.getCountFactor();
                    offer.finishedAt = specialOfferData.getFinishedAt();
                    offer.payload = specialOfferData.getPayload();
                    this.activeOffers.put(product, offer);
                    appeared.add(product);
                }
            }
            for (Map.Entry entry : this.activeOffers.entrySet()) {
                SpecialOffer rep = (SpecialOffer)entry.getValue();
                boolean found = false;
                for (SpecialOfferData so : this.specialOfferData) {
                    if (so.isExpired() || this.isSpecialOfferUsed(so.getId())) continue;
                    for (String product : so.getProducts()) {
                        if (!product.equals(rep.product)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (found) continue;
                removed.add(rep.product);
            }
            for (String string : removed) {
                specialOffer = this.getActiveOfferFor(string);
                this.activeOffers.remove(string);
                this.onDisappeared(specialOffer);
            }
            for (String string : appeared) {
                specialOffer = this.getActiveOfferFor(string);
                this.onAppeared(specialOffer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printReport() {
        if (L.isDebug) {
            StringBuilder b = new StringBuilder();
            b.append("\nReport{");
            b.append(String.format("\n  Game id: %s", this.data.getGameID()));
            b.append(String.format("\n  Player id: %s", this.data.getAdvID()));
            b.append("\n  Segments:{");
            for (String seg : this.segments) {
                b.append("\n    " + seg);
            }
            b.append("\n  }");
            b.append("\n  SpecialOffers:{");
            for (SpecialOffer rep : this.getSpecialOffers()) {
                b.append("\n    " + rep.toString());
            }
            b.append("\n  }");
            b.append("\n}");
            L.d(TAG, b.toString());
        }
    }

    private void readVerifyState(JSONObject object) throws Exception {
        String purchases = "receipts";
        String transactionID = "transaction";
        String verifyState = "verifyState";
        if (!object.has("receipts")) {
            return;
        }
        L.i(TAG, "readVerifyState");
        JSONArray purchasesArray = object.getJSONArray("receipts");
        for (int i = 0; i < purchasesArray.length(); ++i) {
            JSONObject item = purchasesArray.getJSONObject(i);
            String tID = item.getString("transaction");
            String state = item.getString("verifyState");
            this.onPurchaseVerified(tID, state);
        }
    }

    private void readSegments(JSONObject object) throws Exception {
        if (object == null) {
            return;
        }
        String id = "segments";
        if (!object.has("segments")) {
            return;
        }
        JSONArray array = object.getJSONArray("segments");
        L.i(TAG, "Reading segments");
        this.segments.clear();
        for (int i = 0; i < array.length(); ++i) {
            String segment = array.getString(i);
            this.segments.add(segment);
        }
    }

    public void detailsReceived(Bundle data) {
        if (this.check("detailsReceived")) {
            return;
        }
        try {
            int response = data.getInt("RESPONSE_CODE");
            if (response != 0) {
                L.e(TAG, "Query product error with response code " + response);
                return;
            }
            ArrayList responseList = data.getStringArrayList("DETAILS_LIST");
            for (String item : responseList) {
                JSONObject json = new JSONObject(item);
                String sku = json.getString("productId");
                Product p = this.getProduct(sku);
                p.setDetails(json);
            }
            this.updateSpecialOffers();
        }
        catch (Exception e) {
            L.e(TAG, "detailsReceived Exception");
            e.printStackTrace();
            return;
        }
    }

    public static void InAppPurchased(String sku, float price, String currency, String transactionId, String receipt) {
        if (GameOfWhales.instanceCheck("InAppPurchased(full args)")) {
            INSTANCE.inAppPurchased(sku, price, currency, transactionId, receipt);
        }
    }

    public void inAppPurchased(String sku, float price, String currency, String transactionId, String receipt) {
        if (this.check("inAppPurchased")) {
            return;
        }
        ReceiptCommand receiptCommand = new ReceiptCommand(transactionId, receipt.toString());
        SpecialOffer offer = this.getSpecialOffer(sku);
        if (offer != null) {
            this.saveUsedSpecialOffer(offer);
            receiptCommand.setCampaign(offer.campaign);
            this.updateSpecialOffers();
        }
        receiptCommand.setPrice(price);
        receiptCommand.setCurrency(currency);
        this.queue.add(receiptCommand);
        this.queue.tryToSendNext();
    }

    public static void SetAndroidProjectID(String id) {
        if (GameOfWhales.instanceCheck("SetAndroidProjectID")) {
            INSTANCE.setAndroidProjectID(id);
        }
    }

    public void setAndroidProjectID(String id) {
        if (id == null || id.isEmpty()) {
            return;
        }
        L.i(TAG, "setAndroidProjectID: " + id);
        Intent intent = new Intent((Context)this.activity, GOWGCMService.class);
        intent.putExtra(INTENT_ANDROID_ID, id);
        this.activity.startService(intent);
    }

    public static void Acquire(String currency, int amount, String source, int number, String place) {
        if (GameOfWhales.instanceCheck("Acquire")) {
            INSTANCE.acquire(currency, amount, source, number, place);
        }
    }

    public void acquire(String currency, int amount, String source, int number, String place) {
        HashMap<String, Integer> resources = new HashMap<String, Integer>();
        resources.put(currency, amount);
        resources.put(source, -number);
        this.converting(resources, place);
    }

    public static void Consume(String currency, int number, String sink, int amount, String place) {
        if (GameOfWhales.instanceCheck("Consume")) {
            INSTANCE.consume(currency, number, sink, amount, place);
        }
    }

    public void consume(String currency, int number, String sink, int amount, String place) {
        HashMap<String, Integer> resources = new HashMap<String, Integer>();
        resources.put(currency, -number);
        resources.put(sink, amount);
        this.converting(resources, place);
    }

    public static void Converting(String resourcesJson, String place) {
        if (GameOfWhales.instanceCheck("Converting(String)")) {
            try {
                HashMap<String, Integer> resources = new HashMap<String, Integer>();
                JSONObject object = new JSONObject(resourcesJson);
                Iterator keysItr = object.keys();
                while (keysItr.hasNext()) {
                    String key = (String)keysItr.next();
                    Object value = object.get(key);
                    resources.put(key, (Integer)value);
                }
                INSTANCE.converting(resources, place);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void Converting(Map<String, Integer> resources, String place) {
        if (GameOfWhales.instanceCheck("Converting(MAP)")) {
            INSTANCE.converting(resources, place);
        }
    }

    public void converting(Map<String, Integer> resources, String place) {
        SpecialOffer offer;
        if (this.check("converting")) {
            return;
        }
        if (resources == null) {
            return;
        }
        if (resources.size() == 0) {
            return;
        }
        ConvertingCommand command = new ConvertingCommand(resources, place);
        ArrayList<String> debits = new ArrayList<String>();
        for (Map.Entry<String, Integer> entry : resources.entrySet()) {
            if (entry.getValue() <= 0) continue;
            debits.add(entry.getKey());
        }
        if (debits.size() == 1 && (offer = this.getSpecialOffer((String)debits.get(0))) != null) {
            command.setCampaign(offer.campaign);
            this.saveUsedSpecialOffer(offer);
            this.updateSpecialOffers();
        }
        this.queue.add(command);
    }

    public static void Profile(String paramsJson) {
        if (GameOfWhales.instanceCheck("Profile String")) {
            INSTANCE.profile(paramsJson);
        }
    }

    public static void Profile(Map<String, Object> params) {
        if (GameOfWhales.instanceCheck("Profile Map")) {
            INSTANCE.profile(params);
        }
    }

    public void readIntent() {
        L.i(TAG, "Read Intent : ");
        Intent intent = this.activity.getIntent();
        if (intent == null || intent.equals(this.lastIntent)) {
            L.i(TAG, "Same intent : ");
            return;
        }
        this.lastIntent = this.activity.getIntent();
        Bundle extras = this.activity.getIntent().getExtras();
        if (extras != null && extras.containsKey(CAMPAIGN_ID)) {
            String campID = extras.getString(CAMPAIGN_ID);
            L.i(TAG, "Campaign ID : " + campID);
            this.pushReacted(campID);
        }
    }

    public void onActivityResumed() {
        L.i(TAG, "onActivityResumed :");
        this.readIntent();
        this.queue.tryToSendNext();
    }

    public void profile(String paramsJSON) {
        ProfileCommand command = new ProfileCommand(paramsJSON);
        this.queue.add(command);
    }

    public void profile(Map<String, Object> changes) {
        if (this.check("profile")) {
            return;
        }
        ProfileCommand command = new ProfileCommand(changes);
        this.queue.add(command);
    }

    public static void InAppPurchased(Intent data) {
        if (GameOfWhales.instanceCheck("InAppPurchased(Intent data)")) {
            INSTANCE.inAppPurchased(data);
        }
    }

    public void inAppPurchased(Intent data) {
        if (this.check("inAppPurchased")) {
            return;
        }
        try {
            int responseCode = data.getIntExtra("RESPONSE_CODE", 0);
            if (responseCode != 0) {
                return;
            }
            String purchaseData = data.getStringExtra("INAPP_PURCHASE_DATA");
            String dataSignature = data.getStringExtra("INAPP_DATA_SIGNATURE");
            JSONObject jo = new JSONObject(purchaseData);
            String sku = jo.getString("productId");
            Product product = this.getProduct(sku);
            try {
                JSONObject payload = new JSONObject();
                payload.put("json", (Object)purchaseData);
                payload.put("signature", (Object)dataSignature);
                JSONObject receipt = new JSONObject(purchaseData);
                String transactionId = receipt.getString("purchaseToken");
                receipt.put("Store", (Object)"GooglePlay");
                receipt.put("TransactionID", (Object)transactionId);
                receipt.put("Payload", (Object)payload.toString());
                float price = 0.0f;
                String currency = "";
                if (product != null && product.hasDetails()) {
                    price = product.getFloatPrice();
                    currency = product.getPriceCurrencyCode();
                }
                this.inAppPurchased(sku, price, currency, transactionId, receipt.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateToken(String token, String provider) {
        if (token == null || token.isEmpty()) {
            return;
        }
        if (provider == null || provider.isEmpty()) {
            return;
        }
        if (this.check("updateToken")) {
            return;
        }
        TokenCommand command = new TokenCommand(token, provider);
        this.queue.add(command);
    }

    public static SpecialOffer GetSpecialOffer(String productID) {
        if (GameOfWhales.instanceCheck("GetSpecialOffer")) {
            return INSTANCE.getSpecialOffer(productID);
        }
        return null;
    }

    public boolean hasSpecialOffers() {
        if (this.check("hasSpecialOffers")) {
            return false;
        }
        return this.activeOffers.size() > 0;
    }

    public Iterable<SpecialOffer> getSpecialOffers() {
        if (this.check("getSpecialOffers")) {
            return null;
        }
        return this.activeOffers.values();
    }

    public SpecialOffer getSpecialOffer(String productID) {
        return this.getActiveOfferFor(productID);
    }

    private void onAppeared(SpecialOffer specialOffer) {
        if (this.listeners == null) {
            L.e(TAG, "Listeners is null from: onAppeared");
            return;
        }
        for (GameOfWhalesListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onSpecialOfferAppeared(specialOffer);
        }
    }

    private void onDisappeared(SpecialOffer specialOffer) {
        if (this.listeners == null) {
            L.e(TAG, "Listeners is null from: onPurchaseVerified");
            return;
        }
        for (GameOfWhalesListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onSpecialOfferDisappeared(specialOffer);
        }
    }

    private void onPurchaseVerified(String transactionID, String state) {
        if (this.listeners == null) {
            L.e(TAG, "Listeners is null from: onPurchaseVerified");
            return;
        }
        for (GameOfWhalesListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onPurchaseVerified(transactionID, state);
        }
    }

    public void notifyPushDelivered(String campID, String title, String message) {
        if (this.listeners == null) {
            L.e(TAG, "Listeners is null from: notifyPushDelivered");
            return;
        }
        for (GameOfWhalesListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onPushDelivered(campID, title, message);
        }
    }

    private void onCommandResponse(Command command, JSONObject response) {
        if (response == null) {
            return;
        }
        L.i(TAG, "onCommandResponse: " + response.toString());
        try {
            this.readSegments(response);
            this.readSpecialOffers(response);
            this.readVerifyState(response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveUsedSpecialOffer(SpecialOffer offer) {
        if (this.check("saveUsedSpecialOffer")) {
            return;
        }
        for (SpecialOfferData ofdata : this.specialOfferData) {
            if (!ofdata.getId().equals(offer.campaign) || !ofdata.isRedeemable()) continue;
            ofdata.setUsed(true);
            this.data.addSpecialOffer(ofdata);
        }
    }

    private boolean isSpecialOfferUsed(String campaingID) {
        if (this.check("isSpecialOfferUsed")) {
            return false;
        }
        SpecialOfferData ofdata = this.data.getSpecialOffer(campaingID);
        if (ofdata != null) {
            return ofdata.isUsed();
        }
        return false;
    }

    private void runUpdate() {
        if (this.batchingHandler == null) {
            L.e(TAG, "batchingHandler is null, from run update");
            return;
        }
        this.batchingHandler.postDelayed(this.updateRunner, 1L);
    }

    private boolean check(String from) {
        if (this.queue == null) {
            L.e(TAG, "Queue is null from: " + from);
            return true;
        }
        if (this.activeOffers == null) {
            L.e(TAG, "Active Offers is null from: " + from);
            return true;
        }
        if (this.data == null) {
            L.e(TAG, "Data is null from: " + from);
            return true;
        }
        if (this.specialOfferData == null) {
            L.e(TAG, "specialOfferData is null from: " + from);
            return true;
        }
        if (this.products == null) {
            L.e(TAG, "products is null from: " + from);
            return true;
        }
        return false;
    }

    public static void SubscribeErrors() {
        L.d(TAG, "ErrorsSubscribe");
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread paramThread, Throwable paramThrowable) {
                if (GameOfWhales.instanceCheck("uncaughtException")) {
                    L.d(GameOfWhales.TAG, "uncaughtException");
                    StackTraceElement[] elements = paramThrowable.getStackTrace();
                    String stacktrace = "";
                    for (StackTraceElement el : elements) {
                        stacktrace = stacktrace + el.toString() + "\n";
                    }
                    ErrorCommand command = new ErrorCommand(paramThrowable.getMessage(), stacktrace);
                    INSTANCE.data.addCommand(command);
                    Intent intent = new Intent((Context)INSTANCE.activity, INSTANCE.activity.getClass());
                    INSTANCE.activity.startActivity(intent);
                    Process.killProcess((int)Process.myPid());
                    System.exit(0);
                }
            }
        });
    }
}

