/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import com.gameofwhales.sdk.L;
import com.gameofwhales.sdk.protocol.commands.Command;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONObject;

public class Utils {
    public static Map<String, Object> jsonToMap(JSONObject json) throws Exception {
        Map<String, Object> retMap = new HashMap<String, Object>();
        if (json != JSONObject.NULL) {
            retMap = Utils.toMap(json);
        }
        return retMap;
    }

    public static Map<String, Object> toMap(JSONObject object) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keysItr = object.keys();
        while (keysItr.hasNext()) {
            String key = (String)keysItr.next();
            List<Object> value = object.get(key);
            if (value instanceof JSONArray) {
                value = Utils.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = Utils.toMap((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    public static List<Object> toList(JSONArray array) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            List<Object> value = array.get(i);
            if (value instanceof JSONArray) {
                value = Utils.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = Utils.toMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }

    public static JSONArray CommandsToJSONArray(List<Command> commands) {
        try {
            JSONArray array = new JSONArray();
            if (commands == null) {
                L.e("ContentValues", "Commands is null from: CommandsToJSONArray");
                return array;
            }
            for (Command command : commands) {
                if (command == null) continue;
                JSONObject object = command.getArgs();
                if (object != null) {
                    array.put((Object)object);
                    continue;
                }
                Log.e((String)"GameOfWhales::Request", (String)"Some command is null");
            }
            return array;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean IsOnline(Context context) {
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo netInfo = cm.getActiveNetworkInfo();
            return netInfo != null && netInfo.isConnectedOrConnecting();
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public static InputStream GetHTTPConnectionInputStream(String urlString) {
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = null;
            connection = urlString.toLowerCase().startsWith("https") ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.connect();
            return connection.getInputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Bitmap FetchBitmap(String urlString) {
        try {
            Log.i((String)"ContentValues", (String)("fetchBitmap: " + urlString));
            InputStream input = Utils.GetHTTPConnectionInputStream(urlString);
            Log.e((String)"ContentValues", (String)"fetch 0");
            BitmapFactory.Options options = new BitmapFactory.Options();
            Bitmap result = BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)options);
            if (result != null) {
                Log.e((String)"ContentValues", (String)("IMAGE DPI: " + result.getDensity() + "  URL: " + urlString));
            } else {
                Log.e((String)"ContentValues", (String)"BitmapDecode returnde null");
            }
            input.close();
            Log.i((String)"ContentValues", (String)"fetchBitmap done!");
            return result;
        }
        catch (IOException e) {
            Log.e((String)"ContentValues", (String)("Error while getting bitmap from: " + urlString));
            e.printStackTrace();
            return null;
        }
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        try {
            int height = options.outHeight;
            int width = options.outWidth;
            int inSampleSize = 1;
            if (height > reqHeight || width > reqWidth) {
                int halfHeight = height / 2;
                int halfWidth = width / 2;
                while (halfHeight / inSampleSize >= reqHeight && halfWidth / inSampleSize >= reqWidth) {
                    inSampleSize *= 2;
                }
            }
            return inSampleSize;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }
}

