/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.util;

import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.gameofwhales.sdk.util.InstallReferrerListener;

public class InstallReferrerHelper {
    private static final String TAG = "IRHelper";
    private static final String REF_FULL_CLASS_InstallReferrerClient = "com.android.installreferrer.api.InstallReferrerClient";
    InstallReferrerClient irClient;
    InstallReferrerListener listener;

    public InstallReferrerHelper(Context context, final InstallReferrerListener listener) {
        try {
            this.listener = listener;
            this.irClient = InstallReferrerClient.newBuilder((Context)context).build();
            Log.i((String)TAG, (String)"startConnection");
            this.irClient.startConnection(new InstallReferrerStateListener(){

                public void onInstallReferrerSetupFinished(int responseCode) {
                    Log.i((String)InstallReferrerHelper.TAG, (String)("onInstallReferrerSetupFinished: " + responseCode));
                    if (responseCode == 0) {
                        try {
                            ReferrerDetails response = InstallReferrerHelper.this.irClient.getInstallReferrer();
                            String referrerUrl = response.getInstallReferrer();
                            if (referrerUrl == null) {
                                referrerUrl = "";
                            }
                            Log.i((String)InstallReferrerHelper.TAG, (String)("onInstallReferrerSetupFinished url: '" + referrerUrl + "'"));
                            listener.OnResult(false, referrerUrl);
                            return;
                        }
                        catch (RemoteException e) {
                            e.printStackTrace();
                        }
                    }
                    listener.OnResult(true, "");
                }

                public void onInstallReferrerServiceDisconnected() {
                    Log.i((String)InstallReferrerHelper.TAG, (String)"onInstallReferrerServiceDisconnected");
                    listener.OnResult(true, "");
                }
            });
        }
        catch (Exception e) {
            Log.i((String)TAG, (String)"EXCEPTION");
            e.printStackTrace();
            this.listener.OnResult(true, "");
        }
    }
}

