/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.protocol.commands;

import com.gameofwhales.sdk.GameOfWhales;
import com.gameofwhales.sdk.protocol.commands.Command;
import org.json.JSONObject;

public class TokenCommand
extends Command {
    public static String ID = "token";
    String token;
    String provider;

    public TokenCommand(String token, String type) {
        this.id = ID;
        this.token = token;
        this.provider = type;
    }

    public TokenCommand(JSONObject object) {
        this.load(object);
    }

    @Override
    public void load(JSONObject object) {
        try {
            this.id = object.getString("event");
            this.at = object.getLong("at");
            if (object.has("order")) {
                this.index = object.getLong("order");
            }
            this.token = object.getString("token");
            this.provider = object.getString("provider");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public JSONObject save() {
        return this.getArgs();
    }

    @Override
    public JSONObject getArgs() {
        try {
            JSONObject args = new JSONObject();
            args.put("event", (Object)this.getID());
            args.put("at", this.getAt());
            args.put("order", this.index);
            if (GameOfWhales.IsPushNotificationEnabled()) {
                args.put("token", (Object)this.token);
            } else {
                args.put("token", (Object)"");
            }
            args.put("provider", (Object)this.provider);
            return args;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

