/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.protocol.commands;

import com.gameofwhales.sdk.protocol.commands.Command;
import org.json.JSONObject;

public class LoginCommand
extends Command {
    public static String ID = "login";
    String model;
    String manufacture;
    String product;
    String brand;
    String device;
    String refUrl;

    public LoginCommand(String model, String manufacture, String product, String brand, String device) {
        this.id = ID;
        this.model = model;
        this.manufacture = manufacture;
        this.product = product;
        this.brand = brand;
        this.device = device;
    }

    public void setRefUrl(String url) {
        this.refUrl = url;
    }

    public LoginCommand(JSONObject object) {
        this.load(object);
    }

    @Override
    public void load(JSONObject object) {
        try {
            this.id = object.getString("event");
            this.at = object.getLong("at");
            if (object.has("order")) {
                this.index = object.getLong("order");
            }
            if (object.has("device")) {
                JSONObject deviceJson = object.getJSONObject("device");
                this.model = deviceJson.getString("model");
                this.manufacture = deviceJson.getString("manufacture");
                this.product = deviceJson.getString("product");
                this.brand = deviceJson.getString("brand");
                this.device = deviceJson.getString("device");
            }
            if (object.has("referrer")) {
                this.refUrl = object.getString("referrer");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public JSONObject save() {
        return this.getArgs();
    }

    @Override
    public JSONObject getArgs() {
        try {
            JSONObject args = new JSONObject();
            args.put("event", (Object)this.getID());
            args.put("at", this.getAt());
            args.put("order", this.index);
            JSONObject deviceJson = new JSONObject();
            deviceJson.put("model", (Object)this.model);
            deviceJson.put("manufacture", (Object)this.manufacture);
            deviceJson.put("product", (Object)this.product);
            deviceJson.put("brand", (Object)this.brand);
            deviceJson.put("device", (Object)this.device);
            args.put("device", (Object)deviceJson);
            if (this.refUrl != null) {
                args.put("referrer", (Object)this.refUrl);
            }
            return args;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

