/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.protocol.commands;

import android.util.Log;
import com.gameofwhales.sdk.protocol.commands.Command;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

public class InstallReferrerCommand
extends Command {
    public static final String ID = "installreferrer";
    private String utm_source;
    private String utm_campaign;
    private String utm_medium;
    private String utm_content;
    private String utm_term;
    private Map<String, Object> extra = new HashMap<String, Object>();

    public InstallReferrerCommand(String utm_source, String utm_campaign, String utm_medium, String utm_content, String utm_term, Map<String, Object> extra) {
        this.id = ID;
        this.utm_source = utm_source;
        this.utm_campaign = utm_campaign;
        this.utm_medium = utm_medium;
        this.utm_content = utm_content;
        this.utm_term = utm_term;
        this.extra = extra;
    }

    public InstallReferrerCommand(JSONObject object) {
        this.load(object);
    }

    @Override
    public void load(JSONObject object) {
        try {
            this.id = object.getString("event");
            this.at = object.getLong("at");
            if (object.has("order")) {
                this.index = object.getLong("order");
            }
            this.utm_source = object.getString("utm_source");
            this.utm_campaign = object.getString("utm_campaign");
            this.utm_medium = object.getString("utm_medium");
            this.utm_content = object.getString("utm_content");
            this.utm_term = object.getString("utm_term");
            JSONObject extraObject = object.getJSONObject("extra");
            Iterator keysItr = extraObject.keys();
            while (keysItr.hasNext()) {
                String key = (String)keysItr.next();
                Object value = extraObject.get(key);
                this.extra.put(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public JSONObject save() {
        return this.getArgs();
    }

    @Override
    public JSONObject getArgs() {
        try {
            JSONObject args = new JSONObject();
            args.put("event", (Object)this.getID());
            args.put("at", this.getAt());
            args.put("order", this.index);
            args.put("utm_source", (Object)this.utm_source);
            args.put("utm_campaign", (Object)this.utm_campaign);
            args.put("utm_medium", (Object)this.utm_medium);
            args.put("utm_content", (Object)this.utm_content);
            args.put("utm_term", (Object)this.utm_term);
            JSONObject extraJson = new JSONObject();
            for (Map.Entry<String, Object> entry : this.extra.entrySet()) {
                extraJson.put(entry.getKey(), entry.getValue());
            }
            args.put("extra", (Object)extraJson);
            return args;
        }
        catch (Exception e) {
            Log.e((String)"InstallReferrerCommand", (String)" json error for");
            e.printStackTrace();
            return null;
        }
    }
}

