/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.protocol.commands;

import android.util.Log;
import com.gameofwhales.sdk.protocol.commands.Command;
import java.util.Map;
import org.json.JSONObject;

public class ConvertingCommand
extends Command {
    public static final String ID = "converting";
    String resources = "{}";
    String place;
    String camp;

    public ConvertingCommand(String resources, String place) {
        this.id = ID;
        this.resources = resources;
        this.place = place;
    }

    public ConvertingCommand(Map<String, Long> resources, String place) {
        this(new JSONObject(resources).toString(), place);
    }

    public ConvertingCommand(JSONObject object) {
        this.load(object);
    }

    public void setCampaign(String campaignID) {
        this.camp = campaignID;
    }

    @Override
    public void load(JSONObject object) {
        try {
            this.id = object.getString("event");
            this.resources = object.getString("resources");
            this.at = object.getLong("at");
            if (object.has("order")) {
                this.index = object.getLong("order");
            }
            this.place = object.getString("place");
            if (object.has("camp")) {
                this.camp = object.getString("camp");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public JSONObject getArgs() {
        try {
            JSONObject args = new JSONObject();
            args.put("event", (Object)this.getID());
            args.put("at", this.getAt());
            args.put("order", this.index);
            args.put("resources", (Object)new JSONObject(this.resources));
            args.put("place", (Object)this.place);
            if (this.camp != null && !this.camp.isEmpty()) {
                args.put("camp", (Object)this.camp);
            }
            return args;
        }
        catch (Exception e) {
            Log.e((String)"GameOfWhales::Convert", (String)(" json error for: place: " + this.place + "   resources: " + this.resources));
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public JSONObject save() {
        return this.getArgs();
    }
}

